/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.gost;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.gost.BCGOST3410PrivateKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.gost.BCGOST3410PublicKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import com.timevale.tgtext.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import com.timevale.tgtext.bouncycastle.jce.interfaces.GOST3410PublicKey;
import com.timevale.tgtext.bouncycastle.jce.spec.GOST3410PrivateKeySpec;
import com.timevale.tgtext.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import com.timevale.tgtext.bouncycastle.jce.spec.GOST3410PublicKeySpec;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    @Override
    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(GOST3410PublicKeySpec.class) && key instanceof GOST3410PublicKey) {
            GOST3410PublicKey k2 = (GOST3410PublicKey)key;
            GOST3410PublicKeyParameterSetSpec parameters = k2.getParameters().getPublicKeyParameters();
            return new GOST3410PublicKeySpec(k2.getY(), parameters.getP(), parameters.getQ(), parameters.getA());
        }
        if (spec.isAssignableFrom(GOST3410PrivateKeySpec.class) && key instanceof GOST3410PrivateKey) {
            GOST3410PrivateKey k3 = (GOST3410PrivateKey)key;
            GOST3410PublicKeyParameterSetSpec parameters = k3.getParameters().getPublicKeyParameters();
            return new GOST3410PrivateKeySpec(k3.getX(), parameters.getP(), parameters.getQ(), parameters.getA());
        }
        return super.engineGetKeySpec(key, spec);
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof GOST3410PublicKey) {
            return new BCGOST3410PublicKey((GOST3410PublicKey)key);
        }
        if (key instanceof GOST3410PrivateKey) {
            return new BCGOST3410PrivateKey((GOST3410PrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof GOST3410PrivateKeySpec) {
            return new BCGOST3410PrivateKey((GOST3410PrivateKeySpec)keySpec);
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof GOST3410PublicKeySpec) {
            return new BCGOST3410PublicKey((GOST3410PublicKeySpec)keySpec);
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new BCGOST3410PrivateKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new BCGOST3410PublicKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }
}

