/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.MessageSigner;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.GMSSUtil;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GMSSSigner
implements MessageSigner {
    private GMSSUtil gmssUtil = new GMSSUtil();
    private byte[] pubKeyBytes;
    private Digest messDigestTrees;
    private int mdLength;
    private int numLayer;
    private Digest messDigestOTS;
    private WinternitzOTSignature ots;
    private GMSSDigestProvider digestProvider;
    private int[] index;
    private byte[][][] currentAuthPaths;
    private byte[][] subtreeRootSig;
    private GMSSParameters gmssPS;
    private GMSSRandom gmssRandom;
    GMSSKeyParameters key;
    private SecureRandom random;

    public GMSSSigner(GMSSDigestProvider digest) {
        this.digestProvider = digest;
        this.messDigestOTS = this.messDigestTrees = digest.get();
        this.mdLength = this.messDigestTrees.getDigestSize();
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (GMSSPrivateKeyParameters)rParam.getParameters();
                this.initSign();
                return;
            }
            this.random = new SecureRandom();
            this.key = (GMSSPrivateKeyParameters)param;
            this.initSign();
            return;
        }
        this.key = (GMSSPublicKeyParameters)param;
        this.initVerify();
    }

    private void initSign() {
        int i2;
        this.messDigestTrees.reset();
        GMSSPrivateKeyParameters gmssPrivateKey = (GMSSPrivateKeyParameters)this.key;
        if (gmssPrivateKey.getIndex(0) >= gmssPrivateKey.getNumLeafs(0)) {
            throw new RuntimeException("No more signatures can be generated");
        }
        this.gmssPS = gmssPrivateKey.getParameters();
        this.numLayer = this.gmssPS.getNumOfLayers();
        byte[] seed = gmssPrivateKey.getCurrentSeeds()[this.numLayer - 1];
        byte[] dummy = new byte[this.mdLength];
        System.arraycopy(seed, 0, dummy, 0, this.mdLength);
        byte[] OTSSeed = this.gmssRandom.nextSeed(dummy);
        this.ots = new WinternitzOTSignature(OTSSeed, this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[this.numLayer - 1]);
        byte[][][] helpCurrentAuthPaths = gmssPrivateKey.getCurrentAuthPaths();
        this.currentAuthPaths = new byte[this.numLayer][][];
        for (int j2 = 0; j2 < this.numLayer; ++j2) {
            this.currentAuthPaths[j2] = new byte[helpCurrentAuthPaths[j2].length][this.mdLength];
            for (i2 = 0; i2 < helpCurrentAuthPaths[j2].length; ++i2) {
                System.arraycopy(helpCurrentAuthPaths[j2][i2], 0, this.currentAuthPaths[j2][i2], 0, this.mdLength);
            }
        }
        this.index = new int[this.numLayer];
        System.arraycopy(gmssPrivateKey.getIndex(), 0, this.index, 0, this.numLayer);
        this.subtreeRootSig = new byte[this.numLayer - 1][];
        for (i2 = 0; i2 < this.numLayer - 1; ++i2) {
            byte[] helpSubtreeRootSig = gmssPrivateKey.getSubtreeRootSig(i2);
            this.subtreeRootSig[i2] = new byte[helpSubtreeRootSig.length];
            System.arraycopy(helpSubtreeRootSig, 0, this.subtreeRootSig[i2], 0, helpSubtreeRootSig.length);
        }
        gmssPrivateKey.nextKey(this.numLayer - 1);
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        byte[] otsSig = this.ots.getSignature(message);
        byte[] authPathBytes = this.gmssUtil.concatenateArray(this.currentAuthPaths[this.numLayer - 1]);
        byte[] indexBytes = this.gmssUtil.intToBytesLittleEndian(this.index[this.numLayer - 1]);
        byte[] gmssSigFirstPart = new byte[indexBytes.length + otsSig.length + authPathBytes.length];
        System.arraycopy(indexBytes, 0, gmssSigFirstPart, 0, indexBytes.length);
        System.arraycopy(otsSig, 0, gmssSigFirstPart, indexBytes.length, otsSig.length);
        System.arraycopy(authPathBytes, 0, gmssSigFirstPart, indexBytes.length + otsSig.length, authPathBytes.length);
        byte[] gmssSigNextPart = new byte[]{};
        for (int i2 = this.numLayer - 1 - 1; i2 >= 0; --i2) {
            authPathBytes = this.gmssUtil.concatenateArray(this.currentAuthPaths[i2]);
            indexBytes = this.gmssUtil.intToBytesLittleEndian(this.index[i2]);
            byte[] helpGmssSig = new byte[gmssSigNextPart.length];
            System.arraycopy(gmssSigNextPart, 0, helpGmssSig, 0, gmssSigNextPart.length);
            gmssSigNextPart = new byte[helpGmssSig.length + indexBytes.length + this.subtreeRootSig[i2].length + authPathBytes.length];
            System.arraycopy(helpGmssSig, 0, gmssSigNextPart, 0, helpGmssSig.length);
            System.arraycopy(indexBytes, 0, gmssSigNextPart, helpGmssSig.length, indexBytes.length);
            System.arraycopy(this.subtreeRootSig[i2], 0, gmssSigNextPart, helpGmssSig.length + indexBytes.length, this.subtreeRootSig[i2].length);
            System.arraycopy(authPathBytes, 0, gmssSigNextPart, helpGmssSig.length + indexBytes.length + this.subtreeRootSig[i2].length, authPathBytes.length);
        }
        byte[] gmssSig = new byte[gmssSigFirstPart.length + gmssSigNextPart.length];
        System.arraycopy(gmssSigFirstPart, 0, gmssSig, 0, gmssSigFirstPart.length);
        System.arraycopy(gmssSigNextPart, 0, gmssSig, gmssSigFirstPart.length, gmssSigNextPart.length);
        return gmssSig;
    }

    private void initVerify() {
        this.messDigestTrees.reset();
        GMSSPublicKeyParameters gmssPublicKey = (GMSSPublicKeyParameters)this.key;
        this.pubKeyBytes = gmssPublicKey.getPublicKey();
        this.gmssPS = gmssPublicKey.getParameters();
        this.numLayer = this.gmssPS.getNumOfLayers();
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        boolean success = false;
        this.messDigestOTS.reset();
        byte[] help = message;
        int nextEntry = 0;
        for (int j2 = this.numLayer - 1; j2 >= 0; --j2) {
            WinternitzOTSVerify otsVerify = new WinternitzOTSVerify(this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[j2]);
            int otsSigLength = otsVerify.getSignatureLength();
            message = help;
            int index = this.gmssUtil.bytesToIntLittleEndian(signature, nextEntry);
            byte[] otsSig = new byte[otsSigLength];
            System.arraycopy(signature, nextEntry += 4, otsSig, 0, otsSigLength);
            nextEntry += otsSigLength;
            byte[] otsPublicKey = otsVerify.Verify(message, otsSig);
            if (otsPublicKey == null) {
                System.err.println("OTS Public Key is null in GMSSSignature.verify");
                return false;
            }
            byte[][] authPath = new byte[this.gmssPS.getHeightOfTrees()[j2]][this.mdLength];
            for (int i2 = 0; i2 < authPath.length; ++i2) {
                System.arraycopy(signature, nextEntry, authPath[i2], 0, this.mdLength);
                nextEntry += this.mdLength;
            }
            help = otsPublicKey;
            int count = 1 << authPath.length;
            count += index;
            for (int i3 = 0; i3 < authPath.length; ++i3) {
                byte[] dest = new byte[this.mdLength << 1];
                if (count % 2 == 0) {
                    System.arraycopy(help, 0, dest, 0, this.mdLength);
                    System.arraycopy(authPath[i3], 0, dest, this.mdLength, this.mdLength);
                    count /= 2;
                } else {
                    System.arraycopy(authPath[i3], 0, dest, 0, this.mdLength);
                    System.arraycopy(help, 0, dest, this.mdLength, help.length);
                    count = (count - 1) / 2;
                }
                this.messDigestTrees.update(dest, 0, dest.length);
                help = new byte[this.messDigestTrees.getDigestSize()];
                this.messDigestTrees.doFinal(help, 0);
            }
        }
        if (Arrays.areEqual(this.pubKeyBytes, help)) {
            success = true;
        }
        return success;
    }
}

