/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cryptopro;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class ECGOST3410ParamSetParameters
extends ASN1Object {
    ASN1Integer p;
    ASN1Integer q;
    ASN1Integer a;
    ASN1Integer b;
    ASN1Integer x;
    ASN1Integer y;

    public static ECGOST3410ParamSetParameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ECGOST3410ParamSetParameters.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static ECGOST3410ParamSetParameters getInstance(Object obj) {
        if (obj == null || obj instanceof ECGOST3410ParamSetParameters) {
            return (ECGOST3410ParamSetParameters)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ECGOST3410ParamSetParameters((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid GOST3410Parameter: " + obj.getClass().getName());
    }

    public ECGOST3410ParamSetParameters(BigInteger a2, BigInteger b2, BigInteger p2, BigInteger q2, int x2, BigInteger y2) {
        this.a = new ASN1Integer(a2);
        this.b = new ASN1Integer(b2);
        this.p = new ASN1Integer(p2);
        this.q = new ASN1Integer(q2);
        this.x = new ASN1Integer(x2);
        this.y = new ASN1Integer(y2);
    }

    public ECGOST3410ParamSetParameters(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        this.a = (ASN1Integer)e2.nextElement();
        this.b = (ASN1Integer)e2.nextElement();
        this.p = (ASN1Integer)e2.nextElement();
        this.q = (ASN1Integer)e2.nextElement();
        this.x = (ASN1Integer)e2.nextElement();
        this.y = (ASN1Integer)e2.nextElement();
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getA() {
        return this.a.getPositiveValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.a);
        v2.add(this.b);
        v2.add(this.p);
        v2.add(this.q);
        v2.add(this.x);
        v2.add(this.y);
        return new DERSequence(v2);
    }
}

