/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime.examples;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.timevale.tgtext.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import com.timevale.tgtext.bouncycastle.asn1.smime.SMIMECapability;
import com.timevale.tgtext.bouncycastle.asn1.smime.SMIMECapabilityVector;
import com.timevale.tgtext.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaCertStore;
import com.timevale.tgtext.bouncycastle.cms.CMSAlgorithm;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEException;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMESignedGenerator;
import com.timevale.tgtext.bouncycastle.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.activation.c;
import javax.activation.n;
import javax.mail.a;
import javax.mail.ad;
import javax.mail.ao;
import javax.mail.internet.f;
import javax.mail.internet.j;
import javax.mail.internet.k;
import javax.mail.internet.l;
import javax.mail.m;
import javax.mail.s;

public class SendSignedAndEncryptedMail {
    public static void main(String[] stringArray) {
        if (stringArray.length != 5) {
            System.err.println("usage: SendSignedAndEncryptedMail <pkcs12Keystore> <password> <keyalias> <smtp server> <email address>");
            System.exit(0);
        }
        try {
            n n2 = (n)c.a();
            n2.d("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
            n2.d("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
            n2.d("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
            n2.d("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
            n2.d("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
            c.a((c)n2);
            Security.addProvider(new BouncyCastleProvider());
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            keyStore.load(new FileInputStream(stringArray[0]), stringArray[1].toCharArray());
            Certificate[] certificateArray = keyStore.getCertificateChain(stringArray[2]);
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(stringArray[2], stringArray[1].toCharArray());
            if (privateKey == null) {
                throw new Exception("cannot find private key for alias: " + stringArray[2]);
            }
            Properties properties = System.getProperties();
            properties.put("mail.smtp.host", stringArray[3]);
            ad ad2 = ad.b((Properties)properties, null);
            k k2 = new k(ad2);
            k2.a((a)new f(stringArray[4]));
            k2.a(m.a.a, (a)new f(stringArray[4]));
            k2.e("example encrypted message");
            k2.setContent((Object)"example encrypted message", "text/plain");
            k2.b_();
            SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
            sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new SMIMEEncryptionKeyPreferenceAttribute(new IssuerAndSerialNumber(new X500Name(((X509Certificate)certificateArray[0]).getIssuerDN().getName()), ((X509Certificate)certificateArray[0]).getSerialNumber())));
            aSN1EncodableVector.add(new SMIMECapabilitiesAttribute(sMIMECapabilityVector));
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(aSN1EncodableVector)).build("DSA".equals(privateKey.getAlgorithm()) ? "SHA1withDSA" : "MD5withDSA", privateKey, (X509Certificate)certificateArray[0]));
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            arrayList.add(certificateArray[0]);
            JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
            sMIMESignedGenerator.addCertificates(jcaCertStore);
            l l2 = sMIMESignedGenerator.generate(k2, "BC");
            k k3 = new k(ad2);
            Enumeration enumeration = k2.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                k3.addHeaderLine((String)enumeration.nextElement());
            }
            k3.setContent((s)l2);
            k3.b_();
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator((X509Certificate)certificateArray[0]).setProvider("BC"));
            j j2 = sMIMEEnvelopedGenerator.generate(k3, new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC).setProvider("BC").build());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            j2.writeTo((OutputStream)byteArrayOutputStream);
            k k4 = new k(ad2, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            enumeration = k2.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (Strings.toLowerCase(string).startsWith("content-")) continue;
                k4.addHeaderLine(string);
            }
            ao.a((m)k4);
            return;
        }
        catch (SMIMEException sMIMEException) {
            SMIMEException sMIMEException2 = sMIMEException;
            sMIMEException.getUnderlyingException().printStackTrace(System.err);
            sMIMEException2.printStackTrace(System.err);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace(System.err);
            return;
        }
    }
}

