/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.core.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.adapay.core.AdapayCore;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.exception.FailureCode;
import com.huifu.adapay.core.util.AdapaySign;
import com.huifu.adapay.core.util.HttpClientUtils;
import com.huifu.adapay.core.util.ServerTypeEnum;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRequest {
    private static final String AUTHORIZATION = "Authorization";
    private static final String SIGNATURE = "Signature";
    private static final String SDK_VERSION = "SDK_Version";

    protected static Map<String, Object> requestAdapayCore(RequestMethod method, String uri, Map<String, Object> params, String privateKey, String apiKey) throws BaseAdaPayException {
        return AbstractRequest.requestAdapayCore(method, uri, params, null, null, privateKey, apiKey, null);
    }

    protected static Map<String, Object> requestAdapayCore(RequestMethod method, String uri, Map<String, Object> params, String privateKey, String apiKey, ServerTypeEnum serverType) throws BaseAdaPayException {
        return AbstractRequest.requestAdapayCore(method, uri, params, null, null, privateKey, apiKey, serverType);
    }

    protected static Map<String, Object> requestAdapayCore(RequestMethod method, String uri, Map<String, Object> params, File file, String fileParam, String privateKey, String apiKey, ServerTypeEnum serverType) throws BaseAdaPayException {
        boolean checkSign;
        String requestSign;
        String baseUrl = AdapayCore.apiBase;
        if (ServerTypeEnum.PAGE.equals((Object)serverType)) {
            baseUrl = AdapayCore.pageBase;
        }
        StringBuilder requestUrl = new StringBuilder(baseUrl).append(uri);
        String back = null;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        String originalStr = "";
        if (RequestMethod.POST == method && file == null) {
            originalStr = params.isEmpty() ? "" : JSONObject.toJSONString(params);
        } else if (RequestMethod.POST == method && file != null) {
            originalStr = params.isEmpty() ? "" : AdapaySign.getOriginalStr(params);
        } else if (RequestMethod.GET == method) {
            String string = originalStr = params.isEmpty() ? "" : AdapaySign.getOriginalStr(params);
        }
        if (AdapayCore.debug) {
            System.out.println("request string=" + originalStr);
        }
        try {
            requestSign = AdapaySign.sign(requestUrl + originalStr, privateKey);
        }
        catch (Exception e) {
            requestSign = null;
        }
        if (requestSign == null || requestSign.length() == 0) {
            throw new BaseAdaPayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "Sign error. Please check your privateKey.");
        }
        headers.put(AUTHORIZATION, apiKey);
        headers.put(SIGNATURE, requestSign);
        headers.put(SDK_VERSION, AdapayCore.sdkVersion);
        if (AdapayCore.debug) {
            System.out.println("request apiKey=" + apiKey);
            System.out.println("request SIGNATURE=" + requestSign);
            System.out.println("request SDK_VERSION=" + AdapayCore.sdkVersion);
        }
        if (RequestMethod.POST == method && file == null) {
            headers.put("Content-type", "application/json");
            back = HttpClientUtils.httpPostJson(requestUrl.toString(), headers, originalStr);
        } else if (RequestMethod.POST == method && file != null) {
            back = HttpClientUtils.httpPostFile(requestUrl.toString(), headers, params, file, fileParam);
        } else if (RequestMethod.GET == method) {
            back = HttpClientUtils.httpGet(requestUrl.toString(), headers, params);
        }
        if (AdapayCore.debug) {
            System.out.println("post back=" + back);
        }
        if (back == null || back.length() == 0) {
            throw new BaseAdaPayException(FailureCode.SYSTEM_EXCEPTION.getFailureCode(), "Request no response. Please check your network.");
        }
        JSONObject jsonObject = JSON.parseObject((String)back);
        String data = jsonObject.getString("data");
        String signature = jsonObject.getString("signature");
        try {
            String publicKey = AdapayCore.PUBLIC_KEY;
            checkSign = AdapaySign.verifySign(data, signature, publicKey);
        }
        catch (Exception e) {
            checkSign = false;
        }
        if (!checkSign) {
            if (AdapayCore.debug) {
                System.out.println("PUBLIC_KEY:" + AdapayCore.PUBLIC_KEY);
            }
            throw new BaseAdaPayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "Response sign check error. Please check your pubkey.");
        }
        try {
            JSONObject dataJson;
            JSONObject dataMap = dataJson = JSONObject.parseObject((String)data);
            return dataMap;
        }
        catch (Exception e) {
            throw new BaseAdaPayException(FailureCode.SYSTEM_EXCEPTION.getFailureCode(), "Parse response error." + e.getMessage());
        }
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

