/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.core.util;

import com.huifu.adapay.core.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class AdapaySign {
    public static String sign(String content, String privateKey) throws Exception {
        return AdapaySign.sign(content, privateKey, "UTF-8");
    }

    public static boolean verifySign(String content, String sign, String publicKey) throws Exception {
        return AdapaySign.verifySign(content, sign, publicKey, "UTF-8");
    }

    public static String sign(String content, String privateKey, String charset) throws Exception {
        try {
            PrivateKey priKey = AdapaySign.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(priKey);
            if (charset == null || charset.length() == 0) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64((byte[])signed));
        }
        catch (Exception var6) {
            throw new Exception("RSAcontent = " + content + "; charset = " + charset, var6);
        }
    }

    public static boolean verifySign(String content, String sign, String publicKey, String charset) throws Exception {
        try {
            PublicKey pubKey = AdapaySign.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(pubKey);
            if (charset == null || charset.length() == 0) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64((byte[])sign.getBytes()));
        }
        catch (Exception var6) {
            throw new Exception("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, var6);
        }
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        boolean validKey;
        boolean bl = validKey = ins != null && algorithm != null || algorithm.length() != 0;
        if (validKey) {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = StreamUtil.readText(ins).getBytes();
            encodedKey = Base64.decodeBase64((byte[])encodedKey);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        return null;
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static String getOriginalStr(Map<String, Object> map) {
        ArrayList<String> listKeys = new ArrayList<String>(map.keySet());
        Collections.sort(listKeys);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < listKeys.size(); ++i) {
            if (map.get(listKeys.get(i)) == null || map.get(listKeys.get(i)).toString().length() == 0) continue;
            stringBuilder.append((String)listKeys.get(i)).append("=").append(map.get(listKeys.get(i))).append("&");
        }
        return stringBuilder.length() == 0 ? "" : stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }
}

