/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ntru.polynomial;

import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.BigDecimalPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Constants;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;

public class BigIntPolynomial {
    private static final double LOG_10_2 = Math.log10(2.0);
    BigInteger[] coeffs;

    BigIntPolynomial(int N) {
        this.coeffs = new BigInteger[N];
        for (int i2 = 0; i2 < N; ++i2) {
            this.coeffs[i2] = Constants.BIGINT_ZERO;
        }
    }

    BigIntPolynomial(BigInteger[] coeffs) {
        this.coeffs = coeffs;
    }

    public BigIntPolynomial(IntegerPolynomial p2) {
        this.coeffs = new BigInteger[p2.coeffs.length];
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            this.coeffs[i2] = BigInteger.valueOf(p2.coeffs[i2]);
        }
    }

    static BigIntPolynomial generateRandomSmall(int N, int numOnes, int numNegOnes) {
        int i2;
        ArrayList<BigInteger> coeffs = new ArrayList<BigInteger>();
        for (i2 = 0; i2 < numOnes; ++i2) {
            coeffs.add(Constants.BIGINT_ONE);
        }
        for (i2 = 0; i2 < numNegOnes; ++i2) {
            coeffs.add(BigInteger.valueOf(-1L));
        }
        while (coeffs.size() < N) {
            coeffs.add(Constants.BIGINT_ZERO);
        }
        Collections.shuffle(coeffs, new SecureRandom());
        BigIntPolynomial poly = new BigIntPolynomial(N);
        for (int i3 = 0; i3 < coeffs.size(); ++i3) {
            poly.coeffs[i3] = (BigInteger)coeffs.get(i3);
        }
        return poly;
    }

    public BigIntPolynomial mult(BigIntPolynomial poly2) {
        int N = this.coeffs.length;
        if (poly2.coeffs.length != N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        BigIntPolynomial c2 = this.multRecursive(poly2);
        if (c2.coeffs.length > N) {
            for (int k2 = N; k2 < c2.coeffs.length; ++k2) {
                c2.coeffs[k2 - N] = c2.coeffs[k2 - N].add(c2.coeffs[k2]);
            }
            c2.coeffs = Arrays.copyOf(c2.coeffs, N);
        }
        return c2;
    }

    private BigIntPolynomial multRecursive(BigIntPolynomial poly2) {
        int i2;
        BigInteger[] a2 = this.coeffs;
        BigInteger[] b2 = poly2.coeffs;
        int n2 = poly2.coeffs.length;
        if (n2 <= 1) {
            BigInteger[] c2 = Arrays.clone(this.coeffs);
            for (int i3 = 0; i3 < this.coeffs.length; ++i3) {
                c2[i3] = c2[i3].multiply(poly2.coeffs[0]);
            }
            return new BigIntPolynomial(c2);
        }
        int n1 = n2 / 2;
        BigIntPolynomial a1 = new BigIntPolynomial(Arrays.copyOf(a2, n1));
        BigIntPolynomial a22 = new BigIntPolynomial(Arrays.copyOfRange(a2, n1, n2));
        BigIntPolynomial b1 = new BigIntPolynomial(Arrays.copyOf(b2, n1));
        BigIntPolynomial b22 = new BigIntPolynomial(Arrays.copyOfRange(b2, n1, n2));
        BigIntPolynomial A = (BigIntPolynomial)a1.clone();
        A.add(a22);
        BigIntPolynomial B = (BigIntPolynomial)b1.clone();
        B.add(b22);
        BigIntPolynomial c1 = a1.multRecursive(b1);
        BigIntPolynomial c2 = a22.multRecursive(b22);
        BigIntPolynomial c3 = A.multRecursive(B);
        c3.sub(c1);
        c3.sub(c2);
        BigIntPolynomial c4 = new BigIntPolynomial(2 * n2 - 1);
        for (i2 = 0; i2 < c1.coeffs.length; ++i2) {
            c4.coeffs[i2] = c1.coeffs[i2];
        }
        for (i2 = 0; i2 < c3.coeffs.length; ++i2) {
            c4.coeffs[n1 + i2] = c4.coeffs[n1 + i2].add(c3.coeffs[i2]);
        }
        for (i2 = 0; i2 < c2.coeffs.length; ++i2) {
            c4.coeffs[2 * n1 + i2] = c4.coeffs[2 * n1 + i2].add(c2.coeffs[i2]);
        }
        return c4;
    }

    void add(BigIntPolynomial b2, BigInteger modulus) {
        this.add(b2);
        this.mod(modulus);
    }

    public void add(BigIntPolynomial b2) {
        if (b2.coeffs.length > this.coeffs.length) {
            int N = this.coeffs.length;
            this.coeffs = Arrays.copyOf(this.coeffs, b2.coeffs.length);
            for (int i2 = N; i2 < this.coeffs.length; ++i2) {
                this.coeffs[i2] = Constants.BIGINT_ZERO;
            }
        }
        for (int i3 = 0; i3 < b2.coeffs.length; ++i3) {
            this.coeffs[i3] = this.coeffs[i3].add(b2.coeffs[i3]);
        }
    }

    public void sub(BigIntPolynomial b2) {
        if (b2.coeffs.length > this.coeffs.length) {
            int N = this.coeffs.length;
            this.coeffs = Arrays.copyOf(this.coeffs, b2.coeffs.length);
            for (int i2 = N; i2 < this.coeffs.length; ++i2) {
                this.coeffs[i2] = Constants.BIGINT_ZERO;
            }
        }
        for (int i3 = 0; i3 < b2.coeffs.length; ++i3) {
            this.coeffs[i3] = this.coeffs[i3].subtract(b2.coeffs[i3]);
        }
    }

    public void mult(BigInteger factor) {
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            this.coeffs[i2] = this.coeffs[i2].multiply(factor);
        }
    }

    void mult(int factor) {
        this.mult(BigInteger.valueOf(factor));
    }

    public void div(BigInteger divisor) {
        BigInteger d2 = divisor.add(Constants.BIGINT_ONE).divide(BigInteger.valueOf(2L));
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            this.coeffs[i2] = this.coeffs[i2].compareTo(Constants.BIGINT_ZERO) > 0 ? this.coeffs[i2].add(d2) : this.coeffs[i2].add(d2.negate());
            this.coeffs[i2] = this.coeffs[i2].divide(divisor);
        }
    }

    public BigDecimalPolynomial div(BigDecimal divisor, int decimalPlaces) {
        BigInteger max = this.maxCoeffAbs();
        int coeffLength = (int)((double)max.bitLength() * LOG_10_2) + 1;
        BigDecimal factor = Constants.BIGDEC_ONE.divide(divisor, coeffLength + decimalPlaces + 1, 6);
        BigDecimalPolynomial p2 = new BigDecimalPolynomial(this.coeffs.length);
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            p2.coeffs[i2] = new BigDecimal(this.coeffs[i2]).multiply(factor).setScale(decimalPlaces, 6);
        }
        return p2;
    }

    public int getMaxCoeffLength() {
        return (int)((double)this.maxCoeffAbs().bitLength() * LOG_10_2) + 1;
    }

    private BigInteger maxCoeffAbs() {
        BigInteger max = this.coeffs[0].abs();
        for (int i2 = 1; i2 < this.coeffs.length; ++i2) {
            BigInteger coeff = this.coeffs[i2].abs();
            if (coeff.compareTo(max) <= 0) continue;
            max = coeff;
        }
        return max;
    }

    public void mod(BigInteger modulus) {
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            this.coeffs[i2] = this.coeffs[i2].mod(modulus);
        }
    }

    BigInteger sumCoeffs() {
        BigInteger sum = Constants.BIGINT_ZERO;
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            sum = sum.add(this.coeffs[i2]);
        }
        return sum;
    }

    public Object clone() {
        return new BigIntPolynomial((BigInteger[])this.coeffs.clone());
    }

    public int hashCode() {
        int result = 31 + Arrays.hashCode(this.coeffs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntPolynomial other = (BigIntPolynomial)obj;
        return Arrays.areEqual(this.coeffs, other.coeffs);
    }

    public BigInteger[] getCoeffs() {
        return Arrays.clone(this.coeffs);
    }
}

