/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.BEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class BERConstructedOctetString
extends BEROctetString {
    private static final int MAX_LENGTH = 1000;
    private Vector octs;

    private static byte[] toBytes(Vector octs) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != octs.size(); ++i2) {
            try {
                DEROctetString o2 = (DEROctetString)octs.elementAt(i2);
                bOut.write(o2.getOctets());
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(octs.elementAt(i2).getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException e2) {
                throw new IllegalArgumentException("exception converting octets " + e2.toString());
            }
        }
        return bOut.toByteArray();
    }

    public BERConstructedOctetString(byte[] string) {
        super(string);
    }

    public BERConstructedOctetString(Vector octs) {
        super(BERConstructedOctetString.toBytes(octs));
        this.octs = octs;
    }

    public BERConstructedOctetString(ASN1Primitive obj) {
        super(BERConstructedOctetString.toByteArray(obj));
    }

    private static byte[] toByteArray(ASN1Primitive obj) {
        try {
            return obj.getEncoded();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to encode object");
        }
    }

    public BERConstructedOctetString(ASN1Encodable obj) {
        this(obj.toASN1Primitive());
    }

    @Override
    public byte[] getOctets() {
        return this.string;
    }

    @Override
    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return this.octs.elements();
    }

    private Vector generateOcts() {
        Vector<DEROctetString> vec = new Vector<DEROctetString>();
        for (int i2 = 0; i2 < this.string.length; i2 += 1000) {
            int end = i2 + 1000 > this.string.length ? this.string.length : i2 + 1000;
            byte[] nStr = new byte[end - i2];
            System.arraycopy(this.string, i2, nStr, 0, nStr.length);
            vec.addElement(new DEROctetString(nStr));
        }
        return vec;
    }

    public static BEROctetString fromSequence(ASN1Sequence seq) {
        Vector v2 = new Vector();
        Enumeration e2 = seq.getObjects();
        while (e2.hasMoreElements()) {
            v2.addElement(e2.nextElement());
        }
        return new BERConstructedOctetString(v2);
    }
}

