/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.operator.jcajce;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import cfca.sadk.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import cfca.sadk.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import cfca.sadk.org.bouncycastle.operator.AsymmetricKeyUnwrapper;
import cfca.sadk.org.bouncycastle.operator.GenericKey;
import cfca.sadk.org.bouncycastle.operator.OperatorException;
import cfca.sadk.org.bouncycastle.operator.jcajce.JceGenericKey;
import cfca.sadk.org.bouncycastle.operator.jcajce.OperatorHelper;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class JceAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private Map extraMappings = new HashMap();
    private PrivateKey privKey;

    public JceAsymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privKey) {
        super(algorithmIdentifier);
        this.privKey = privKey;
    }

    public JceAsymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        this.extraMappings.put(algorithm, algorithmName);
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        try {
            Key sKey = null;
            Cipher keyCipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
            AlgorithmParameters algParams = this.helper.createAlgorithmParameters(this.getAlgorithmIdentifier());
            try {
                if (algParams != null) {
                    keyCipher.init(4, (Key)this.privKey, algParams);
                } else {
                    keyCipher.init(4, this.privKey);
                }
                sKey = keyCipher.unwrap(encryptedKey, this.helper.getKeyAlgorithmName(encryptedKeyAlgorithm.getAlgorithm()), 3);
            }
            catch (GeneralSecurityException e) {
            }
            catch (IllegalStateException e) {
            }
            catch (UnsupportedOperationException e) {
            }
            catch (ProviderException e) {
                // empty catch block
            }
            if (sKey == null) {
                keyCipher.init(2, this.privKey);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), encryptedKeyAlgorithm.getAlgorithm().getId());
            }
            return new JceGenericKey(encryptedKeyAlgorithm, sKey);
        }
        catch (InvalidKeyException e) {
            throw new OperatorException("key invalid: " + e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new OperatorException("illegal blocksize: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new OperatorException("bad padding: " + e.getMessage(), e);
        }
    }
}

