/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ntru.util;

import com.timevale.tgtext.bouncycastle.math.ntru.euclid.IntEuclidean;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.DenseTernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.SparseTernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.TernaryPolynomial;
import com.timevale.tgtext.bouncycastle.util.Integers;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;

public class Util {
    private static volatile boolean IS_64_BITNESS_KNOWN;
    private static volatile boolean IS_64_BIT_JVM;

    public static int invert(int n2, int modulus) {
        if ((n2 %= modulus) < 0) {
            n2 += modulus;
        }
        return IntEuclidean.calculate((int)n2, (int)modulus).x;
    }

    public static int pow(int a2, int b2, int modulus) {
        int p2 = 1;
        for (int i2 = 0; i2 < b2; ++i2) {
            p2 = p2 * a2 % modulus;
        }
        return p2;
    }

    public static long pow(long a2, int b2, long modulus) {
        long p2 = 1L;
        for (int i2 = 0; i2 < b2; ++i2) {
            p2 = p2 * a2 % modulus;
        }
        return p2;
    }

    public static TernaryPolynomial generateRandomTernary(int N, int numOnes, int numNegOnes, boolean sparse, SecureRandom random) {
        if (sparse) {
            return SparseTernaryPolynomial.generateRandom(N, numOnes, numNegOnes, random);
        }
        return DenseTernaryPolynomial.generateRandom(N, numOnes, numNegOnes, random);
    }

    public static int[] generateRandomTernary(int N, int numOnes, int numNegOnes, SecureRandom random) {
        int i2;
        Integer one = Integers.valueOf(1);
        Integer minusOne = Integers.valueOf(-1);
        Integer zero = Integers.valueOf(0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i2 = 0; i2 < numOnes; ++i2) {
            list.add(one);
        }
        for (i2 = 0; i2 < numNegOnes; ++i2) {
            list.add(minusOne);
        }
        while (list.size() < N) {
            list.add(zero);
        }
        Collections.shuffle(list, random);
        int[] arr = new int[N];
        for (int i3 = 0; i3 < N; ++i3) {
            arr[i3] = (Integer)list.get(i3);
        }
        return arr;
    }

    public static boolean is64BitJVM() {
        if (!IS_64_BITNESS_KNOWN) {
            String arch = System.getProperty("os.arch");
            String sunModel = System.getProperty("sun.arch.data.model");
            IS_64_BIT_JVM = "amd64".equals(arch) || "x86_64".equals(arch) || "ppc64".equals(arch) || "64".equals(sunModel);
            IS_64_BITNESS_KNOWN = true;
        }
        return IS_64_BIT_JVM;
    }

    public static byte[] readFullLength(InputStream is, int length) throws IOException {
        byte[] arr = new byte[length];
        if (is.read(arr) != length) {
            throw new IOException("Not enough bytes to read.");
        }
        return arr;
    }
}

