/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.timevale.tgtext.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.RecipientIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedStream;
import com.timevale.tgtext.bouncycastle.cms.KeyTransRecipient;
import com.timevale.tgtext.bouncycastle.cms.KeyTransRecipientId;
import com.timevale.tgtext.bouncycastle.cms.Recipient;
import com.timevale.tgtext.bouncycastle.cms.RecipientInformation;
import com.timevale.tgtext.bouncycastle.cms.RecipientOperator;
import com.timevale.tgtext.bouncycastle.cms.a;
import com.timevale.tgtext.bouncycastle.cms.d;
import com.timevale.tgtext.bouncycastle.cms.g;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKeyTransAuthenticatedRecipient;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKeyTransRecipient;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier messageAlgorithm, g secureReadable, a additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        RecipientIdentifier r2 = info.getRecipientIdentifier();
        if (r2.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance(r2.getId());
            this.rid = new KeyTransRecipientId(octs.getOctets());
            return;
        }
        IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r2.getId());
        this.rid = new KeyTransRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, i.a(prov));
    }

    @Override
    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            JceKeyTransRecipient recipient = this.secureReadable instanceof d.c ? new JceKeyTransEnvelopedRecipient((PrivateKey)key) : new JceKeyTransAuthenticatedRecipient((PrivateKey)key);
            if (prov != null) {
                recipient.setProvider(prov);
                if (prov.getName().equalsIgnoreCase("SunJCE")) {
                    recipient.setContentProvider((String)null);
                }
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e2) {
            throw new CMSException("encoding error: " + e2.getMessage(), e2);
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

