/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls;

import cfca.sadk.org.bouncycastle.crypto.DSA;
import cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.signers.ECDSASigner;
import cfca.sadk.org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsDSASigner;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof ECPublicKeyParameters;
    }

    protected DSA createDSAImpl(short hashAlgorithm) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(hashAlgorithm)));
    }

    protected short getSignatureAlgorithm() {
        return 3;
    }
}

