/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DEROutputStream;
import com.timevale.tgtext.bouncycastle.asn1.DLOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASN1OutputStream {
    private OutputStream os;

    public ASN1OutputStream(OutputStream os) {
        this.os = os;
    }

    void writeLength(int length) throws IOException {
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            this.write((byte)(size | 0x80));
            for (int i2 = size - 1 << 3; i2 >= 0; i2 -= 8) {
                this.write((byte)(length >> i2));
            }
            return;
        }
        this.write((byte)length);
    }

    void write(int b2) throws IOException {
        this.os.write(b2);
    }

    void write(byte[] bytes) throws IOException {
        this.os.write(bytes);
    }

    void write(byte[] bytes, int off, int len) throws IOException {
        this.os.write(bytes, off, len);
    }

    void writeEncoded(int tag, byte[] bytes) throws IOException {
        this.write(tag);
        this.writeLength(bytes.length);
        this.write(bytes);
    }

    void writeTag(int flags, int tagNo) throws IOException {
        if (tagNo < 31) {
            this.write(flags | tagNo);
            return;
        }
        this.write(flags | 0x1F);
        if (tagNo < 128) {
            this.write(tagNo);
            return;
        }
        byte[] stack = new byte[5];
        int pos = 5;
        --pos;
        stack[4] = (byte)(tagNo & 0x7F);
        do {
            stack[--pos] = (byte)((tagNo >>= 7) & 0x7F | 0x80);
        } while (tagNo > 127);
        this.write(stack, pos, 5 - pos);
    }

    void writeEncoded(int flags, int tagNo, byte[] bytes) throws IOException {
        this.writeTag(flags, tagNo);
        this.writeLength(bytes.length);
        this.write(bytes);
    }

    protected void writeNull() throws IOException {
        this.os.write(5);
        this.os.write(0);
    }

    public void writeObject(ASN1Encodable obj) throws IOException {
        if (obj != null) {
            obj.toASN1Primitive().encode(this);
            return;
        }
        throw new IOException("null object detected");
    }

    void writeImplicitObject(ASN1Primitive obj) throws IOException {
        if (obj != null) {
            obj.encode(new a(this.os));
            return;
        }
        throw new IOException("null object detected");
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    ASN1OutputStream getDERSubStream() {
        return new DEROutputStream(this.os);
    }

    ASN1OutputStream getDLSubStream() {
        return new DLOutputStream(this.os);
    }

    private class a
    extends ASN1OutputStream {
        private boolean b;

        public a(OutputStream os) {
            super(os);
            this.b = true;
        }

        @Override
        public void write(int b2) throws IOException {
            if (this.b) {
                this.b = false;
                return;
            }
            super.write(b2);
        }
    }
}

