/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1String;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.i;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Strings;
import java.io.IOException;

public class DERT61String
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERT61String getInstance(Object obj) {
        if (obj == null || obj instanceof DERT61String) {
            return (DERT61String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERT61String)DERT61String.fromByteArray((byte[])obj);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e2.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERT61String getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERT61String) {
            return DERT61String.getInstance(o2);
        }
        return new DERT61String(ASN1OctetString.getInstance(o2).getOctets());
    }

    DERT61String(byte[] string) {
        this.string = string;
    }

    public DERT61String(String string) {
        this.string = Strings.toUTF8ByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromUTF8ByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + i.a(this.string.length) + this.string.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(20, this.string);
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERT61String)) {
            return false;
        }
        return Arrays.areEqual(this.string, ((DERT61String)o2).string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }
}

