/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.digests;

import com.timevale.tgtext.bouncycastle.crypto.digests.GeneralDigest;

public class RIPEMD128Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 16;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int[] X = new int[16];
    private int xOff;

    public RIPEMD128Digest() {
        this.reset();
    }

    public RIPEMD128Digest(RIPEMD128Digest t2) {
        super(t2);
        this.H0 = t2.H0;
        this.H1 = t2.H1;
        this.H2 = t2.H2;
        this.H3 = t2.H3;
        System.arraycopy(t2.X, 0, this.X, 0, t2.X.length);
        this.xOff = t2.xOff;
    }

    @Override
    public String getAlgorithmName() {
        return "RIPEMD128";
    }

    @Override
    public int getDigestSize() {
        return 16;
    }

    @Override
    protected void processWord(byte[] in, int inOff) {
        this.X[this.xOff++] = in[inOff] & 0xFF | (in[inOff + 1] & 0xFF) << 8 | (in[inOff + 2] & 0xFF) << 16 | (in[inOff + 3] & 0xFF) << 24;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)bitLength;
        this.X[15] = (int)(bitLength >>> 32);
    }

    private void unpackWord(int word, byte[] out, int outOff) {
        out[outOff] = (byte)word;
        out[outOff + 1] = (byte)(word >>> 8);
        out[outOff + 2] = (byte)(word >>> 16);
        out[outOff + 3] = word >> 24;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        this.unpackWord(this.H0, out, outOff);
        this.unpackWord(this.H1, out, outOff + 4);
        this.unpackWord(this.H2, out, outOff + 8);
        this.unpackWord(this.H3, out, outOff + 12);
        this.reset();
        return 16;
    }

    @Override
    public void reset() {
        super.reset();
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }

    private int RL(int x2, int n2) {
        return x2 << n2 | x2 >>> 32 - n2;
    }

    private int f1(int x2, int y2, int z2) {
        return x2 ^ y2 ^ z2;
    }

    private int f2(int x2, int y2, int z2) {
        return x2 & y2 | ~x2 & z2;
    }

    private int f3(int x2, int y2, int z2) {
        return (x2 | ~y2) ^ z2;
    }

    private int f4(int x2, int y2, int z2) {
        return x2 & z2 | y2 & ~z2;
    }

    private int F1(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f1(b2, c2, d2) + x2, s2);
    }

    private int F2(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f2(b2, c2, d2) + x2 + 1518500249, s2);
    }

    private int F3(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f3(b2, c2, d2) + x2 + 1859775393, s2);
    }

    private int F4(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f4(b2, c2, d2) + x2 + -1894007588, s2);
    }

    private int FF1(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f1(b2, c2, d2) + x2, s2);
    }

    private int FF2(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f2(b2, c2, d2) + x2 + 1836072691, s2);
    }

    private int FF3(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f3(b2, c2, d2) + x2 + 1548603684, s2);
    }

    private int FF4(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f4(b2, c2, d2) + x2 + 1352829926, s2);
    }

    @Override
    protected void processBlock() {
        int dd2;
        int cc2;
        int bb2;
        int aa2;
        int a2 = aa2 = this.H0;
        int b2 = bb2 = this.H1;
        int c2 = cc2 = this.H2;
        int d2 = dd2 = this.H3;
        a2 = this.F1(a2, b2, c2, d2, this.X[0], 11);
        d2 = this.F1(d2, a2, b2, c2, this.X[1], 14);
        c2 = this.F1(c2, d2, a2, b2, this.X[2], 15);
        b2 = this.F1(b2, c2, d2, a2, this.X[3], 12);
        a2 = this.F1(a2, b2, c2, d2, this.X[4], 5);
        d2 = this.F1(d2, a2, b2, c2, this.X[5], 8);
        c2 = this.F1(c2, d2, a2, b2, this.X[6], 7);
        b2 = this.F1(b2, c2, d2, a2, this.X[7], 9);
        a2 = this.F1(a2, b2, c2, d2, this.X[8], 11);
        d2 = this.F1(d2, a2, b2, c2, this.X[9], 13);
        c2 = this.F1(c2, d2, a2, b2, this.X[10], 14);
        b2 = this.F1(b2, c2, d2, a2, this.X[11], 15);
        a2 = this.F1(a2, b2, c2, d2, this.X[12], 6);
        d2 = this.F1(d2, a2, b2, c2, this.X[13], 7);
        c2 = this.F1(c2, d2, a2, b2, this.X[14], 9);
        b2 = this.F1(b2, c2, d2, a2, this.X[15], 8);
        a2 = this.F2(a2, b2, c2, d2, this.X[7], 7);
        d2 = this.F2(d2, a2, b2, c2, this.X[4], 6);
        c2 = this.F2(c2, d2, a2, b2, this.X[13], 8);
        b2 = this.F2(b2, c2, d2, a2, this.X[1], 13);
        a2 = this.F2(a2, b2, c2, d2, this.X[10], 11);
        d2 = this.F2(d2, a2, b2, c2, this.X[6], 9);
        c2 = this.F2(c2, d2, a2, b2, this.X[15], 7);
        b2 = this.F2(b2, c2, d2, a2, this.X[3], 15);
        a2 = this.F2(a2, b2, c2, d2, this.X[12], 7);
        d2 = this.F2(d2, a2, b2, c2, this.X[0], 12);
        c2 = this.F2(c2, d2, a2, b2, this.X[9], 15);
        b2 = this.F2(b2, c2, d2, a2, this.X[5], 9);
        a2 = this.F2(a2, b2, c2, d2, this.X[2], 11);
        d2 = this.F2(d2, a2, b2, c2, this.X[14], 7);
        c2 = this.F2(c2, d2, a2, b2, this.X[11], 13);
        b2 = this.F2(b2, c2, d2, a2, this.X[8], 12);
        a2 = this.F3(a2, b2, c2, d2, this.X[3], 11);
        d2 = this.F3(d2, a2, b2, c2, this.X[10], 13);
        c2 = this.F3(c2, d2, a2, b2, this.X[14], 6);
        b2 = this.F3(b2, c2, d2, a2, this.X[4], 7);
        a2 = this.F3(a2, b2, c2, d2, this.X[9], 14);
        d2 = this.F3(d2, a2, b2, c2, this.X[15], 9);
        c2 = this.F3(c2, d2, a2, b2, this.X[8], 13);
        b2 = this.F3(b2, c2, d2, a2, this.X[1], 15);
        a2 = this.F3(a2, b2, c2, d2, this.X[2], 14);
        d2 = this.F3(d2, a2, b2, c2, this.X[7], 8);
        c2 = this.F3(c2, d2, a2, b2, this.X[0], 13);
        b2 = this.F3(b2, c2, d2, a2, this.X[6], 6);
        a2 = this.F3(a2, b2, c2, d2, this.X[13], 5);
        d2 = this.F3(d2, a2, b2, c2, this.X[11], 12);
        c2 = this.F3(c2, d2, a2, b2, this.X[5], 7);
        b2 = this.F3(b2, c2, d2, a2, this.X[12], 5);
        a2 = this.F4(a2, b2, c2, d2, this.X[1], 11);
        d2 = this.F4(d2, a2, b2, c2, this.X[9], 12);
        c2 = this.F4(c2, d2, a2, b2, this.X[11], 14);
        b2 = this.F4(b2, c2, d2, a2, this.X[10], 15);
        a2 = this.F4(a2, b2, c2, d2, this.X[0], 14);
        d2 = this.F4(d2, a2, b2, c2, this.X[8], 15);
        c2 = this.F4(c2, d2, a2, b2, this.X[12], 9);
        b2 = this.F4(b2, c2, d2, a2, this.X[4], 8);
        a2 = this.F4(a2, b2, c2, d2, this.X[13], 9);
        d2 = this.F4(d2, a2, b2, c2, this.X[3], 14);
        c2 = this.F4(c2, d2, a2, b2, this.X[7], 5);
        b2 = this.F4(b2, c2, d2, a2, this.X[15], 6);
        a2 = this.F4(a2, b2, c2, d2, this.X[14], 8);
        d2 = this.F4(d2, a2, b2, c2, this.X[5], 6);
        c2 = this.F4(c2, d2, a2, b2, this.X[6], 5);
        b2 = this.F4(b2, c2, d2, a2, this.X[2], 12);
        aa2 = this.FF4(aa2, bb2, cc2, dd2, this.X[5], 8);
        dd2 = this.FF4(dd2, aa2, bb2, cc2, this.X[14], 9);
        cc2 = this.FF4(cc2, dd2, aa2, bb2, this.X[7], 9);
        bb2 = this.FF4(bb2, cc2, dd2, aa2, this.X[0], 11);
        aa2 = this.FF4(aa2, bb2, cc2, dd2, this.X[9], 13);
        dd2 = this.FF4(dd2, aa2, bb2, cc2, this.X[2], 15);
        cc2 = this.FF4(cc2, dd2, aa2, bb2, this.X[11], 15);
        bb2 = this.FF4(bb2, cc2, dd2, aa2, this.X[4], 5);
        aa2 = this.FF4(aa2, bb2, cc2, dd2, this.X[13], 7);
        dd2 = this.FF4(dd2, aa2, bb2, cc2, this.X[6], 7);
        cc2 = this.FF4(cc2, dd2, aa2, bb2, this.X[15], 8);
        bb2 = this.FF4(bb2, cc2, dd2, aa2, this.X[8], 11);
        aa2 = this.FF4(aa2, bb2, cc2, dd2, this.X[1], 14);
        dd2 = this.FF4(dd2, aa2, bb2, cc2, this.X[10], 14);
        cc2 = this.FF4(cc2, dd2, aa2, bb2, this.X[3], 12);
        bb2 = this.FF4(bb2, cc2, dd2, aa2, this.X[12], 6);
        aa2 = this.FF3(aa2, bb2, cc2, dd2, this.X[6], 9);
        dd2 = this.FF3(dd2, aa2, bb2, cc2, this.X[11], 13);
        cc2 = this.FF3(cc2, dd2, aa2, bb2, this.X[3], 15);
        bb2 = this.FF3(bb2, cc2, dd2, aa2, this.X[7], 7);
        aa2 = this.FF3(aa2, bb2, cc2, dd2, this.X[0], 12);
        dd2 = this.FF3(dd2, aa2, bb2, cc2, this.X[13], 8);
        cc2 = this.FF3(cc2, dd2, aa2, bb2, this.X[5], 9);
        bb2 = this.FF3(bb2, cc2, dd2, aa2, this.X[10], 11);
        aa2 = this.FF3(aa2, bb2, cc2, dd2, this.X[14], 7);
        dd2 = this.FF3(dd2, aa2, bb2, cc2, this.X[15], 7);
        cc2 = this.FF3(cc2, dd2, aa2, bb2, this.X[8], 12);
        bb2 = this.FF3(bb2, cc2, dd2, aa2, this.X[12], 7);
        aa2 = this.FF3(aa2, bb2, cc2, dd2, this.X[4], 6);
        dd2 = this.FF3(dd2, aa2, bb2, cc2, this.X[9], 15);
        cc2 = this.FF3(cc2, dd2, aa2, bb2, this.X[1], 13);
        bb2 = this.FF3(bb2, cc2, dd2, aa2, this.X[2], 11);
        aa2 = this.FF2(aa2, bb2, cc2, dd2, this.X[15], 9);
        dd2 = this.FF2(dd2, aa2, bb2, cc2, this.X[5], 7);
        cc2 = this.FF2(cc2, dd2, aa2, bb2, this.X[1], 15);
        bb2 = this.FF2(bb2, cc2, dd2, aa2, this.X[3], 11);
        aa2 = this.FF2(aa2, bb2, cc2, dd2, this.X[7], 8);
        dd2 = this.FF2(dd2, aa2, bb2, cc2, this.X[14], 6);
        cc2 = this.FF2(cc2, dd2, aa2, bb2, this.X[6], 6);
        bb2 = this.FF2(bb2, cc2, dd2, aa2, this.X[9], 14);
        aa2 = this.FF2(aa2, bb2, cc2, dd2, this.X[11], 12);
        dd2 = this.FF2(dd2, aa2, bb2, cc2, this.X[8], 13);
        cc2 = this.FF2(cc2, dd2, aa2, bb2, this.X[12], 5);
        bb2 = this.FF2(bb2, cc2, dd2, aa2, this.X[2], 14);
        aa2 = this.FF2(aa2, bb2, cc2, dd2, this.X[10], 13);
        dd2 = this.FF2(dd2, aa2, bb2, cc2, this.X[0], 13);
        cc2 = this.FF2(cc2, dd2, aa2, bb2, this.X[4], 7);
        bb2 = this.FF2(bb2, cc2, dd2, aa2, this.X[13], 5);
        aa2 = this.FF1(aa2, bb2, cc2, dd2, this.X[8], 15);
        dd2 = this.FF1(dd2, aa2, bb2, cc2, this.X[6], 5);
        cc2 = this.FF1(cc2, dd2, aa2, bb2, this.X[4], 8);
        bb2 = this.FF1(bb2, cc2, dd2, aa2, this.X[1], 11);
        aa2 = this.FF1(aa2, bb2, cc2, dd2, this.X[3], 14);
        dd2 = this.FF1(dd2, aa2, bb2, cc2, this.X[11], 14);
        cc2 = this.FF1(cc2, dd2, aa2, bb2, this.X[15], 6);
        bb2 = this.FF1(bb2, cc2, dd2, aa2, this.X[0], 14);
        aa2 = this.FF1(aa2, bb2, cc2, dd2, this.X[5], 6);
        dd2 = this.FF1(dd2, aa2, bb2, cc2, this.X[12], 9);
        cc2 = this.FF1(cc2, dd2, aa2, bb2, this.X[2], 12);
        bb2 = this.FF1(bb2, cc2, dd2, aa2, this.X[13], 9);
        aa2 = this.FF1(aa2, bb2, cc2, dd2, this.X[9], 12);
        dd2 = this.FF1(dd2, aa2, bb2, cc2, this.X[7], 5);
        cc2 = this.FF1(cc2, dd2, aa2, bb2, this.X[10], 15);
        bb2 = this.FF1(bb2, cc2, dd2, aa2, this.X[14], 8);
        this.H1 = this.H2 + d2 + aa2;
        this.H2 = this.H3 + a2 + bb2;
        this.H3 = this.H0 + b2 + cc2;
        this.H0 = dd2 += c2 + this.H1;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }
}

