/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ntru.polynomial;

import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.util.Arrays;

public class LongPolynomial2 {
    private long[] coeffs;
    private int numCoeffs;

    public LongPolynomial2(IntegerPolynomial p2) {
        this.numCoeffs = p2.coeffs.length;
        this.coeffs = new long[(this.numCoeffs + 1) / 2];
        int idx = 0;
        int pIdx = 0;
        while (pIdx < this.numCoeffs) {
            long c1;
            int c0;
            for (c0 = p2.coeffs[pIdx++]; c0 < 0; c0 += 2048) {
            }
            long l2 = c1 = pIdx < this.numCoeffs ? (long)p2.coeffs[pIdx++] : 0L;
            while (l2 < 0L) {
                l2 = c1 + 2048L;
            }
            this.coeffs[idx] = (long)c0 + (c1 << 24);
            ++idx;
        }
    }

    private LongPolynomial2(long[] coeffs) {
        this.coeffs = coeffs;
    }

    private LongPolynomial2(int N) {
        this.coeffs = new long[N];
    }

    public LongPolynomial2 mult(LongPolynomial2 poly2) {
        int N = this.coeffs.length;
        if (poly2.coeffs.length != N || this.numCoeffs != poly2.numCoeffs) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        LongPolynomial2 c2 = this.multRecursive(poly2);
        if (c2.coeffs.length > N) {
            if (this.numCoeffs % 2 == 0) {
                for (int k2 = N; k2 < c2.coeffs.length; ++k2) {
                    c2.coeffs[k2 - N] = c2.coeffs[k2 - N] + c2.coeffs[k2] & 0x7FF0007FFL;
                }
                c2.coeffs = Arrays.copyOf(c2.coeffs, N);
            } else {
                for (int k3 = N; k3 < c2.coeffs.length; ++k3) {
                    c2.coeffs[k3 - N] = c2.coeffs[k3 - N] + (c2.coeffs[k3 - 1] >> 24);
                    c2.coeffs[k3 - N] = c2.coeffs[k3 - N] + ((c2.coeffs[k3] & 0x7FFL) << 24);
                    int n2 = k3 - N;
                    c2.coeffs[n2] = c2.coeffs[n2] & 0x7FF0007FFL;
                }
                c2.coeffs = Arrays.copyOf(c2.coeffs, N);
                int n3 = c2.coeffs.length - 1;
                c2.coeffs[n3] = c2.coeffs[n3] & 0x7FFL;
            }
        }
        c2 = new LongPolynomial2(c2.coeffs);
        new LongPolynomial2(c2.coeffs).numCoeffs = this.numCoeffs;
        return c2;
    }

    public IntegerPolynomial toIntegerPolynomial() {
        int[] intCoeffs = new int[this.numCoeffs];
        int uIdx = 0;
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            intCoeffs[uIdx++] = (int)(this.coeffs[i2] & 0x7FFL);
            if (uIdx >= this.numCoeffs) continue;
            intCoeffs[uIdx++] = (int)(this.coeffs[i2] >> 24 & 0x7FFL);
        }
        return new IntegerPolynomial(intCoeffs);
    }

    private LongPolynomial2 multRecursive(LongPolynomial2 poly2) {
        int i2;
        long[] a2 = this.coeffs;
        long[] b2 = poly2.coeffs;
        int n2 = poly2.coeffs.length;
        if (n2 <= 32) {
            int cn2 = 2 * n2;
            LongPolynomial2 c2 = new LongPolynomial2(new long[cn2]);
            for (int k2 = 0; k2 < cn2; ++k2) {
                for (int i3 = Math.max(0, k2 - n2 + 1); i3 <= Math.min(k2, n2 - 1); ++i3) {
                    long c0 = a2[k2 - i3] * b2[i3];
                    long cu2 = c0 & 0x7FF000000L + (c0 & 0x7FFL);
                    long co2 = c0 >>> 48 & 0x7FFL;
                    c2.coeffs[k2] = c2.coeffs[k2] + cu2 & 0x7FF0007FFL;
                    c2.coeffs[k2 + 1] = c2.coeffs[k2 + 1] + co2 & 0x7FF0007FFL;
                }
            }
            return c2;
        }
        int n1 = n2 / 2;
        LongPolynomial2 a1 = new LongPolynomial2(Arrays.copyOf(a2, n1));
        LongPolynomial2 a22 = new LongPolynomial2(Arrays.copyOfRange(a2, n1, n2));
        LongPolynomial2 b1 = new LongPolynomial2(Arrays.copyOf(b2, n1));
        LongPolynomial2 b22 = new LongPolynomial2(Arrays.copyOfRange(b2, n1, n2));
        LongPolynomial2 A = (LongPolynomial2)a1.clone();
        A.add(a22);
        LongPolynomial2 B = (LongPolynomial2)b1.clone();
        B.add(b22);
        LongPolynomial2 c1 = a1.multRecursive(b1);
        LongPolynomial2 c2 = a22.multRecursive(b22);
        LongPolynomial2 c3 = A.multRecursive(B);
        c3.sub(c1);
        c3.sub(c2);
        LongPolynomial2 c4 = new LongPolynomial2(2 * n2);
        for (i2 = 0; i2 < c1.coeffs.length; ++i2) {
            c4.coeffs[i2] = c1.coeffs[i2] & 0x7FF0007FFL;
        }
        for (i2 = 0; i2 < c3.coeffs.length; ++i2) {
            c4.coeffs[n1 + i2] = c4.coeffs[n1 + i2] + c3.coeffs[i2] & 0x7FF0007FFL;
        }
        for (i2 = 0; i2 < c2.coeffs.length; ++i2) {
            c4.coeffs[2 * n1 + i2] = c4.coeffs[2 * n1 + i2] + c2.coeffs[i2] & 0x7FF0007FFL;
        }
        return c4;
    }

    private void add(LongPolynomial2 b2) {
        if (b2.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(this.coeffs, b2.coeffs.length);
        }
        for (int i2 = 0; i2 < b2.coeffs.length; ++i2) {
            this.coeffs[i2] = this.coeffs[i2] + b2.coeffs[i2] & 0x7FF0007FFL;
        }
    }

    private void sub(LongPolynomial2 b2) {
        if (b2.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(this.coeffs, b2.coeffs.length);
        }
        for (int i2 = 0; i2 < b2.coeffs.length; ++i2) {
            this.coeffs[i2] = 0x800000800000L + this.coeffs[i2] - b2.coeffs[i2] & 0x7FF0007FFL;
        }
    }

    public void subAnd(LongPolynomial2 b2, int mask) {
        long longMask = ((long)mask << 24) + (long)mask;
        for (int i2 = 0; i2 < b2.coeffs.length; ++i2) {
            this.coeffs[i2] = 0x800000800000L + this.coeffs[i2] - b2.coeffs[i2] & longMask;
        }
    }

    public void mult2And(int mask) {
        long longMask = ((long)mask << 24) + (long)mask;
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            this.coeffs[i2] = this.coeffs[i2] << 1 & longMask;
        }
    }

    public Object clone() {
        LongPolynomial2 p2 = new LongPolynomial2((long[])this.coeffs.clone());
        new LongPolynomial2((long[])this.coeffs.clone()).numCoeffs = this.numCoeffs;
        return p2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongPolynomial2) {
            return Arrays.areEqual(this.coeffs, ((LongPolynomial2)obj).coeffs);
        }
        return false;
    }
}

