/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.PolicyInformation;

public class CertificatePolicies
extends ASN1Object {
    private final PolicyInformation[] policyInformation;

    public static CertificatePolicies getInstance(Object obj) {
        if (obj instanceof CertificatePolicies) {
            return (CertificatePolicies)obj;
        }
        if (obj != null) {
            return new CertificatePolicies(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static CertificatePolicies getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public CertificatePolicies(PolicyInformation name) {
        this.policyInformation = new PolicyInformation[]{name};
    }

    public CertificatePolicies(PolicyInformation[] policyInformation) {
        this.policyInformation = policyInformation;
    }

    private CertificatePolicies(ASN1Sequence seq) {
        this.policyInformation = new PolicyInformation[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            this.policyInformation[i2] = PolicyInformation.getInstance(seq.getObjectAt(i2));
        }
    }

    public PolicyInformation[] getPolicyInformation() {
        PolicyInformation[] tmp = new PolicyInformation[this.policyInformation.length];
        System.arraycopy(this.policyInformation, 0, tmp, 0, this.policyInformation.length);
        return tmp;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.policyInformation);
    }

    public String toString() {
        String p2 = null;
        for (int i2 = 0; i2 < this.policyInformation.length; ++i2) {
            if (p2 != null) {
                p2 = p2 + ", ";
            }
            p2 = p2 + this.policyInformation[i2];
        }
        return "CertificatePolicies: " + p2;
    }
}

