/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GFElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import java.math.BigInteger;
import java.util.Random;

public class GF2nPolynomialElement
extends GF2nElement {
    private static final int[] bitMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE, 0};
    private GF2Polynomial polynomial;

    public GF2nPolynomialElement(GF2nPolynomialField f2, Random rand) {
        this.mField = f2;
        this.mDegree = this.mField.getDegree();
        this.polynomial = new GF2Polynomial(this.mDegree);
        this.randomize(rand);
    }

    public GF2nPolynomialElement(GF2nPolynomialField f2, GF2Polynomial bs2) {
        this.mField = f2;
        this.mDegree = this.mField.getDegree();
        this.polynomial = new GF2Polynomial(bs2);
        this.polynomial.expandN(this.mDegree);
    }

    public GF2nPolynomialElement(GF2nPolynomialField f2, byte[] os) {
        this.mField = f2;
        this.mDegree = this.mField.getDegree();
        this.polynomial = new GF2Polynomial(this.mDegree, os);
        this.polynomial.expandN(this.mDegree);
    }

    public GF2nPolynomialElement(GF2nPolynomialField f2, int[] is) {
        this.mField = f2;
        this.mDegree = this.mField.getDegree();
        this.polynomial = new GF2Polynomial(this.mDegree, is);
        this.polynomial.expandN(f2.mDegree);
    }

    public GF2nPolynomialElement(GF2nPolynomialElement other) {
        this.mField = other.mField;
        this.mDegree = other.mDegree;
        this.polynomial = new GF2Polynomial(other.polynomial);
    }

    @Override
    public Object clone() {
        return new GF2nPolynomialElement(this);
    }

    @Override
    void assignZero() {
        this.polynomial.assignZero();
    }

    public static GF2nPolynomialElement ZERO(GF2nPolynomialField f2) {
        GF2Polynomial polynomial = new GF2Polynomial(f2.getDegree());
        return new GF2nPolynomialElement(f2, polynomial);
    }

    public static GF2nPolynomialElement ONE(GF2nPolynomialField f2) {
        GF2Polynomial polynomial = new GF2Polynomial(f2.getDegree(), new int[]{1});
        return new GF2nPolynomialElement(f2, polynomial);
    }

    @Override
    void assignOne() {
        this.polynomial.assignOne();
    }

    private void randomize(Random rand) {
        this.polynomial.expandN(this.mDegree);
        this.polynomial.randomize(rand);
    }

    @Override
    public boolean isZero() {
        return this.polynomial.isZero();
    }

    @Override
    public boolean isOne() {
        return this.polynomial.isOne();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nPolynomialElement)) {
            return false;
        }
        GF2nPolynomialElement otherElem = (GF2nPolynomialElement)other;
        if (this.mField != otherElem.mField && !this.mField.getFieldPolynomial().equals(otherElem.mField.getFieldPolynomial())) {
            return false;
        }
        return this.polynomial.equals(otherElem.polynomial);
    }

    @Override
    public int hashCode() {
        return this.mField.hashCode() + this.polynomial.hashCode();
    }

    private GF2Polynomial getGF2Polynomial() {
        return new GF2Polynomial(this.polynomial);
    }

    @Override
    boolean testBit(int index) {
        return this.polynomial.testBit(index);
    }

    @Override
    public boolean testRightmostBit() {
        return this.polynomial.testBit(0);
    }

    @Override
    public GFElement add(GFElement addend) throws RuntimeException {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.addToThis(addend);
        return result;
    }

    @Override
    public void addToThis(GFElement addend) throws RuntimeException {
        if (!(addend instanceof GF2nPolynomialElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nPolynomialElement)addend).mField)) {
            throw new RuntimeException();
        }
        this.polynomial.addToThis(((GF2nPolynomialElement)addend).polynomial);
    }

    @Override
    public GF2nElement increase() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.increaseThis();
        return result;
    }

    @Override
    public void increaseThis() {
        this.polynomial.increaseThis();
    }

    @Override
    public GFElement multiply(GFElement factor) throws RuntimeException {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.multiplyThisBy(factor);
        return result;
    }

    @Override
    public void multiplyThisBy(GFElement factor) throws RuntimeException {
        if (!(factor instanceof GF2nPolynomialElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nPolynomialElement)factor).mField)) {
            throw new RuntimeException();
        }
        if (this.equals(factor)) {
            this.squareThis();
            return;
        }
        this.polynomial = this.polynomial.multiply(((GF2nPolynomialElement)factor).polynomial);
        this.reduceThis();
    }

    @Override
    public GFElement invert() throws ArithmeticException {
        return this.invertMAIA();
    }

    public GF2nPolynomialElement invertEEA() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        GF2Polynomial b2 = new GF2Polynomial(this.mDegree + 32, "ONE");
        b2.reduceN();
        GF2Polynomial c2 = new GF2Polynomial(this.mDegree + 32);
        c2.reduceN();
        GF2Polynomial u2 = this.getGF2Polynomial();
        GF2Polynomial v2 = this.mField.getFieldPolynomial();
        u2.reduceN();
        while (!u2.isOne()) {
            u2.reduceN();
            v2.reduceN();
            int j2 = u2.getLength() - v2.getLength();
            if (j2 < 0) {
                GF2Polynomial h2 = u2;
                u2 = v2;
                v2 = h2;
                h2 = b2;
                b2 = c2;
                c2 = h2;
                j2 = -j2;
                c2.reduceN();
            }
            u2.shiftLeftAddThis(v2, j2);
            b2.shiftLeftAddThis(c2, j2);
        }
        b2.reduceN();
        return new GF2nPolynomialElement((GF2nPolynomialField)this.mField, b2);
    }

    public GF2nPolynomialElement invertSquare() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        int b2 = this.mField.getDegree() - 1;
        GF2nPolynomialElement n2 = new GF2nPolynomialElement(this);
        n2.polynomial.expandN((this.mDegree << 1) + 32);
        n2.polynomial.reduceN();
        int k2 = 1;
        for (int i2 = IntegerFunctions.floorLog(b2) - 1; i2 >= 0; --i2) {
            GF2nPolynomialElement u2 = new GF2nPolynomialElement(n2);
            for (int j2 = 1; j2 <= k2; ++j2) {
                u2.squareThisPreCalc();
            }
            n2.multiplyThisBy(u2);
            k2 <<= 1;
            if ((b2 & bitMask[i2]) == 0) continue;
            n2.squareThisPreCalc();
            n2.multiplyThisBy(this);
            ++k2;
        }
        n2.squareThisPreCalc();
        return n2;
    }

    public GF2nPolynomialElement invertMAIA() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        GF2Polynomial b2 = new GF2Polynomial(this.mDegree, "ONE");
        GF2Polynomial c2 = new GF2Polynomial(this.mDegree);
        GF2Polynomial u2 = this.getGF2Polynomial();
        GF2Polynomial v2 = this.mField.getFieldPolynomial();
        while (true) {
            if (!u2.testBit(0)) {
                u2.shiftRightThis();
                if (!b2.testBit(0)) {
                    b2.shiftRightThis();
                    continue;
                }
                b2.addToThis(this.mField.getFieldPolynomial());
                b2.shiftRightThis();
                continue;
            }
            if (u2.isOne()) {
                return new GF2nPolynomialElement((GF2nPolynomialField)this.mField, b2);
            }
            u2.reduceN();
            v2.reduceN();
            if (u2.getLength() < v2.getLength()) {
                GF2Polynomial h2 = u2;
                u2 = v2;
                v2 = h2;
                h2 = b2;
                b2 = c2;
                c2 = h2;
            }
            u2.addToThis(v2);
            b2.addToThis(c2);
        }
    }

    @Override
    public GF2nElement square() {
        return this.squarePreCalc();
    }

    @Override
    public void squareThis() {
        this.squareThisPreCalc();
    }

    public GF2nPolynomialElement squareMatrix() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.squareThisMatrix();
        result.reduceThis();
        return result;
    }

    public void squareThisMatrix() {
        GF2Polynomial result = new GF2Polynomial(this.mDegree);
        for (int i2 = 0; i2 < this.mDegree; ++i2) {
            if (!this.polynomial.vectorMult(((GF2nPolynomialField)this.mField).squaringMatrix[this.mDegree - i2 - 1])) continue;
            result.setBit(i2);
        }
        this.polynomial = result;
    }

    public GF2nPolynomialElement squareBitwise() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.squareThisBitwise();
        result.reduceThis();
        return result;
    }

    public void squareThisBitwise() {
        this.polynomial.squareThisBitwise();
        this.reduceThis();
    }

    public GF2nPolynomialElement squarePreCalc() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.squareThisPreCalc();
        result.reduceThis();
        return result;
    }

    public void squareThisPreCalc() {
        this.polynomial.squareThisPreCalc();
        this.reduceThis();
    }

    public GF2nPolynomialElement power(int k2) {
        if (k2 == 1) {
            return new GF2nPolynomialElement(this);
        }
        GF2nPolynomialElement result = GF2nPolynomialElement.ONE((GF2nPolynomialField)this.mField);
        if (k2 == 0) {
            return result;
        }
        GF2nPolynomialElement x2 = new GF2nPolynomialElement(this);
        x2.polynomial.expandN((x2.mDegree << 1) + 32);
        x2.polynomial.reduceN();
        for (int i2 = 0; i2 < this.mDegree; ++i2) {
            if ((k2 & 1 << i2) != 0) {
                result.multiplyThisBy(x2);
            }
            x2.square();
        }
        return result;
    }

    @Override
    public GF2nElement squareRoot() {
        GF2nPolynomialElement result = new GF2nPolynomialElement(this);
        result.squareRootThis();
        return result;
    }

    @Override
    public void squareRootThis() {
        this.polynomial.expandN((this.mDegree << 1) + 32);
        this.polynomial.reduceN();
        for (int i2 = 0; i2 < this.mField.getDegree() - 1; ++i2) {
            this.squareThis();
        }
    }

    @Override
    public GF2nElement solveQuadraticEquation() throws RuntimeException {
        GF2nPolynomialElement z2;
        GF2nPolynomialElement w2;
        if (this.isZero()) {
            return GF2nPolynomialElement.ZERO((GF2nPolynomialField)this.mField);
        }
        if ((this.mDegree & 1) == 1) {
            return this.halfTrace();
        }
        do {
            GF2nPolynomialElement p2 = new GF2nPolynomialElement((GF2nPolynomialField)this.mField, new Random());
            z2 = GF2nPolynomialElement.ZERO((GF2nPolynomialField)this.mField);
            w2 = (GF2nPolynomialElement)p2.clone();
            for (int i2 = 1; i2 < this.mDegree; ++i2) {
                z2.squareThis();
                w2.squareThis();
                z2.addToThis(w2.multiply(this));
                w2.addToThis(p2);
            }
        } while (w2.isZero());
        if (!this.equals(z2.square().add(z2))) {
            throw new RuntimeException();
        }
        return z2;
    }

    @Override
    public int trace() {
        GF2nPolynomialElement t2 = new GF2nPolynomialElement(this);
        for (int i2 = 1; i2 < this.mDegree; ++i2) {
            t2.squareThis();
            t2.addToThis(this);
        }
        if (t2.isOne()) {
            return 1;
        }
        return 0;
    }

    private GF2nPolynomialElement halfTrace() throws RuntimeException {
        if ((this.mDegree & 1) == 0) {
            throw new RuntimeException();
        }
        GF2nPolynomialElement h2 = new GF2nPolynomialElement(this);
        for (int i2 = 1; i2 <= this.mDegree - 1 >> 1; ++i2) {
            h2.squareThis();
            h2.squareThis();
            h2.addToThis(this);
        }
        return h2;
    }

    private void reduceThis() {
        if (this.polynomial.getLength() > this.mDegree) {
            if (((GF2nPolynomialField)this.mField).isTrinomial()) {
                int tc;
                try {
                    tc = ((GF2nPolynomialField)this.mField).getTc();
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("GF2nPolynomialElement.reduce: the field polynomial is not a trinomial");
                }
                if (this.mDegree - tc <= 32 || this.polynomial.getLength() > this.mDegree << 1) {
                    this.reduceTrinomialBitwise(tc);
                    return;
                }
                this.polynomial.reduceTrinomial(this.mDegree, tc);
                return;
            }
            if (((GF2nPolynomialField)this.mField).isPentanomial()) {
                int[] pc;
                try {
                    pc = ((GF2nPolynomialField)this.mField).getPc();
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("GF2nPolynomialElement.reduce: the field polynomial is not a pentanomial");
                }
                if (this.mDegree - pc[2] <= 32 || this.polynomial.getLength() > this.mDegree << 1) {
                    this.reducePentanomialBitwise(pc);
                    return;
                }
                this.polynomial.reducePentanomial(this.mDegree, pc);
                return;
            }
            this.polynomial = this.polynomial.remainder(this.mField.getFieldPolynomial());
            this.polynomial.expandN(this.mDegree);
            return;
        }
        if (this.polynomial.getLength() < this.mDegree) {
            this.polynomial.expandN(this.mDegree);
        }
    }

    private void reduceTrinomialBitwise(int tc) {
        int k2 = this.mDegree - tc;
        for (int i2 = this.polynomial.getLength() - 1; i2 >= this.mDegree; --i2) {
            if (!this.polynomial.testBit(i2)) continue;
            this.polynomial.xorBit(i2);
            this.polynomial.xorBit(i2 - k2);
            this.polynomial.xorBit(i2 - this.mDegree);
        }
        this.polynomial.reduceN();
        this.polynomial.expandN(this.mDegree);
    }

    private void reducePentanomialBitwise(int[] pc) {
        int k2 = this.mDegree - pc[2];
        int l2 = this.mDegree - pc[1];
        int m2 = this.mDegree - pc[0];
        for (int i2 = this.polynomial.getLength() - 1; i2 >= this.mDegree; --i2) {
            if (!this.polynomial.testBit(i2)) continue;
            this.polynomial.xorBit(i2);
            this.polynomial.xorBit(i2 - k2);
            this.polynomial.xorBit(i2 - l2);
            this.polynomial.xorBit(i2 - m2);
            this.polynomial.xorBit(i2 - this.mDegree);
        }
        this.polynomial.reduceN();
        this.polynomial.expandN(this.mDegree);
    }

    @Override
    public String toString() {
        return this.polynomial.toString(16);
    }

    @Override
    public String toString(int radix) {
        return this.polynomial.toString(radix);
    }

    @Override
    public byte[] toByteArray() {
        return this.polynomial.toByteArray();
    }

    @Override
    public BigInteger toFlexiBigInt() {
        return this.polynomial.toFlexiBigInt();
    }
}

