/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.bean;

import com.timevale.esign.sdk.tech.impl.checker.IParametersValidator;
import com.timevale.esign.sdk.tech.impl.constants.CustomerSealType;
import esign.utils.s;

public class SignSealBean
implements IParametersValidator {
    private final String devId;
    private final String userId;
    private final Integer sealId;
    private final String sealData;
    private final CustomerSealType sealType;
    private final boolean isEventCertSeal;

    public SignSealBean(String devId) {
        this.devId = devId;
        this.sealType = CustomerSealType.DEV_TG_SEAL;
        this.userId = null;
        this.sealData = null;
        this.sealId = null;
        this.isEventCertSeal = false;
    }

    public SignSealBean(String devId, int sealId) {
        this.devId = devId;
        this.sealId = sealId;
        this.sealType = CustomerSealType.DEV_SELF_SEAL;
        this.userId = null;
        this.sealData = null;
        this.isEventCertSeal = false;
    }

    public SignSealBean(String devId, String userId, String sealData, Boolean isEventCertSeal) {
        this.devId = devId;
        this.userId = userId;
        this.sealData = sealData;
        this.sealType = CustomerSealType.DEV_ACCOUT_SEAL;
        this.sealId = null;
        this.isEventCertSeal = isEventCertSeal == null ? false : isEventCertSeal;
    }

    public String getDevId() {
        return this.devId;
    }

    public Integer getSealId() {
        return this.sealId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSealData() {
        return this.sealData;
    }

    public CustomerSealType getSealType() {
        return this.sealType;
    }

    public boolean isEventCertSeal() {
        return this.isEventCertSeal;
    }

    @Override
    public int validator() {
        if (s.a((String)this.devId)) {
            return 9004;
        }
        if (0 == this.sealType.compareTo(CustomerSealType.DEV_SELF_SEAL) || 0 == this.sealType.compareTo(CustomerSealType.DEV_TG_SEAL)) {
            return 0;
        }
        if (s.a((String)this.userId)) {
            return 1025;
        }
        if (s.a((String)this.sealData)) {
            return 3007;
        }
        return 0;
    }
}

