/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTNamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.sec.SECNamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.x9.X962NamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ECParameters;
import com.timevale.tgtext.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import java.util.Enumeration;
import java.util.Vector;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        X9ECParameters ecP = X962NamedCurves.getByName(name);
        if (ecP == null) {
            try {
                ecP = X962NamedCurves.getByOID(new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (ecP == null && (ecP = SECNamedCurves.getByName(name)) == null) {
            try {
                ecP = SECNamedCurves.getByOID(new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (ecP == null && (ecP = TeleTrusTNamedCurves.getByName(name)) == null) {
            try {
                ecP = TeleTrusTNamedCurves.getByOID(new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (ecP == null) {
            ecP = NISTNamedCurves.getByName(name);
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        Vector v2 = new Vector();
        ECNamedCurveTable.addEnumeration(v2, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v2, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v2, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v2, TeleTrusTNamedCurves.getNames());
        return v2.elements();
    }

    private static void addEnumeration(Vector v2, Enumeration e2) {
        while (e2.hasMoreElements()) {
            v2.addElement(e2.nextElement());
        }
    }
}

