/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.prng;

import cfca.sadk.org.bouncycastle.crypto.prng.EntropySource;
import cfca.sadk.org.bouncycastle.crypto.prng.EntropySourceProvider;
import java.security.SecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom random, boolean isPredictionResistant) {
        this._sr = random;
        this._predictionResistant = isPredictionResistant;
    }

    public EntropySource get(final int bitsRequired) {
        return new EntropySource(){

            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            public byte[] getEntropy() {
                return BasicEntropySourceProvider.this._sr.generateSeed((bitsRequired + 7) / 8);
            }

            public int entropySize() {
                return bitsRequired;
            }
        };
    }
}

