/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.yeepay.shade.org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"apiUri", "appKey", "secretKey", "needEncrypt", "encryptKey"})
public class MultipartUploadRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartUploadRequest.class);
    private String apiUri;
    private String appKey;
    private String secretKey;
    private Boolean needEncrypt;
    private String encryptKey;

    public MultipartUploadRequest() {
    }

    public MultipartUploadRequest(String appKey) {
        Validate.notBlank(appKey, "AppKey is blank.", new Object[0]);
        this.appKey = appKey;
    }

    public MultipartUploadRequest(String appKey, String secretKey) {
        Validate.notBlank(appKey, "AppKey is blank.", new Object[0]);
        Validate.notBlank(secretKey, "SecretKey is blank.", new Object[0]);
        this.appKey = appKey;
        this.secretKey = secretKey;
    }

    public String getApiUri() {
        return this.apiUri;
    }

    public MultipartUploadRequest setApiUri(String apiUri) {
        this.apiUri = apiUri;
        return this;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public Boolean getNeedEncrypt() {
        return this.needEncrypt;
    }

    public MultipartUploadRequest setNeedEncrypt(Boolean needEncrypt) {
        this.needEncrypt = needEncrypt;
        return this;
    }

    public String getEncryptKey() {
        return this.encryptKey;
    }

    public MultipartUploadRequest setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
        return this;
    }

    public String toString() {
        return "MultipartUploadRequest{apiUri='" + this.apiUri + '\'' + ", appKey='" + this.appKey + '\'' + ", secretKey='" + this.secretKey + '\'' + ", needEncrypt=" + this.needEncrypt + ", encryptKey='" + this.encryptKey + '\'' + '}';
    }
}

