/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Generator;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetStringParser;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1SequenceParser;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.ASN1SetParser;
import com.timevale.tgtext.bouncycastle.asn1.ASN1StreamParser;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.BERSequenceGenerator;
import com.timevale.tgtext.bouncycastle.asn1.BERSetParser;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfoParser;
import com.timevale.tgtext.bouncycastle.asn1.cms.SignedDataParser;
import com.timevale.tgtext.bouncycastle.asn1.cms.SignerInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttributeCertificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.CertificateList;
import com.timevale.tgtext.bouncycastle.cert.X509AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CRLHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cms.CMSContentInfoParser;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedStream;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.cms.h;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.util.CollectionStore;
import com.timevale.tgtext.bouncycastle.util.Store;
import com.timevale.tgtext.bouncycastle.util.io.Streams;
import com.timevale.tgtext.bouncycastle.x509.NoSuchStoreException;
import com.timevale.tgtext.bouncycastle.x509.X509Store;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static final h HELPER = h.a;
    private SignedDataParser _signedData;
    private ASN1ObjectIdentifier _signedContentType;
    private CMSTypedStream _signedContent;
    private Map digests;
    private SignerInformationStore _signerInfoStore;
    private X509Store _attributeStore;
    private ASN1Set _certSet;
    private ASN1Set _crlSet;
    private boolean _isCertCrlParsed;
    private X509Store _certificateStore;
    private X509Store _crlStore;

    public CMSSignedDataParser(byte[] sigBlock) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), (InputStream)new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, byte[] sigBlock) throws CMSException {
        this(digestCalculatorProvider, (InputStream)new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(CMSTypedStream signedContent, byte[] sigBlock) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), signedContent, new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream signedContent, byte[] sigBlock) throws CMSException {
        this(digestCalculatorProvider, signedContent, new ByteArrayInputStream(sigBlock));
    }

    private static DigestCalculatorProvider createDefaultDigestProvider() throws CMSException {
        return new BcDigestCalculatorProvider();
    }

    public CMSSignedDataParser(InputStream sigData) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), null, sigData);
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, InputStream sigData) throws CMSException {
        this(digestCalculatorProvider, null, sigData);
    }

    public CMSSignedDataParser(CMSTypedStream signedContent, InputStream sigData) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), signedContent, sigData);
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream signedContent, InputStream sigData) throws CMSException {
        super(sigData);
        try {
            ASN1Encodable o2;
            this._signedContent = signedContent;
            this._signedData = SignedDataParser.getInstance(this._contentInfo.getContent(16));
            this.digests = new HashMap();
            ASN1SetParser digAlgs = this._signedData.getDigestAlgorithms();
            while ((o2 = digAlgs.readObject()) != null) {
                AlgorithmIdentifier algId = AlgorithmIdentifier.getInstance(o2);
                try {
                    DigestCalculator calculator = digestCalculatorProvider.get(algId);
                    if (calculator == null) continue;
                    this.digests.put(algId.getAlgorithm(), calculator);
                }
                catch (OperatorCreationException operatorCreationException) {}
            }
            ContentInfoParser cont = this._signedData.getEncapContentInfo();
            ASN1OctetStringParser octs = (ASN1OctetStringParser)cont.getContent(4);
            if (octs != null) {
                CMSTypedStream ctStr = new CMSTypedStream(cont.getContentType().getId(), octs.getOctetStream());
                if (this._signedContent == null) {
                    this._signedContent = ctStr;
                } else {
                    ctStr.drain();
                }
            }
            this._signedContentType = signedContent == null ? cont.getContentType() : this._signedContent.getContentType();
        }
        catch (IOException e2) {
            throw new CMSException("io exception: " + e2.getMessage(), e2);
        }
        if (this.digests.isEmpty()) {
            throw new CMSException("no digests could be created for message.");
        }
    }

    public int getVersion() {
        return this._signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            this.populateCertCrlSets();
            ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
            HashMap hashes = new HashMap();
            for (Object digestKey : this.digests.keySet()) {
                hashes.put(digestKey, ((DigestCalculator)this.digests.get(digestKey)).getDigest());
            }
            try {
                ASN1Encodable o2;
                ASN1SetParser s2 = this._signedData.getSignerInfos();
                while ((o2 = s2.readObject()) != null) {
                    SignerInfo info = SignerInfo.getInstance(o2.toASN1Primitive());
                    byte[] hash = (byte[])hashes.get(info.getDigestAlgorithm().getAlgorithm());
                    signerInfos.add(new SignerInformation(info, this._signedContentType, null, hash));
                }
            }
            catch (IOException e2) {
                throw new CMSException("io exception: " + e2.getMessage(), e2);
            }
            this._signerInfoStore = new SignerInformationStore(signerInfos);
        }
        return this._signerInfoStore;
    }

    public X509Store getAttributeCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getAttributeCertificates(type, i.a(provider));
    }

    public X509Store getAttributeCertificates(String type, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._attributeStore == null) {
            this.populateCertCrlSets();
            this._attributeStore = HELPER.a(type, provider, this._certSet);
        }
        return this._attributeStore;
    }

    public X509Store getCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCertificates(type, i.a(provider));
    }

    public X509Store getCertificates(String type, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._certificateStore == null) {
            this.populateCertCrlSets();
            this._certificateStore = HELPER.b(type, provider, this._certSet);
        }
        return this._certificateStore;
    }

    public X509Store getCRLs(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCRLs(type, i.a(provider));
    }

    public X509Store getCRLs(String type, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._crlStore == null) {
            this.populateCertCrlSets();
            this._crlStore = HELPER.c(type, provider, this._crlSet);
        }
        return this._crlStore;
    }

    public CertStore getCertificatesAndCRLs(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.getCertificatesAndCRLs(type, i.a(provider));
    }

    public CertStore getCertificatesAndCRLs(String type, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        this.populateCertCrlSets();
        return HELPER.a(type, provider, this._certSet, this._crlSet);
    }

    public Store getCertificates() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set certSet = this._certSet;
        if (certSet != null) {
            ArrayList<X509CertificateHolder> certList = new ArrayList<X509CertificateHolder>(certSet.size());
            Enumeration en2 = certSet.getObjects();
            while (en2.hasMoreElements()) {
                ASN1Primitive obj = ((ASN1Encodable)en2.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1Sequence)) continue;
                certList.add(new X509CertificateHolder(Certificate.getInstance(obj)));
            }
            return new CollectionStore(certList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getCRLs() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set crlSet = this._crlSet;
        if (crlSet != null) {
            ArrayList<X509CRLHolder> crlList = new ArrayList<X509CRLHolder>(crlSet.size());
            Enumeration en2 = crlSet.getObjects();
            while (en2.hasMoreElements()) {
                ASN1Primitive obj = ((ASN1Encodable)en2.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1Sequence)) continue;
                crlList.add(new X509CRLHolder(CertificateList.getInstance(obj)));
            }
            return new CollectionStore(crlList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getAttributeCertificates() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set certSet = this._certSet;
        if (certSet != null) {
            ArrayList<X509AttributeCertificateHolder> certList = new ArrayList<X509AttributeCertificateHolder>(certSet.size());
            Enumeration en2 = certSet.getObjects();
            while (en2.hasMoreElements()) {
                ASN1TaggedObject tagged;
                ASN1Primitive obj = ((ASN1Encodable)en2.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1TaggedObject) || (tagged = (ASN1TaggedObject)obj).getTagNo() != 2) continue;
                certList.add(new X509AttributeCertificateHolder(AttributeCertificate.getInstance(ASN1Sequence.getInstance(tagged, false))));
            }
            return new CollectionStore(certList);
        }
        return new CollectionStore(new ArrayList());
    }

    private void populateCertCrlSets() throws CMSException {
        if (this._isCertCrlParsed) {
            return;
        }
        this._isCertCrlParsed = true;
        try {
            this._certSet = CMSSignedDataParser.getASN1Set(this._signedData.getCertificates());
            this._crlSet = CMSSignedDataParser.getASN1Set(this._signedData.getCrls());
            return;
        }
        catch (IOException e2) {
            throw new CMSException("problem parsing cert/crl sets", e2);
        }
    }

    public String getSignedContentTypeOID() {
        return this._signedContentType.getId();
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent == null) {
            return null;
        }
        InputStream digStream = i.a(this.digests.values(), this._signedContent.getContentStream());
        return new CMSTypedStream(this._signedContent.getContentType(), digStream);
    }

    public static OutputStream replaceSigners(InputStream original, SignerInformationStore signerInformationStore, OutputStream out) throws CMSException, IOException {
        ASN1StreamParser in = new ASN1StreamParser(original);
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        signedData.getDigestAlgorithms().toASN1Primitive();
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        for (SignerInformation signer : signerInformationStore.getSigners()) {
            digestAlgs.add(h.a.a(signer.getDigestAlgorithmID()));
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.writeSetToGeneratorTagged(sigGen, signedData.getCertificates(), 0);
        CMSSignedDataParser.writeSetToGeneratorTagged(sigGen, signedData.getCrls(), 1);
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        for (SignerInformation signer : signerInformationStore.getSigners()) {
            signerInfos.add(signer.toASN1Structure());
        }
        sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream original, CertStore certsAndCrls, OutputStream out) throws CMSException, IOException {
        ASN1Set crls;
        ASN1Set certs;
        ASN1StreamParser in = new ASN1StreamParser(original);
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        sigGen.getRawOutputStream().write(signedData.getDigestAlgorithms().toASN1Primitive().getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.getASN1Set(signedData.getCertificates());
        CMSSignedDataParser.getASN1Set(signedData.getCrls());
        try {
            certs = i.a(i.a(certsAndCrls));
        }
        catch (CertStoreException e2) {
            throw new CMSException("error getting certs from certStore", e2);
        }
        if (certs.size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, certs).getEncoded());
        }
        try {
            crls = i.a(i.b(certsAndCrls));
        }
        catch (CertStoreException e3) {
            throw new CMSException("error getting crls from certStore", e3);
        }
        if (crls.size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, crls).getEncoded());
        }
        sigGen.getRawOutputStream().write(signedData.getSignerInfos().toASN1Primitive().getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream original, Store certs, Store crls, Store attrCerts, OutputStream out) throws CMSException, IOException {
        ASN1Set asn1Crls;
        ASN1StreamParser in = new ASN1StreamParser(original);
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        sigGen.getRawOutputStream().write(signedData.getDigestAlgorithms().toASN1Primitive().getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.getASN1Set(signedData.getCertificates());
        CMSSignedDataParser.getASN1Set(signedData.getCrls());
        if (certs != null || attrCerts != null) {
            ASN1Set asn1Certs;
            ArrayList certificates = new ArrayList();
            if (certs != null) {
                certificates.addAll(i.a(certs));
            }
            if (attrCerts != null) {
                certificates.addAll(i.b(attrCerts));
            }
            if ((asn1Certs = i.a(certificates)).size() > 0) {
                sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, asn1Certs).getEncoded());
            }
        }
        if (crls != null && (asn1Crls = i.a(i.c(crls))).size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, asn1Crls).getEncoded());
        }
        sigGen.getRawOutputStream().write(signedData.getSignerInfos().toASN1Primitive().getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    private static void writeSetToGeneratorTagged(ASN1Generator asn1Gen, ASN1SetParser asn1SetParser, int tagNo) throws IOException {
        ASN1Set asn1Set = CMSSignedDataParser.getASN1Set(asn1SetParser);
        if (asn1Set != null) {
            if (asn1SetParser instanceof BERSetParser) {
                asn1Gen.getRawOutputStream().write(new BERTaggedObject(false, tagNo, asn1Set).getEncoded());
                return;
            }
            asn1Gen.getRawOutputStream().write(new DERTaggedObject(false, tagNo, asn1Set).getEncoded());
        }
    }

    private static ASN1Set getASN1Set(ASN1SetParser asn1SetParser) {
        if (asn1SetParser == null) {
            return null;
        }
        return ASN1Set.getInstance(asn1SetParser.toASN1Primitive());
    }

    private static void pipeEncapsulatedOctetString(ContentInfoParser encapContentInfo, OutputStream rawOutputStream) throws IOException {
        ASN1OctetStringParser octs = (ASN1OctetStringParser)encapContentInfo.getContent(4);
        if (octs != null) {
            CMSSignedDataParser.pipeOctetString(octs, rawOutputStream);
        }
    }

    private static void pipeOctetString(ASN1OctetStringParser octs, OutputStream output) throws IOException {
        OutputStream outOctets = i.a(output, 0, true, 0);
        Streams.pipeAll(octs.getOctetStream(), outOctets);
        outOctets.close();
    }
}

