/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.InitKeyStore;
import cfca.sadk.asn1.pkcs.PKCS12;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.system.FileHelper;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyUtil {
    public static SM2PrivateKey getPrivateKeyFromSM2(String sm2FilePath, String sm2FilePwd) throws PKIException {
        byte[] encoding;
        if (sm2FilePath == null) {
            throw new PKIException("SM2File sm2FilePath should not be null");
        }
        if (sm2FilePwd == null) {
            throw new PKIException("SM2File sm2FilePwd should not be null");
        }
        try {
            encoding = FileHelper.read(sm2FilePath);
        }
        catch (Exception e) {
            throw new PKIException("SM2File read failure", e);
        }
        return KeyUtil.getPrivateKeyFromSM2(encoding, sm2FilePwd);
    }

    public static SM2PrivateKey getPrivateKeyFromSM2(InputStream sm2FileInputStream, String sm2FilePwd) throws PKIException {
        byte[] encoding;
        int dLength;
        if (sm2FileInputStream == null) {
            throw new PKIException("SM2File sm2FileInputStream should not be null");
        }
        try {
            dLength = sm2FileInputStream.available();
        }
        catch (IOException e) {
            throw new PKIException("SM2File sm2FileInputStream invalid", e);
        }
        if (dLength > 1024000) {
            throw new PKIException("SM2File sm2FileInputStream too large");
        }
        try {
            encoding = new byte[dLength];
            sm2FileInputStream.read(encoding);
        }
        catch (Exception e) {
            throw new PKIException("SM2File sm2FileInputStream read failure", e);
        }
        return KeyUtil.getPrivateKeyFromSM2(encoding, sm2FilePwd);
    }

    public static SM2PrivateKey getPrivateKeyFromSM2(byte[] sm2FileData, String sm2FilePwd) throws PKIException {
        if (sm2FileData == null) {
            throw new PKIException("SM2File sm2FileData should not be null");
        }
        if (sm2FilePwd == null) {
            throw new PKIException("SM2File sm2FilePwd should not be null");
        }
        PKCS12_SM2 P12 = new PKCS12_SM2(sm2FileData);
        return P12.getPrivateKey(sm2FilePwd);
    }

    public static PrivateKey getPrivateKeyFromPFX(String pfxFilePath, String pfxFilePwd) throws PKIException {
        byte[] encoding;
        if (pfxFilePath == null) {
            throw new PKIException("PFXFile pfxFilePath should not be null");
        }
        try {
            encoding = FileHelper.read(pfxFilePath);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile read failure", e);
        }
        return KeyUtil.getPrivateKeyFromPFX(encoding, pfxFilePwd);
    }

    public static PrivateKey getPrivateKeyFromPFX(InputStream pfxFileInputStream, String pfxFilePwd) throws PKIException {
        byte[] encoding;
        int dLength;
        if (pfxFileInputStream == null) {
            throw new PKIException("PFXFile pfxFileInputStream should not be null");
        }
        try {
            dLength = pfxFileInputStream.available();
        }
        catch (IOException e) {
            throw new PKIException("PFXFile pfxFileInputStream invalid", e);
        }
        if (dLength > 1024000) {
            throw new PKIException("PFXFile pfxFileInputStream too large");
        }
        try {
            encoding = new byte[dLength];
            pfxFileInputStream.read(encoding);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile pfxFileInputStream read failure", e);
        }
        return KeyUtil.getPrivateKeyFromPFX(encoding, pfxFilePwd);
    }

    public static PrivateKey getPrivateKeyFromPFX(byte[] pfxFileData, String pfxFilePwd) throws PKIException {
        if (pfxFileData == null) {
            throw new PKIException("PFXFile pfxFileData should not be null");
        }
        if (pfxFilePwd == null) {
            throw new PKIException("PFXFile pfxFilePwd should not be null");
        }
        PKCS12 pkcs12 = new PKCS12(pfxFileData);
        return pkcs12.decrypt(pfxFilePwd.toCharArray());
    }

    public static PrivateKey getPrivateKeyFromJKS(String jksFilePath, String jksFilePwd, String alias) throws PKIException {
        if (jksFilePath == null) {
            throw new PKIException("JKSFile jksFilePath should not be null");
        }
        if (jksFilePwd == null) {
            throw new PKIException("JKSFile jksFilePwd should not be null");
        }
        if (alias == null) {
            throw new PKIException("JKSFile alias should not be null");
        }
        try {
            KeyStore ks = InitKeyStore.initJKSKeyStore(jksFilePath, jksFilePwd);
            char[] password = jksFilePwd.toCharArray();
            return (PrivateKey)ks.getKey(alias, password);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("JKSFile Parsed Failure", e);
        }
    }

    public static PrivateKey getPrivateKeyFromJKS(InputStream jksInputStream, String jksFilePwd, String alias) throws PKIException {
        if (jksInputStream == null) {
            throw new PKIException("JKSFile jksInputStream should not be null");
        }
        if (jksFilePwd == null) {
            throw new PKIException("JKSFile jksFilePwd should not be null");
        }
        if (alias == null) {
            throw new PKIException("JKSFile alias should not be null");
        }
        try {
            KeyStore ks = InitKeyStore.initJKSKeyStore(jksInputStream, jksFilePwd);
            char[] password = jksFilePwd.toCharArray();
            return (PrivateKey)ks.getKey(alias, password);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("JKSFile Parsed Failure", e);
        }
    }

    public static KeyPair generateKeyPair(Mechanism keypairType, int bitLength, Session session) throws PKIException {
        if ("SM2".equals(keypairType.getMechanismType())) {
            bitLength = 256;
        }
        return session.generateKeyPair(keypairType, bitLength);
    }

    public static Key generateKey(Mechanism symmetricKeyType, Session session) throws PKIException {
        return session.generateKey(symmetricKeyType);
    }

    public static Key generateKey(Mechanism symmetricKeyType, byte[] keyData, Session session) throws PKIException {
        return session.generateKey(symmetricKeyType, keyData);
    }

    public static SM2PublicKey getSM2PublicKey(byte[] pubX, byte[] pubY) {
        return new SM2PublicKey(pubX, pubY);
    }

    public static SM2PrivateKey getSM2PrivateKey(byte[] da, byte[] pubX, byte[] pubY) {
        return new SM2PrivateKey(da, pubX, pubY);
    }

    public static final Key generateKey(Mechanism keyType, byte[] keyData) throws PKIException {
        String type = keyType.getMechanismType();
        if ("DESede".equals(type)) {
            if (keyData.length != 24) {
                throw new PKIException("DES3 KEY must be 24 bytes");
            }
            return new SecretKeySpec(keyData, type);
        }
        if ("SM4".equals(type)) {
            if (keyData.length != 16) {
                throw new PKIException("SM4 KEY must be 16 bytes");
            }
            return new SecretKeySpec(keyData, type);
        }
        if (type.equals("RC4")) {
            if (keyData.length != 16) {
                throw new PKIException("RC4 KEY must be 16 bytes");
            }
            return new SecretKeySpec(keyData, type);
        }
        throw new PKIException("do not support this key type:" + type);
    }
}

