/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERBoolean;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DERInteger;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.tsp.TimeStampResp;
import com.timevale.tgtext.bouncycastle.asn1.util.DERDump;
import com.timevale.tgtext.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.timevale.tgtext.bouncycastle.asn1.x500.RDN;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLDistPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPointName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509CertificateStructure;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.tgtext.bouncycastle.tsp.TSPAlgorithms;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequest;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequestGenerator;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampResponse;
import com.timevale.tgtext.bouncycastle.util.Selector;
import com.timevale.tgtext.bouncycastle.util.Store;
import esign.utils.security.a;
import esign.utils.security.provider.Provider;
import esign.utils.security.provider.SecurityProvider;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import sun.misc.BASE64Decoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.SignerInfo;
import sun.security.util.DerValue;

public class b {
    private static String a = "2.5.4.3";
    private static final int b = 63;
    private static final int c = 128;
    private static final int d = 192;
    private static final int e = 224;

    public static a a(byte[] certBytes) {
        try {
            ByteArrayInputStream fi = new ByteArrayInputStream(certBytes);
            X509Certificate x509 = null;
            while (((InputStream)fi).available() > 0) {
                x509 = (X509Certificate)SecurityProvider.Default.factory().generateCertificate(fi);
            }
            return new a(x509);
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] b(byte[] b2) {
        int j2 = 0;
        byte[] utf8Byte = new byte[b2.length << 1];
        for (int i2 = 0; i2 < b2.length; i2 += 2) {
            byte[] bUTF = new byte[1];
            int nCode = b2[i2] & 0xFF | (b2[i2 + 1] & 0xFF) << 8;
            if (nCode < 128) {
                byte[] byArray = new byte[1];
                bUTF = byArray;
                byArray[0] = (byte)nCode;
            } else if (nCode < 2048) {
                byte[] byArray = new byte[2];
                bUTF = byArray;
                byArray[0] = (byte)(0xC0 | nCode >> 6);
                bUTF[1] = (byte)(0x80 | nCode & 0x3F);
            } else if (nCode < 65536) {
                byte[] byArray = new byte[3];
                bUTF = byArray;
                byArray[0] = (byte)(0xE0 | nCode >> 12);
                bUTF[1] = (byte)(0x80 | nCode >> 6 & 0x3F);
                bUTF[2] = (byte)(0x80 | nCode & 0x3F);
            }
            for (int k2 = 0; k2 < bUTF.length; ++k2) {
                utf8Byte[j2++] = bUTF[k2];
            }
        }
        b2 = new byte[j2];
        System.arraycopy(utf8Byte, 0, b2, 0, j2);
        return b2;
    }

    public static byte[] c(byte[] inData) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(inData);
            byte[] digest = messageDigest.digest();
            TimeStampRequestGenerator reqgen = new TimeStampRequestGenerator();
            reqgen.setCertReq(true);
            TimeStampRequest req = reqgen.generate(TSPAlgorithms.SHA1, digest);
            byte[] request = req.getEncoded();
            return request;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String a(String signedData) {
        String issuerName = null;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            CMSSignedData sd = new CMSSignedData(decoder.decodeBuffer(signedData));
            Store store = sd.getCertificates();
            SignerInformationStore signers = sd.getSignerInfos();
            Collection c2 = signers.getSigners();
            for (SignerInformation signer : c2) {
                RDN[] rdns;
                Collection certCollection = store.getMatches((Selector)signer.getSID());
                Iterator certIt = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                X500Name x500Name = cert.getIssuer();
                RDN[] arr$ = rdns = x500Name.getRDNs();
                int len$ = rdns.length;
                block3: for (int i$ = 0; i$ < len$; ++i$) {
                    RDN rdn = arr$[i$];
                    for (AttributeTypeAndValue attribute : rdn.getTypesAndValues()) {
                        if (!a.equals(attribute.getType().toString())) continue;
                        issuerName = attribute.getValue().toString();
                        continue block3;
                    }
                }
            }
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            System.out.println("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25");
        }
        return issuerName;
    }

    public static boolean b(String signedData) {
        boolean signRet = false;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            CMSSignedData sd = new CMSSignedData(decoder.decodeBuffer(signedData));
            Store store = sd.getCertificates();
            SignerInformationStore signers = sd.getSignerInfos();
            Collection c2 = signers.getSigners();
            for (SignerInformation signer : c2) {
                Collection certCollection = store.getMatches((Selector)signer.getSID());
                Iterator certIt = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert))) {
                    signRet = true;
                    System.out.println("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u6210\u529f");
                    continue;
                }
                signRet = false;
            }
        }
        catch (Exception e2) {
            signRet = false;
            e2.printStackTrace();
            System.out.println("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25");
        }
        return signRet;
    }

    public static byte[] a(String tspurl, byte[] request) {
        try {
            URL url = new URL(tspurl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/timestamp-query");
            con.setRequestProperty("Accept", "application/timestamp-reply");
            con.setRequestProperty("Content-length", String.valueOf(request.length));
            OutputStream out = con.getOutputStream();
            out.write(request);
            out.flush();
            InputStream in = con.getInputStream();
            TimeStampResp resp = TimeStampResp.getInstance((Object)new ASN1InputStream(in).readObject());
            TimeStampResponse response = new TimeStampResponse(resp);
            return response.getEncoded();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean a(byte[] indata, byte[] tsResponseData) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(indata);
            byte[] digest = messageDigest.digest();
            TimeStampRequestGenerator reqgen = new TimeStampRequestGenerator();
            TimeStampRequest req = reqgen.generate(TSPAlgorithms.SHA1, digest);
            ByteArrayInputStream bIn = new ByteArrayInputStream(tsResponseData);
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            TimeStampResp resp = TimeStampResp.getInstance((Object)aIn.readObject());
            TimeStampResponse response = new TimeStampResponse(resp);
            response.validate(req);
            aIn.close();
            return true;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return false;
        }
    }

    public static byte[] a(byte[] tsResponseData, String type) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(tsResponseData);
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            TimeStampResp resp = TimeStampResp.getInstance((Object)aIn.readObject());
            TimeStampResponse response = new TimeStampResponse(resp);
            if (type.equals("1")) {
                return response.getTimeStampToken().getTimeStampInfo().getGenTime().toString().getBytes();
            }
            if (type.equals("2")) {
                return response.getTimeStampToken().toCMSSignedData().getEncoded();
            }
            if (type.equals("3")) {
                CertStore store = response.getTimeStampToken().toCMSSignedData().getCertificatesAndCRLs("Collection", "BC");
                response.getTimeStampToken().getSID();
                Collection<? extends Certificate> certs = store.getCertificates(null);
                Iterator<? extends Certificate> iter = certs.iterator();
                if (iter.hasNext()) {
                    X509Certificate cert = (X509Certificate)iter.next();
                    return cert.getEncoded();
                }
            }
            return null;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean d(byte[] certBytes) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(certBytes);
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            X509CertificateStructure cert = new X509CertificateStructure(seq);
            SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMddHHmmss");
            String s2 = format1.format(new Date()) + "GMT+00:00";
            return s2.compareTo(cert.getStartDate().getTime().toString()) > 0 && s2.compareTo(cert.getEndDate().getTime().toString()) < 0;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean e(byte[] certBytes) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(certBytes);
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            X509CertificateStructure cert = new X509CertificateStructure(seq);
            SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMddhhmmss");
            String s2 = format1.format(new Date()) + "GMT+00:00";
            return s2.compareTo(cert.getStartDate().getTime().toString()) > 0 && s2.compareTo(cert.getEndDate().getTime().toString()) < 0;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return false;
        }
    }

    public boolean a(SecurityProvider provider, byte[] certBytes) {
        try {
            boolean result = true;
            String crlPath = this.getClass().getClassLoader().getResource("").getFile();
            ByteArrayInputStream bIn = new ByteArrayInputStream(certBytes);
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            X509CertificateStructure cert = new X509CertificateStructure(seq);
            String certsn = cert.getSerialNumber().getValue().toString(16).toUpperCase();
            FileInputStream fis = new FileInputStream(crlPath + "ca.crl");
            X509CRL aCrl = (X509CRL)provider.factory().generateCRL(fis);
            Set<? extends X509CRLEntry> tSet = aCrl.getRevokedCertificates();
            for (X509CRLEntry x509CRLEntry : tSet) {
                String sn = x509CRLEntry.getSerialNumber().toString(16).toUpperCase();
                aCrl.getIssuerDN();
                if (!sn.equals(certsn)) continue;
                result = false;
                break;
            }
            return result;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean b(byte[] certBytes, String file) {
        boolean result = false;
        try {
            File f2;
            ByteArrayInputStream bIn = new ByteArrayInputStream(certBytes);
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            X509CertificateStructure cert = new X509CertificateStructure(seq);
            String certSn = cert.getSerialNumber().getValue().toString(16);
            if (certSn == null || certSn.length() <= 0) {
                return false;
            }
            if ((certSn = certSn.toUpperCase()).startsWith("00")) {
                certSn = certSn.substring(2);
            }
            if (certSn.startsWith("0")) {
                certSn = certSn.substring(1);
            }
            if (!(f2 = new File(file)).exists()) {
                return true;
            }
            RandomAccessFile raf = new RandomAccessFile(f2, "r");
            String str = raf.readLine();
            while (str != null) {
                if (str.startsWith(certSn)) {
                    result = true;
                    break;
                }
                str = raf.readLine();
            }
            raf.close();
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return result;
        }
        return result;
    }

    public static String a(SecurityProvider provider, String oid, byte[] certBytes) {
        String result = "";
        try {
            if (!provider.equals((Object)SecurityProvider.Default)) {
                ByteArrayInputStream fi = new ByteArrayInputStream(certBytes);
                X509Extension x509 = null;
                while (((InputStream)fi).available() > 0) {
                    x509 = (X509Certificate)provider.factory().generateCertificate(fi);
                }
                if (x509 != null) {
                    result = x509.getExtensionValue(oid) != null ? new String(x509.getExtensionValue(oid), "UTF-8") : "";
                }
            } else {
                ByteArrayInputStream bIn = new ByteArrayInputStream(certBytes);
                ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
                ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
                X509CertificateStructure cert = new X509CertificateStructure(seq);
                X509Extensions exts = cert.getTBSCertificate().getExtensions();
                DERObjectIdentifier derOid = new DERObjectIdentifier(oid);
                if (exts != null) {
                    com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension item = exts.getExtension(derOid);
                    item.isCritical();
                    ASN1OctetString value = item.getValue();
                    result = new String(value.getOctets());
                }
            }
            return result;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static String c(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x2 = 0;
        while (x2 < len) {
            int aChar;
            if ((aChar = theString.charAt(x2++)) == 92) {
                if ((aChar = theString.charAt(x2++)) == 117) {
                    int value = 0;
                    block6: for (int i2 = 0; i2 < 4; ++i2) {
                        char c2 = theString.charAt(x2++);
                        aChar = c2;
                        switch (c2) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private static void b(X509Extensions ext) {
        DERObjectIdentifier derOid = new DERObjectIdentifier("2.5.29.15");
        try {
            com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension item = ext.getExtension(derOid);
            item.isCritical();
            item.getValue();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void c(X509Extensions ext) {
        block8: {
            byte[] bytes = esign.utils.security.b.a("2.5.29.19", ext);
            if (bytes != null) {
                try {
                    ASN1InputStream dIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
                    ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                    if (seq.size() == 2) {
                        if (((DERBoolean)seq.getObjectAt(0)).isTrue()) {
                            int pathlen = ((DERInteger)seq.getObjectAt(1)).getValue().intValue();
                            System.out.println("\u662fCA\u8bc1\u4e66/tmax path len=" + pathlen);
                        } else {
                            System.out.println("\u4e0d\u662fca\u8bc1\u4e66!");
                        }
                        break block8;
                    }
                    if (seq.size() == 1) {
                        System.out.println("\u4e0d\u662fca\u8bc1\u4e66!" + seq.getObjectAt(1).toString());
                        if (seq.getObjectAt(0) instanceof DERBoolean && ((DERBoolean)seq.getObjectAt(0)).isTrue()) {
                            System.out.println(Integer.MAX_VALUE);
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    throw new RuntimeException("error processing key usage extension");
                }
            }
        }
    }

    private static String d(X509Extensions ext) throws IOException {
        String crlUrls = "";
        byte[] crldpExt = esign.utils.security.b.a(X509Extensions.CRLDistributionPoints.getId(), ext);
        if (crldpExt == null) {
            return crlUrls;
        }
        ASN1InputStream oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExt));
        byte[] crldpExtOctets = oAsnInStream.readObject().getEncoded();
        ASN1InputStream oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExtOctets));
        CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)oAsnInStream2.readObject());
        for (DistributionPoint dp : distPoint.getDistributionPoints()) {
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            GeneralName[] genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames();
            for (int j2 = 0; j2 < genNames.length; ++j2) {
                if (genNames[j2].getTagNo() != 6) continue;
                String url = DERIA5String.getInstance((Object)genNames[j2].getName()).getString();
                crlUrls = crlUrls + url;
            }
        }
        return crlUrls;
    }

    public static void a(X509Extensions ext) {
        byte[] byContent = esign.utils.security.b.a("2.5.29.32", ext);
        if (byContent != null) {
            try {
                ASN1InputStream dIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(byContent));
                ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                DERDump.dumpAsString((ASN1Primitive)seq);
                for (int i2 = 0; i2 < seq.size(); ++i2) {
                    esign.utils.security.b.a((ASN1Sequence)seq.getObjectAt(i2));
                }
                return;
            }
            catch (Exception exception) {
                Exception e2 = exception;
                exception.printStackTrace();
            }
        }
    }

    private static void a(ASN1Sequence seq) {
        if (seq.size() == 2) {
            DERObjectIdentifier objID = (DERObjectIdentifier)seq.getObjectAt(0);
            System.out.println("\u8bc1\u4e66\u7b56\u7565\u6807\u8bc6:" + objID.getId());
            ASN1Sequence seqQualifier = (ASN1Sequence)seq.getObjectAt(1);
            for (int i2 = 0; i2 < seqQualifier.size(); ++i2) {
                esign.utils.security.b.b((ASN1Sequence)seqQualifier.getObjectAt(i2));
            }
            return;
        }
        System.out.println("\u89e3\u6790\u7b56\u7565\u58f0\u660e\u65f6\u51fa\u9519!");
    }

    private static void b(ASN1Sequence seq) {
        if (seq.size() == 2) {
            DERObjectIdentifier objID = (DERObjectIdentifier)seq.getObjectAt(0);
            System.out.println("\u7b56\u7565\u58f0\u660e\u6807\u8bc6:" + objID.getId());
            DERIA5String ia5 = (DERIA5String)seq.getObjectAt(1);
            System.out.println("\u58f0\u660e\u5185\u5bb9:" + ia5.getString());
        }
    }

    private static byte[] a(String oid, X509Extensions exts) {
        com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension ext;
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            return ext.getValue().getOctets();
        }
        return null;
    }

    public static Certificate f(byte[] bts) {
        Certificate cert = null;
        try {
            ByteArrayInputStream fi = new ByteArrayInputStream(bts);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (((InputStream)fi).available() > 0) {
                cert = cf.generateCertificate(fi);
            }
            return cert;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static Certificate d(String fp) {
        Certificate cert = null;
        try {
            FileInputStream fi = new FileInputStream(fp);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (fi.available() > 0) {
                cert = cf.generateCertificate(fi);
            }
            return cert;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return cert;
        }
    }

    public static String a(String dn, String key) {
        String[] infos = dn.split(",");
        if (0 == infos.length) {
            return "";
        }
        for (int i2 = 0; i2 < infos.length; ++i2) {
            infos[i2] = infos[i2].trim();
            if (!infos[i2].toUpperCase().contains(key.toUpperCase())) continue;
            return infos[i2].substring(infos[i2].indexOf(key.toUpperCase()) + key.length(), infos[i2].length());
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] e(String filename) throws IOException {
        byte[] byArray;
        File f2 = new File(filename);
        if (!f2.exists()) {
            throw new FileNotFoundException(filename);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)f2.length());
        BufferedInputStream in = null;
        try {
            int len;
            in = new BufferedInputStream(new FileInputStream(f2));
            byte[] buffer = new byte[1024];
            while (-1 != (len = in.read(buffer, 0, 1024))) {
                bos.write(buffer, 0, len);
            }
            byArray = bos.toByteArray();
        }
        catch (IOException iOException) {
            try {
                IOException e3 = iOException;
                iOException.printStackTrace();
                throw e3;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException2) {
                    IOException e4 = iOException2;
                    iOException2.printStackTrace();
                }
                bos.close();
                throw throwable;
            }
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            IOException e2 = iOException;
            iOException.printStackTrace();
        }
        bos.close();
        return byArray;
    }

    public static boolean a(PublicKey pubKey, byte[] plainText, byte[] signText) {
        try {
            Signature signatureChecker = Signature.getInstance("SHA1withRSA");
            signatureChecker.initVerify(pubKey);
            signatureChecker.update(plainText);
            signatureChecker.update((byte)48);
            return signatureChecker.verify(signText);
        }
        catch (Throwable e2) {
            System.out.println("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            e2.printStackTrace();
            return false;
        }
    }

    public byte[] a(SecurityProvider provider, byte[] inData, byte[] signedAttributes, byte[] certbytes) {
        try {
            ByteArrayInputStream fi = new ByteArrayInputStream(certbytes);
            X509Certificate userCert = null;
            while (((InputStream)fi).available() > 0) {
                userCert = (X509Certificate)provider.factory().generateCertificate(fi);
            }
            ContentInfo.class.getField("DATA_OID");
            DerValue de = new DerValue(esign.utils.b.a(inData).trim());
            ContentInfo contentInfo = new ContentInfo(ContentInfo.DIGESTED_DATA_OID, de);
            BigInteger serial = userCert.getSerialNumber();
            Class<?> x500Name = Class.forName("sun.security.x509.X500Name");
            Constructor<?> x500NameConstructor = x500Name.getConstructor(String.class);
            Object x500NameObject = x500NameConstructor.newInstance(userCert.getIssuerDN().getName());
            String digestAlgorithm = "SHA1";
            X509Certificate[] certificates = new X509Certificate[]{userCert};
            Class<?> algorithmId = Class.forName("sun.security.x509.AlgorithmId");
            Method algorithmIdGet = algorithmId.getMethod("get", String.class);
            Object digestAlgorithmId = algorithmIdGet.invoke(null, digestAlgorithm);
            Field algorithmIdfield = algorithmId.getField("RSAEncryption_oid");
            Object rsaOid = algorithmIdfield.get(null);
            Class<?> objectIdentifier = Class.forName("sun.security.util.ObjectIdentifier");
            Constructor<?> algorithmConstructor = algorithmId.getConstructor(objectIdentifier);
            Object algorithmRsaOid = algorithmConstructor.newInstance(rsaOid);
            Constructor signerInfoConstructor = SignerInfo.class.getConstructor(x500Name, BigInteger.class, algorithmId, PKCS9Attributes.class, algorithmId, byte[].class, PKCS9Attributes.class);
            SignerInfo si = (SignerInfo)signerInfoConstructor.newInstance(x500NameObject, serial, digestAlgorithmId, null, algorithmRsaOid, signedAttributes, null);
            SignerInfo[] signerInfos = new SignerInfo[]{si};
            Object digestAlgorithmIds = Array.newInstance(algorithmId, 1);
            Array.set(digestAlgorithmIds, 0, digestAlgorithmId);
            Constructor pkcs7Constructor = PKCS7.class.getConstructor(digestAlgorithmIds.getClass(), ContentInfo.class, X509Certificate[].class, signerInfos.getClass());
            PKCS7 p7 = (PKCS7)pkcs7Constructor.newInstance(digestAlgorithmIds, contentInfo, certificates, signerInfos);
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            p7.encodeSignedData(baout);
            return baout.toByteArray();
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] c(byte[] signeddata, String type) {
        try {
            PKCS7 p7 = new PKCS7(signeddata);
            if (type.equals("1")) {
                return esign.utils.b.a(p7.getContentInfo().getContent().getAsString());
            }
            if (type.equals("2")) {
                return p7.getSignerInfos()[0].getEncryptedDigest();
            }
            if (type.equals("3")) {
                return p7.getCertificates()[0].getEncoded();
            }
            return null;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] g(byte[] indata) {
        try {
            MessageDigest md = MessageDigest.getInstance("sha-1");
            md.update(indata);
            byte[] result = md.digest();
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean a(String cert, String plaintext, String signText, String signalg) {
        try {
            Signature signatureChecker = Signature.getInstance(signalg);
            ByteArrayInputStream fi = new ByteArrayInputStream(esign.utils.b.a(cert));
            Certificate x509cert = null;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (((InputStream)fi).available() > 0) {
                x509cert = cf.generateCertificate(fi);
            }
            if (cert != null) {
                signatureChecker.initVerify(x509cert.getPublicKey());
                signatureChecker.update(esign.utils.b.a(plaintext));
                return signatureChecker.verify(esign.utils.b.a(signText));
            }
            return false;
        }
        catch (Throwable e2) {
            System.out.println("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            e2.printStackTrace();
            return false;
        }
    }

    static {
        Provider.BC.install();
    }
}

