/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.util;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.BERApplicationSpecific;
import com.timevale.tgtext.bouncycastle.asn1.BERConstructedOctetString;
import com.timevale.tgtext.bouncycastle.asn1.BEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.BERSequence;
import com.timevale.tgtext.bouncycastle.asn1.BERSet;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERApplicationSpecific;
import com.timevale.tgtext.bouncycastle.asn1.DERBMPString;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERBoolean;
import com.timevale.tgtext.bouncycastle.asn1.DEREnumerated;
import com.timevale.tgtext.bouncycastle.asn1.DERExternal;
import com.timevale.tgtext.bouncycastle.asn1.DERGeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DERPrintableString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERT61String;
import com.timevale.tgtext.bouncycastle.asn1.DERUTCTime;
import com.timevale.tgtext.bouncycastle.asn1.DERUTF8String;
import com.timevale.tgtext.bouncycastle.asn1.DERVisibleString;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Enumeration;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    /*
     * Enabled aggressive block sorting
     */
    static void _dumpAsString(String indent, boolean verbose, ASN1Primitive obj, StringBuffer buf) {
        String tab;
        Enumeration e2;
        String nl;
        block44: {
            String tab2;
            Enumeration e3;
            block43: {
                block45: {
                    nl = System.getProperty("line.separator");
                    if (!(obj instanceof ASN1Sequence)) break block45;
                    e3 = ((ASN1Sequence)obj).getObjects();
                    tab2 = indent + TAB;
                    buf.append(indent);
                    if (obj instanceof BERSequence) {
                        buf.append("BER Sequence");
                        break block43;
                    } else if (obj instanceof DERSequence) {
                        buf.append("DER Sequence");
                        break block43;
                    } else {
                        buf.append("Sequence");
                    }
                    break block43;
                }
                if (obj instanceof ASN1TaggedObject) {
                    String tab3 = indent + TAB;
                    buf.append(indent);
                    if (obj instanceof BERTaggedObject) {
                        buf.append("BER Tagged [");
                    } else {
                        buf.append("Tagged [");
                    }
                    ASN1TaggedObject o2 = (ASN1TaggedObject)obj;
                    buf.append(Integer.toString(o2.getTagNo()));
                    buf.append(']');
                    if (!o2.isExplicit()) {
                        buf.append(" IMPLICIT ");
                    }
                    buf.append(nl);
                    if (o2.isEmpty()) {
                        buf.append(tab3);
                        buf.append("EMPTY");
                        buf.append(nl);
                        return;
                    }
                    ASN1Dump._dumpAsString(tab3, verbose, o2.getObject(), buf);
                    return;
                }
                if (obj instanceof ASN1Set) {
                    e2 = ((ASN1Set)obj).getObjects();
                    tab = indent + TAB;
                    buf.append(indent);
                    if (obj instanceof BERSet) {
                        buf.append("BER Set");
                        break block44;
                    } else {
                        buf.append("DER Set");
                    }
                    break block44;
                } else {
                    if (obj instanceof ASN1OctetString) {
                        ASN1OctetString oct = (ASN1OctetString)obj;
                        if (obj instanceof BEROctetString || obj instanceof BERConstructedOctetString) {
                            buf.append(indent + "BER Constructed Octet String[" + oct.getOctets().length + "] ");
                        } else {
                            buf.append(indent + "DER Octet String[" + oct.getOctets().length + "] ");
                        }
                        if (verbose) {
                            buf.append(ASN1Dump.dumpBinaryDataAsString(indent, oct.getOctets()));
                            return;
                        }
                        buf.append(nl);
                        return;
                    }
                    if (obj instanceof ASN1ObjectIdentifier) {
                        buf.append(indent + "ObjectIdentifier(" + ((ASN1ObjectIdentifier)obj).getId() + ")" + nl);
                        return;
                    }
                    if (obj instanceof DERBoolean) {
                        buf.append(indent + "Boolean(" + ((DERBoolean)obj).isTrue() + ")" + nl);
                        return;
                    }
                    if (obj instanceof ASN1Integer) {
                        buf.append(indent + "Integer(" + ((ASN1Integer)obj).getValue() + ")" + nl);
                        return;
                    }
                    if (obj instanceof DERBitString) {
                        DERBitString bt2 = (DERBitString)obj;
                        buf.append(indent + "DER Bit String[" + bt2.getBytes().length + ", " + bt2.getPadBits() + "] ");
                        if (verbose) {
                            buf.append(ASN1Dump.dumpBinaryDataAsString(indent, bt2.getBytes()));
                            return;
                        }
                        buf.append(nl);
                        return;
                    }
                    if (obj instanceof DERIA5String) {
                        buf.append(indent + "IA5String(" + ((DERIA5String)obj).getString() + ") " + nl);
                        return;
                    }
                    if (obj instanceof DERUTF8String) {
                        buf.append(indent + "UTF8String(" + ((DERUTF8String)obj).getString() + ") " + nl);
                        return;
                    }
                    if (obj instanceof DERPrintableString) {
                        buf.append(indent + "PrintableString(" + ((DERPrintableString)obj).getString() + ") " + nl);
                        return;
                    }
                    if (obj instanceof DERVisibleString) {
                        buf.append(indent + "VisibleString(" + ((DERVisibleString)obj).getString() + ") " + nl);
                        return;
                    }
                    if (obj instanceof DERBMPString) {
                        buf.append(indent + "BMPString(" + ((DERBMPString)obj).getString() + ") " + nl);
                        return;
                    }
                    if (obj instanceof DERT61String) {
                        buf.append(indent + "T61String(" + ((DERT61String)obj).getString() + ") " + nl);
                        return;
                    }
                    if (obj instanceof DERUTCTime) {
                        buf.append(indent + "UTCTime(" + ((DERUTCTime)obj).getTime() + ") " + nl);
                        return;
                    }
                    if (obj instanceof DERGeneralizedTime) {
                        buf.append(indent + "GeneralizedTime(" + ((DERGeneralizedTime)obj).getTime() + ") " + nl);
                        return;
                    }
                    if (obj instanceof BERApplicationSpecific) {
                        buf.append(ASN1Dump.outputApplicationSpecific("BER", indent, verbose, obj, nl));
                        return;
                    }
                    if (obj instanceof DERApplicationSpecific) {
                        buf.append(ASN1Dump.outputApplicationSpecific("DER", indent, verbose, obj, nl));
                        return;
                    }
                    if (obj instanceof DEREnumerated) {
                        DEREnumerated en2 = (DEREnumerated)obj;
                        buf.append(indent + "DER Enumerated(" + en2.getValue() + ")" + nl);
                        return;
                    }
                    if (!(obj instanceof DERExternal)) {
                        buf.append(indent + obj.toString() + nl);
                        return;
                    }
                    DERExternal ext = (DERExternal)obj;
                    buf.append(indent + "External " + nl);
                    String tab4 = indent + TAB;
                    if (ext.getDirectReference() != null) {
                        buf.append(tab4 + "Direct Reference: " + ext.getDirectReference().getId() + nl);
                    }
                    if (ext.getIndirectReference() != null) {
                        buf.append(tab4 + "Indirect Reference: " + ext.getIndirectReference().toString() + nl);
                    }
                    if (ext.getDataValueDescriptor() != null) {
                        ASN1Dump._dumpAsString(tab4, verbose, ext.getDataValueDescriptor(), buf);
                    }
                    buf.append(tab4 + "Encoding: " + ext.getEncoding() + nl);
                    ASN1Dump._dumpAsString(tab4, verbose, ext.getExternalContent(), buf);
                    return;
                }
            }
            buf.append(nl);
            while (e3.hasMoreElements()) {
                Object o3 = e3.nextElement();
                if (o3 == null || o3.equals(DERNull.INSTANCE)) {
                    buf.append(tab2);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o3 instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(tab2, verbose, (ASN1Primitive)o3, buf);
                    continue;
                }
                ASN1Dump._dumpAsString(tab2, verbose, ((ASN1Encodable)o3).toASN1Primitive(), buf);
            }
            return;
        }
        buf.append(nl);
        while (e2.hasMoreElements()) {
            Object o4 = e2.nextElement();
            if (o4 == null) {
                buf.append(tab);
                buf.append("NULL");
                buf.append(nl);
                continue;
            }
            if (o4 instanceof ASN1Primitive) {
                ASN1Dump._dumpAsString(tab, verbose, (ASN1Primitive)o4, buf);
                continue;
            }
            ASN1Dump._dumpAsString(tab, verbose, ((ASN1Encodable)o4).toASN1Primitive(), buf);
        }
    }

    private static String outputApplicationSpecific(String type, String indent, boolean verbose, ASN1Primitive obj, String nl) {
        DERApplicationSpecific app = (DERApplicationSpecific)obj;
        StringBuffer buf = new StringBuffer();
        if (app.isConstructed()) {
            try {
                ASN1Sequence s2 = ASN1Sequence.getInstance(app.getObject(16));
                buf.append(indent + type + " ApplicationSpecific[" + app.getApplicationTag() + "]" + nl);
                Enumeration e2 = s2.getObjects();
                while (e2.hasMoreElements()) {
                    ASN1Dump._dumpAsString(indent + TAB, verbose, (ASN1Primitive)e2.nextElement(), buf);
                }
            }
            catch (IOException e3) {
                buf.append(e3);
            }
            return buf.toString();
        }
        return indent + type + " ApplicationSpecific[" + app.getApplicationTag() + "] (" + new String(Hex.encode(app.getContents())) + ")" + nl;
    }

    public static String dumpAsString(Object obj) {
        return ASN1Dump.dumpAsString(obj, false);
    }

    public static String dumpAsString(Object obj, boolean verbose) {
        StringBuffer buf = new StringBuffer();
        if (obj instanceof ASN1Primitive) {
            ASN1Dump._dumpAsString("", verbose, (ASN1Primitive)obj, buf);
        } else if (obj instanceof ASN1Encodable) {
            ASN1Dump._dumpAsString("", verbose, ((ASN1Encodable)obj).toASN1Primitive(), buf);
        } else {
            return "unknown object type " + obj.toString();
        }
        return buf.toString();
    }

    private static String dumpBinaryDataAsString(String indent, byte[] bytes) {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        indent = indent + TAB;
        buf.append(nl);
        for (int i2 = 0; i2 < bytes.length; i2 += 32) {
            if (bytes.length - i2 > 32) {
                buf.append(indent);
                buf.append(new String(Hex.encode(bytes, i2, 32)));
                buf.append(TAB);
                buf.append(ASN1Dump.calculateAscString(bytes, i2, 32));
                buf.append(nl);
                continue;
            }
            buf.append(indent);
            buf.append(new String(Hex.encode(bytes, i2, bytes.length - i2)));
            for (int j2 = bytes.length - i2; j2 != 32; ++j2) {
                buf.append("  ");
            }
            buf.append(TAB);
            buf.append(ASN1Dump.calculateAscString(bytes, i2, bytes.length - i2));
            buf.append(nl);
        }
        return buf.toString();
    }

    private static String calculateAscString(byte[] bytes, int off, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = off; i2 != off + len; ++i2) {
            if (bytes[i2] < 32 || bytes[i2] > 126) continue;
            buf.append((char)bytes[i2]);
        }
        return buf.toString();
    }
}

