/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.voms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.x509.IetfAttrSyntax;
import com.timevale.tgtext.bouncycastle.x509.X509Attribute;
import com.timevale.tgtext.bouncycastle.x509.X509AttributeCertificate;
import java.util.ArrayList;
import java.util.List;

public class VOMSAttribute {
    public static final String VOMS_ATTR_OID = "1.3.6.1.4.1.8005.100.100.4";
    private X509AttributeCertificate myAC;
    private String myHostPort;
    private String myVo;
    private List myStringList = new ArrayList();
    private List myFQANs = new ArrayList();

    public VOMSAttribute(X509AttributeCertificate ac2) {
        if (ac2 == null) {
            throw new IllegalArgumentException("VOMSAttribute: AttributeCertificate is NULL");
        }
        this.myAC = ac2;
        X509Attribute[] l2 = ac2.getAttributes(VOMS_ATTR_OID);
        if (l2 == null) {
            return;
        }
        try {
            for (int i2 = 0; i2 != l2.length; ++i2) {
                IetfAttrSyntax attr = IetfAttrSyntax.getInstance(l2[i2].getValues()[0]);
                String url = ((DERIA5String)attr.getPolicyAuthority().getNames()[0].getName()).getString();
                int idx = url.indexOf("://");
                if (idx < 0 || idx == url.length() - 1) {
                    throw new IllegalArgumentException("Bad encoding of VOMS policyAuthority : [" + url + "]");
                }
                this.myVo = url.substring(0, idx);
                this.myHostPort = url.substring(idx + 3);
                if (attr.getValueType() != 1) {
                    throw new IllegalArgumentException("VOMS attribute values are not encoded as octet strings, policyAuthority = " + url);
                }
                ASN1OctetString[] values = (ASN1OctetString[])attr.getValues();
                for (int j2 = 0; j2 != values.length; ++j2) {
                    String fqan = new String(values[j2].getOctets());
                    FQAN f2 = new FQAN(fqan);
                    if (this.myStringList.contains(fqan) || !fqan.startsWith("/" + this.myVo + "/")) continue;
                    this.myStringList.add(fqan);
                    this.myFQANs.add(f2);
                }
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException ie = illegalArgumentException;
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Badly encoded VOMS extension in AC issued by " + ac2.getIssuer());
        }
    }

    public X509AttributeCertificate getAC() {
        return this.myAC;
    }

    public List getFullyQualifiedAttributes() {
        return this.myStringList;
    }

    public List getListOfFQAN() {
        return this.myFQANs;
    }

    public String getHostPort() {
        return this.myHostPort;
    }

    public String getVO() {
        return this.myVo;
    }

    public String toString() {
        return "VO      :" + this.myVo + "\nHostPort:" + this.myHostPort + "\nFQANs   :" + this.myFQANs;
    }

    public class FQAN {
        String fqan;
        String group;
        String role;
        String capability;

        public FQAN(String fqan) {
            this.fqan = fqan;
        }

        public FQAN(String group, String role, String capability) {
            this.group = group;
            this.role = role;
            this.capability = capability;
        }

        public String getFQAN() {
            if (this.fqan != null) {
                return this.fqan;
            }
            this.fqan = this.group + "/Role=" + (this.role != null ? this.role : "") + (this.capability != null ? "/Capability=" + this.capability : "");
            return this.fqan;
        }

        protected void split() {
            int i2 = this.fqan.indexOf("/Role=");
            if (i2 < 0) {
                return;
            }
            this.group = this.fqan.substring(0, i2);
            int j2 = this.fqan.indexOf("/Capability=", i2 + 6);
            String s2 = j2 < 0 ? this.fqan.substring(i2 + 6) : this.fqan.substring(i2 + 6, j2);
            this.role = s2.length() == 0 ? null : s2;
            s2 = j2 < 0 ? null : this.fqan.substring(j2 + 12);
            this.capability = s2 == null || s2.length() == 0 ? null : s2;
        }

        public String getGroup() {
            if (this.group == null && this.fqan != null) {
                this.split();
            }
            return this.group;
        }

        public String getRole() {
            if (this.group == null && this.fqan != null) {
                this.split();
            }
            return this.role;
        }

        public String getCapability() {
            if (this.group == null && this.fqan != null) {
                this.split();
            }
            return this.capability;
        }

        public String toString() {
            return this.getFQAN();
        }
    }
}

