/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.http;

import com.yeepay.shade.com.google.common.base.Joiner;
import com.yeepay.shade.com.google.common.base.Preconditions;
import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class HttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static BitSet URI_UNRESERVED_CHARACTERS;
    private static String[] PERCENT_ENCODED_STRINGS;
    private static final Joiner queryStringJoiner;

    private HttpUtils() {
    }

    public static String normalizePath(String path) {
        return HttpUtils.normalize(path).replace("%2F", "/");
    }

    public static String normalize(String value) {
        try {
            StringBuilder builder = new StringBuilder();
            for (byte b : value.getBytes(DEFAULT_ENCODING)) {
                if (URI_UNRESERVED_CHARACTERS.get(b & 0xFF)) {
                    builder.append((char)b);
                    continue;
                }
                builder.append(PERCENT_ENCODED_STRINGS[b & 0xFF]);
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getCanonicalURIPath(String path) {
        if (path == null) {
            return "/";
        }
        if (path.startsWith("/")) {
            return HttpUtils.normalizePath(path);
        }
        return "/" + HttpUtils.normalizePath(path);
    }

    public static String getCanonicalQueryString(Multimap<String, String> parameters, boolean forSignature) {
        if (parameters.isEmpty()) {
            return "";
        }
        ArrayList<String> parameterStrings = Lists.newArrayList();
        for (Map.Entry<String, Collection<String>> entry : parameters.asMap().entrySet()) {
            if (forSignature && "Authorization".equalsIgnoreCase(entry.getKey())) continue;
            String key = entry.getKey();
            Preconditions.checkNotNull(key, "parameter key should not be null");
            Collection<String> value = entry.getValue();
            if (null == value || 0 == value.size()) {
                if (forSignature) {
                    parameterStrings.add(HttpUtils.normalize(key) + '=');
                    continue;
                }
                parameterStrings.add(HttpUtils.normalize(key));
                continue;
            }
            for (String item : value) {
                parameterStrings.add(HttpUtils.normalize(key) + '=' + HttpUtils.normalize(item));
            }
        }
        Collections.sort(parameterStrings);
        return queryStringJoiner.join(parameterStrings);
    }

    public static String getCanonicalQueryString(Map<String, String[]> parameters, boolean forSignature) {
        if (parameters.isEmpty()) {
            return "";
        }
        ArrayList<String> parameterStrings = Lists.newArrayList();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (forSignature && "Authorization".equalsIgnoreCase(entry.getKey())) continue;
            String key = entry.getKey();
            Preconditions.checkNotNull(key, "parameter key should not be null");
            String[] value = entry.getValue();
            if (null == value || 0 == value.length) {
                if (forSignature) {
                    parameterStrings.add(HttpUtils.normalize(key) + '=');
                    continue;
                }
                parameterStrings.add(HttpUtils.normalize(key));
                continue;
            }
            for (String item : value) {
                parameterStrings.add(HttpUtils.normalize(key) + '=' + HttpUtils.normalize(item));
            }
        }
        Collections.sort(parameterStrings);
        return queryStringJoiner.join(parameterStrings);
    }

    static {
        int i;
        URI_UNRESERVED_CHARACTERS = new BitSet();
        PERCENT_ENCODED_STRINGS = new String[256];
        queryStringJoiner = Joiner.on('&');
        for (i = 97; i <= 122; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        URI_UNRESERVED_CHARACTERS.set(45);
        URI_UNRESERVED_CHARACTERS.set(46);
        URI_UNRESERVED_CHARACTERS.set(95);
        URI_UNRESERVED_CHARACTERS.set(126);
        for (i = 0; i < PERCENT_ENCODED_STRINGS.length; ++i) {
            HttpUtils.PERCENT_ENCODED_STRINGS[i] = String.format("%%%02X", i);
        }
    }
}

