/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.provider;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.bc.BCObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.DH;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.DSA;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.DSTU4145;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.EC;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ECGOST;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ElGamal;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.GOST;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.RSA;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.X509;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.GOST3411;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.MD2;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.MD4;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.MD5;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.RIPEMD128;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.RIPEMD160;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.RIPEMD256;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.RIPEMD320;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.SHA1;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.SHA224;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.SHA256;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.SHA3;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.SHA384;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.SHA512;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.Tiger;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.Whirlpool;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.AES;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.ARC4;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Blowfish;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.CAST5;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Camellia;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.DES;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.DESede;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.GOST28147;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Grain128;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Grainv1;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.HC128;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.IDEA;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Noekeon;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.RC2;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.RC5;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.RC6;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Rijndael;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.SEED;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Salsa20;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Serpent;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Skipjack;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.TEA;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.Twofish;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.VMPC;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.VMPCKSA3;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.XTEA;
import com.timevale.tgtext.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.timevale.tgtext.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.timevale.tgtext.bouncycastle.jce.provider.BrokenJCEBlockCipher;
import com.timevale.tgtext.bouncycastle.jce.provider.CertStoreCollectionSpi;
import com.timevale.tgtext.bouncycastle.jce.provider.JCEBlockCipher;
import com.timevale.tgtext.bouncycastle.jce.provider.JCEIESCipher;
import com.timevale.tgtext.bouncycastle.jce.provider.JCEMac;
import com.timevale.tgtext.bouncycastle.jce.provider.JCESecretKeyFactory;
import com.timevale.tgtext.bouncycastle.jce.provider.JCEStreamCipher;
import com.timevale.tgtext.bouncycastle.jce.provider.JDKAlgorithmParameters;
import com.timevale.tgtext.bouncycastle.jce.provider.JDKKeyStore;
import com.timevale.tgtext.bouncycastle.jce.provider.JDKPKCS12KeyStore;
import com.timevale.tgtext.bouncycastle.jce.provider.MultiCertStoreSpi;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXCertPathBuilderSpi;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXCertPathValidatorSpi;
import com.timevale.tgtext.bouncycastle.jce.provider.X509AttrCertParser;
import com.timevale.tgtext.bouncycastle.jce.provider.X509CRLParser;
import com.timevale.tgtext.bouncycastle.jce.provider.X509CertPairParser;
import com.timevale.tgtext.bouncycastle.jce.provider.X509CertParser;
import com.timevale.tgtext.bouncycastle.jce.provider.X509LDAPCertStoreSpi;
import com.timevale.tgtext.bouncycastle.jce.provider.X509StoreAttrCertCollection;
import com.timevale.tgtext.bouncycastle.jce.provider.X509StoreCRLCollection;
import com.timevale.tgtext.bouncycastle.jce.provider.X509StoreCertCollection;
import com.timevale.tgtext.bouncycastle.jce.provider.X509StoreCertPairCollection;
import com.timevale.tgtext.bouncycastle.jce.provider.X509StoreLDAPAttrCerts;
import com.timevale.tgtext.bouncycastle.jce.provider.X509StoreLDAPCRLs;
import com.timevale.tgtext.bouncycastle.jce.provider.X509StoreLDAPCertPairs;
import com.timevale.tgtext.bouncycastle.jce.provider.X509StoreLDAPCerts;
import com.timevale.tgtext.bouncycastle.jce.provider.a;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "BouncyCastle Security Provider v1.48";
    public static String PROVIDER_NAME = "BC";
    public static final ProviderConfiguration CONFIGURATION = new a();
    private static final Map keyInfoConverters = new HashMap();
    private static final String SYMMETRIC_CIPHER_PACKAGE = AES.class.getPackage().getName() + ".";
    private static final String[] SYMMETRIC_CIPHERS = new String[]{AES.class.getSimpleName(), ARC4.class.getSimpleName(), Blowfish.class.getSimpleName(), Camellia.class.getSimpleName(), CAST5.class.getSimpleName(), DES.class.getSimpleName(), DESede.class.getSimpleName(), GOST28147.class.getSimpleName(), Grainv1.class.getSimpleName(), Grain128.class.getSimpleName(), HC128.class.getSimpleName(), IDEA.class.getSimpleName(), Noekeon.class.getSimpleName(), RC2.class.getSimpleName(), RC5.class.getSimpleName(), RC6.class.getSimpleName(), Rijndael.class.getSimpleName(), Salsa20.class.getSimpleName(), SEED.class.getSimpleName(), Serpent.class.getSimpleName(), Skipjack.class.getSimpleName(), TEA.class.getSimpleName(), Twofish.class.getSimpleName(), VMPC.class.getSimpleName(), VMPCKSA3.class.getSimpleName(), XTEA.class.getSimpleName()};
    private static final String ASYMMETRIC_CIPHER_PACKAGE = X509.class.getPackage().getName() + ".";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{X509.class.getSimpleName()};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{DSA.class.getSimpleName(), DH.class.getSimpleName(), EC.class.getSimpleName(), RSA.class.getSimpleName(), GOST.class.getSimpleName(), ECGOST.class.getSimpleName(), ElGamal.class.getSimpleName(), DSTU4145.class.getSimpleName()};
    private static final String DIGEST_PACKAGE = BCMessageDigest.class.getPackage().getName() + ".";
    private static final String[] DIGESTS = new String[]{GOST3411.class.getSimpleName(), MD2.class.getSimpleName(), MD4.class.getSimpleName(), MD5.class.getSimpleName(), SHA1.class.getSimpleName(), RIPEMD128.class.getSimpleName(), RIPEMD160.class.getSimpleName(), RIPEMD256.class.getSimpleName(), RIPEMD320.class.getSimpleName(), SHA224.class.getSimpleName(), SHA256.class.getSimpleName(), SHA384.class.getSimpleName(), SHA512.class.getSimpleName(), SHA3.class.getSimpleName(), Tiger.class.getSimpleName(), Whirlpool.class.getSimpleName()};

    public BouncyCastleProvider() {
        super(PROVIDER_NAME, 1.48, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BouncyCastleProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.loadAlgorithms(DIGEST_PACKAGE, DIGESTS);
        this.loadAlgorithms(SYMMETRIC_CIPHER_PACKAGE, SYMMETRIC_CIPHERS);
        this.loadAlgorithms(ASYMMETRIC_CIPHER_PACKAGE, ASYMMETRIC_GENERIC);
        this.loadAlgorithms(ASYMMETRIC_CIPHER_PACKAGE, ASYMMETRIC_CIPHERS);
        this.put("X509Store.CERTIFICATE/COLLECTION", X509StoreCertCollection.class.getCanonicalName());
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", X509StoreAttrCertCollection.class.getCanonicalName());
        this.put("X509Store.CRL/COLLECTION", X509StoreCRLCollection.class.getCanonicalName());
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", X509StoreCertPairCollection.class.getCanonicalName());
        this.put("X509Store.CERTIFICATE/LDAP", X509StoreLDAPCerts.class.getCanonicalName());
        this.put("X509Store.CRL/LDAP", X509StoreLDAPCRLs.class.getCanonicalName());
        this.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", X509StoreLDAPAttrCerts.class);
        this.put("X509Store.CERTIFICATEPAIR/LDAP", X509StoreLDAPCertPairs.class.getCanonicalName());
        this.put("X509StreamParser.CERTIFICATE", X509CertParser.class.getCanonicalName());
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", X509AttrCertParser.class.getCanonicalName());
        this.put("X509StreamParser.CRL", X509CRLParser.class.getCanonicalName());
        this.put("X509StreamParser.CERTIFICATEPAIR", X509CertPairParser.class.getCanonicalName());
        this.put("KeyStore.BKS", JDKKeyStore.class.getCanonicalName());
        this.put("KeyStore.BouncyCastle", JDKKeyStore.class.getCanonicalName() + "$" + JDKKeyStore.BouncyCastleStore.class.getSimpleName());
        this.put("KeyStore.PKCS12", JDKPKCS12KeyStore.class.getCanonicalName() + "$" + JDKPKCS12KeyStore.BCPKCS12KeyStore.class.getSimpleName());
        this.put("KeyStore.BCPKCS12", JDKPKCS12KeyStore.class.getCanonicalName() + "$" + JDKPKCS12KeyStore.BCPKCS12KeyStore.class.getSimpleName());
        this.put("KeyStore.PKCS12-DEF", JDKPKCS12KeyStore.class.getCanonicalName() + "$" + JDKPKCS12KeyStore.DefPKCS12KeyStore.class.getSimpleName());
        this.put("KeyStore.PKCS12-3DES-40RC2", JDKPKCS12KeyStore.class.getCanonicalName() + "$" + JDKPKCS12KeyStore.BCPKCS12KeyStore.class.getSimpleName());
        this.put("KeyStore.PKCS12-3DES-3DES", JDKPKCS12KeyStore.class.getCanonicalName() + "$" + JDKPKCS12KeyStore.BCPKCS12KeyStore3DES.class.getSimpleName());
        this.put("KeyStore.PKCS12-DEF-3DES-40RC2", JDKPKCS12KeyStore.class.getCanonicalName() + "$" + JDKPKCS12KeyStore.DefPKCS12KeyStore.class.getSimpleName());
        this.put("KeyStore.PKCS12-DEF-3DES-3DES", JDKPKCS12KeyStore.class.getCanonicalName() + "$" + JDKPKCS12KeyStore.DefPKCS12KeyStore3DES.class.getSimpleName());
        this.put("Alg.Alias.KeyStore.UBER", "BouncyCastle");
        this.put("Alg.Alias.KeyStore.BOUNCYCASTLE", "BouncyCastle");
        this.put("Alg.Alias.KeyStore.bouncycastle", "BouncyCastle");
        this.put("AlgorithmParameters.IES", JDKAlgorithmParameters.class.getCanonicalName() + "$" + JDKAlgorithmParameters.IES.class.getSimpleName());
        this.put("AlgorithmParameters.PKCS12PBE", JDKAlgorithmParameters.class.getCanonicalName() + "$" + JDKAlgorithmParameters.PKCS12PBE.class.getSimpleName());
        this.put("AlgorithmParameters." + PKCSObjectIdentifiers.id_PBKDF2, JDKAlgorithmParameters.class.getCanonicalName() + "$" + JDKAlgorithmParameters.PBKDF2.class.getSimpleName());
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND3-KEYTRIPLEDES", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND2-KEYTRIPLEDES", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDRC2", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDRC4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDDES3KEY-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDDES2KEY-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND40BITRC2-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND40BITRC4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITRC2-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITRC4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.1", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.2", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.3", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.5", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.6", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3KeyTripleDES", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("AlgorithmParameters.SHA1WITHECDSA", "com.timevale.tgtext.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("AlgorithmParameters.SHA224WITHECDSA", "com.timevale.tgtext.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("AlgorithmParameters.SHA256WITHECDSA", "com.timevale.tgtext.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("AlgorithmParameters.SHA384WITHECDSA", "com.timevale.tgtext.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("AlgorithmParameters.SHA512WITHECDSA", "com.timevale.tgtext.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("Alg.Alias.Cipher.PBEWithSHAAnd3KeyTripleDES", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Cipher.IES", JCEIESCipher.class.getCanonicalName() + "$" + JCEIESCipher.IES.class.getSimpleName());
        this.put("Cipher.BrokenIES", JCEIESCipher.class.getCanonicalName() + "$" + JCEIESCipher.BrokenIES.class.getSimpleName());
        this.put("Cipher.PBEWITHMD5ANDDES", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithMD5AndDES.class.getSimpleName());
        this.put("Cipher.BROKENPBEWITHMD5ANDDES", BrokenJCEBlockCipher.class.getCanonicalName() + "$" + BrokenJCEBlockCipher.BrokePBEWithMD5AndDES.class.getSimpleName());
        this.put("Cipher.PBEWITHMD5ANDRC2", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithMD5AndRC2.class.getSimpleName());
        this.put("Cipher.PBEWITHSHA1ANDDES", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithSHA1AndDES.class.getSimpleName());
        this.put("Cipher.BROKENPBEWITHSHA1ANDDES", BrokenJCEBlockCipher.class.getCanonicalName() + "$" + BrokenJCEBlockCipher.BrokePBEWithSHA1AndDES.class.getSimpleName());
        this.put("Cipher.PBEWITHSHA1ANDRC2", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithSHA1AndRC2.class.getSimpleName());
        this.put("Cipher.PBEWITHSHAAND128BITRC2-CBC", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithSHAAnd128BitRC2.class.getSimpleName());
        this.put("Cipher.PBEWITHSHAAND40BITRC2-CBC", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithSHAAnd40BitRC2.class.getSimpleName());
        this.put("Cipher.PBEWITHSHAAND128BITRC4", JCEStreamCipher.class.getCanonicalName() + "$" + JCEStreamCipher.PBEWithSHAAnd128BitRC4.class.getSimpleName());
        this.put("Cipher.PBEWITHSHAAND40BITRC4", JCEStreamCipher.class.getCanonicalName() + "$" + JCEStreamCipher.PBEWithSHAAnd40BitRC4.class.getSimpleName());
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITRC2-CBC", "PBEWITHSHAAND128BITRC2-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND40BITRC2-CBC", "PBEWITHSHAAND40BITRC2-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITRC4", "PBEWITHSHAAND128BITRC4");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND40BITRC4", "PBEWITHSHAAND40BITRC4");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.put("Cipher.PBEWITHSHAAND128BITAES-CBC-BC", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithAESCBC.class.getSimpleName());
        this.put("Cipher.PBEWITHSHAAND192BITAES-CBC-BC", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithAESCBC.class.getSimpleName());
        this.put("Cipher.PBEWITHSHAAND256BITAES-CBC-BC", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithAESCBC.class.getSimpleName());
        this.put("Cipher.PBEWITHSHA256AND128BITAES-CBC-BC", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithAESCBC.class.getSimpleName());
        this.put("Cipher.PBEWITHSHA256AND192BITAES-CBC-BC", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithAESCBC.class.getSimpleName());
        this.put("Cipher.PBEWITHSHA256AND256BITAES-CBC-BC", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithAESCBC.class.getSimpleName());
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-256AND128BITAES-CBC-BC", "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-256AND192BITAES-CBC-BC", "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-256AND256BITAES-CBC-BC", "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.put("Cipher.PBEWITHMD5AND128BITAES-CBC-OPENSSL", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithAESCBC.class.getSimpleName());
        this.put("Cipher.PBEWITHMD5AND192BITAES-CBC-OPENSSL", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithAESCBC.class.getSimpleName());
        this.put("Cipher.PBEWITHMD5AND256BITAES-CBC-OPENSSL", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithAESCBC.class.getSimpleName());
        this.put("Cipher.PBEWITHSHAANDTWOFISH-CBC", JCEBlockCipher.class.getCanonicalName() + "$" + JCEBlockCipher.PBEWithSHAAndTwofish.class.getSimpleName());
        this.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", BrokenJCEBlockCipher.class.getCanonicalName() + "$" + BrokenJCEBlockCipher.OldPBEWithSHAAndTwofish.class.getSimpleName());
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC, "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC, "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC, "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC, "PBEWITHSHA1ANDRC2");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.1", "PBEWITHSHAAND128BITRC4");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.2", "PBEWITHSHAAND40BITRC4");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.5", "PBEWITHSHAAND128BITRC2-CBC");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.6", "PBEWITHSHAAND40BITRC2-CBC");
        this.put("SecretKeyFactory.PBEWITHMD2ANDDES", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithMD2AndDES.class.getSimpleName());
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC, "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC, "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC, "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC, "PBEWITHSHA1ANDRC2");
        this.put("SecretKeyFactory.PBEWITHMD2ANDRC2", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithMD2AndRC2.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHMD5ANDDES", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithMD5AndDES.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHMD5ANDRC2", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithMD5AndRC2.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHA1ANDDES", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHA1AndDES.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHA1ANDRC2", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHA1AndRC2.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAndDES3Key.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAndDES2Key.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHAAND128BITRC4", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAnd128BitRC4.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHAAND40BITRC4", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAnd40BitRC4.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHAAND128BITRC2-CBC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAnd128BitRC2.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHAAND40BITRC2-CBC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAnd40BitRC2.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHAANDTWOFISH-CBC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAndTwofish.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHHMACRIPEMD160", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithRIPEMD160.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHHMACSHA1", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHA.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHHMACTIGER", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithTiger.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHMD5AND128BITAES-CBC-OPENSSL", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithMD5And128BitAESCBCOpenSSL.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHMD5AND192BITAES-CBC-OPENSSL", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithMD5And192BitAESCBCOpenSSL.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHMD5AND256BITAES-CBC-OPENSSL", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithMD5And256BitAESCBCOpenSSL.class.getSimpleName());
        this.put("Alg.Alias.SecretKeyFactory.PBE", "PBE/PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHMD5ANDDES", "PBE/PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHA1ANDDES", "PBE/PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.OLDPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHAAND2-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.OLDPBEWITHSHAANDTWOFISH-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD2ANDDES-CBC", "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD2ANDRC2-CBC", "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD5ANDDES-CBC", "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD5ANDRC2-CBC", "PBEWITHMD5ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1ANDDES-CBC", "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1ANDRC2-CBC", "PBEWITHSHA1ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC, "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC, "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC, "PBEWITHMD5ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC, "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC, "PBEWITHSHA1ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.1", "PBEWITHSHAAND128BITRC4");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.2", "PBEWITHSHAAND40BITRC4");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.3", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.4", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.5", "PBEWITHSHAAND128BITRC2-CBC");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.6", "PBEWITHSHAAND40BITRC2-CBC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHHMACSHA", "PBEWITHHMACSHA1");
        this.put("Alg.Alias.SecretKeyFactory.1.3.14.3.2.26", "PBEWITHHMACSHA1");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("SecretKeyFactory.PBEWITHSHAAND128BITAES-CBC-BC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAnd128BitAESBC.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHAAND192BITAES-CBC-BC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAnd192BitAESBC.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHAAND256BITAES-CBC-BC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHAAnd256BitAESBC.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHA256AND128BITAES-CBC-BC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHA256And128BitAESBC.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHA256AND192BITAES-CBC-BC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHA256And192BitAESBC.class.getSimpleName());
        this.put("SecretKeyFactory.PBEWITHSHA256AND256BITAES-CBC-BC", JCESecretKeyFactory.class.getCanonicalName() + "$" + JCESecretKeyFactory.PBEWithSHA256And256BitAESBC.class.getSimpleName());
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND128BITAES-CBC-BC", "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND192BITAES-CBC-BC", "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND256BITAES-CBC-BC", "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.addMacAlgorithms();
        this.put("CertPathValidator.RFC3281", PKIXAttrCertPathValidatorSpi.class.getCanonicalName());
        this.put("CertPathBuilder.RFC3281", PKIXAttrCertPathBuilderSpi.class.getCanonicalName());
        this.put("CertPathValidator.RFC3280", PKIXCertPathValidatorSpi.class.getCanonicalName());
        this.put("CertPathBuilder.RFC3280", PKIXCertPathBuilderSpi.class.getCanonicalName());
        this.put("CertPathValidator.PKIX", PKIXCertPathValidatorSpi.class.getCanonicalName());
        this.put("CertPathBuilder.PKIX", PKIXCertPathBuilderSpi.class.getCanonicalName());
        this.put("CertStore.Collection", CertStoreCollectionSpi.class.getCanonicalName());
        this.put("CertStore.LDAP", X509LDAPCertStoreSpi.class.getCanonicalName());
        this.put("CertStore.Multi", MultiCertStoreSpi.class.getCanonicalName());
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }

    private void loadAlgorithms(String packageName, String[] names) {
        for (int i2 = 0; i2 != names.length; ++i2) {
            Class<?> clazz = null;
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                clazz = loader != null ? loader.loadClass(packageName + names[i2] + "$Mappings") : Class.forName(packageName + names[i2] + "$Mappings");
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
                continue;
            }
            catch (Exception e2) {
                throw new InternalError("cannot create instance of " + packageName + names[i2] + "$Mappings : " + e2);
            }
        }
    }

    private void addMacAlgorithms() {
        this.put("Mac.DESWITHISO9797", JCEMac.class.getCanonicalName() + "$" + JCEMac.DES9797Alg3.class.getSimpleName());
        this.put("Alg.Alias.Mac.DESISO9797MAC", "DESWITHISO9797");
        this.put("Mac.ISO9797ALG3MAC", JCEMac.class.getCanonicalName() + "$" + JCEMac.DES9797Alg3.class.getSimpleName());
        this.put("Alg.Alias.Mac.ISO9797ALG3", "ISO9797ALG3MAC");
        this.put("Mac.ISO9797ALG3WITHISO7816-4PADDING", JCEMac.class.getCanonicalName() + "$" + JCEMac.DES9797Alg3with7816d4.class.getSimpleName());
        this.put("Alg.Alias.Mac.ISO9797ALG3MACWITHISO7816-4PADDING", "ISO9797ALG3WITHISO7816-4PADDING");
        this.put("Mac.OLDHMACSHA384", JCEMac.class.getCanonicalName() + "$" + JCEMac.OldSHA384.class.getSimpleName());
        this.put("Mac.OLDHMACSHA512", JCEMac.class.getCanonicalName() + "$" + JCEMac.OldSHA512.class.getSimpleName());
        this.put("Mac.PBEWITHHMACSHA", JCEMac.class.getCanonicalName() + "$" + JCEMac.PBEWithSHA.class.getSimpleName());
        this.put("Mac.PBEWITHHMACSHA1", JCEMac.class.getCanonicalName() + "$" + JCEMac.PBEWithSHA.class.getSimpleName());
        this.put("Mac.PBEWITHHMACRIPEMD160", JCEMac.class.getCanonicalName() + "$" + JCEMac.PBEWithRIPEMD160.class.getSimpleName());
        this.put("Alg.Alias.Mac.1.3.14.3.2.26", "PBEWITHHMACSHA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String parameterName, Object parameter) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((a)CONFIGURATION).a(parameterName, parameter);
            return;
        }
    }

    @Override
    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + "." + name) || this.containsKey("Alg.Alias." + type + "." + name);
    }

    @Override
    public void addAlgorithm(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        keyInfoConverters.put(oid, keyInfoConverter);
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = (AsymmetricKeyInfoConverter)keyInfoConverters.get(publicKeyInfo.getAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePublic(publicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = (AsymmetricKeyInfoConverter)keyInfoConverters.get(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePrivate(privateKeyInfo);
    }
}

