/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.cmp;

import com.timevale.tgtext.bouncycastle.asn1.cmp.CertStatus;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.cmp.CMPException;
import com.timevale.tgtext.bouncycastle.cert.cmp.a;
import com.timevale.tgtext.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder certHolder, DigestCalculatorProvider digesterProvider) throws CMPException {
        DigestCalculator digester;
        AlgorithmIdentifier digAlg = this.digestAlgFinder.find(certHolder.toASN1Structure().getSignatureAlgorithm());
        if (digAlg == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digester = digesterProvider.get(digAlg);
        }
        catch (OperatorCreationException e2) {
            throw new CMPException("unable to create digester: " + e2.getMessage(), e2);
        }
        a.a(certHolder.toASN1Structure(), digester.getOutputStream());
        return Arrays.areEqual(this.certStatus.getCertHash().getOctets(), digester.getDigest());
    }
}

