/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.model.payment;

import com.alibaba.fastjson.annotation.JSONField;
import com.huifu.adapay.exception.BaseAdaPayException;
import com.huifu.adapay.model.BaseModel;
import com.huifu.adapay.model.payment.PaymentExpend;
import com.huifu.adapay.net.APIUrlEnum;
import com.huifu.adapay.net.AbstractRequest;
import java.util.HashMap;
import java.util.Map;

public class Payment
extends BaseModel {
    @JSONField(name="id")
    private String id;
    @JSONField(name="created_time")
    private String createdTime;
    @JSONField(name="order_no")
    private String orderNo;
    @JSONField(name="prod_mode")
    private String prodMode;
    @JSONField(name="app_id")
    private String appId;
    @JSONField(name="pay_channel")
    private String payChannel;
    @JSONField(name="pay_amt")
    private String payAmt;
    @JSONField(name="query_url")
    private String queryUrl;
    @JSONField(name="reason")
    private String reason;
    @JSONField(name="expend")
    private PaymentExpend expend;
    @JSONField(name="pay_id")
    private String payId;
    private static final String CLOSE = "/close";

    public static Payment create(Map<String, Object> params) throws BaseAdaPayException {
        return Payment.requestAdaPay(AbstractRequest.RequestMethod.POST, APIUrlEnum.PAYMENT_V1.getCode(), params, Payment.class);
    }

    public static Payment close(String id) throws BaseAdaPayException {
        return Payment.close(id, new HashMap<String, Object>(1));
    }

    public static Payment close(String id, Map<String, Object> params) throws BaseAdaPayException {
        String uri = APIUrlEnum.CLOSE_PAYMENT_V1.getCode() + id + CLOSE;
        return Payment.requestAdaPay(AbstractRequest.RequestMethod.POST, uri, params, Payment.class);
    }

    public static Payment query(String id) throws BaseAdaPayException {
        return Payment.query(id, new HashMap<String, Object>(1));
    }

    private static Payment query(String id, Map<String, Object> params) throws BaseAdaPayException {
        return Payment.requestAdaPay(AbstractRequest.RequestMethod.GET, APIUrlEnum.QUERY_PAYMENT_V1.getCode() + id, params, Payment.class);
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getPayChannel() {
        return this.payChannel;
    }

    public void setPayChannel(String payChannel) {
        this.payChannel = payChannel;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPayAmt() {
        return this.payAmt;
    }

    public String getProdMode() {
        return this.prodMode;
    }

    public void setProdMode(String prodMode) {
        this.prodMode = prodMode;
    }

    public void setPayAmt(String payAmt) {
        this.payAmt = payAmt;
    }

    public PaymentExpend getExpend() {
        return this.expend;
    }

    public void setExpend(PaymentExpend expend) {
        this.expend = expend;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public void setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getPayId() {
        return this.payId;
    }

    public void setPayId(String payId) {
        this.payId = payId;
    }

    @Override
    public String toString() {
        return "Payment{id='" + this.id + '\'' + ", createdTime='" + this.createdTime + '\'' + ", orderNo='" + this.orderNo + '\'' + ", prodMode=" + this.prodMode + ", appId='" + this.appId + '\'' + ", payChannel='" + this.payChannel + '\'' + ", payAmt='" + this.payAmt + '\'' + ", queryUrl='" + this.queryUrl + '\'' + ", reason='" + this.reason + '\'' + ", expend=" + this.expend + ", payId='" + this.payId + '\'' + '}';
    }
}

