/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.cms.Time;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.x509.certificate.CRLTag;

final class CRLCertTag {
    final ASN1Integer version;
    final AlgorithmIdentifier signature;
    final X500Name issuer;
    final Time thisUpdate;
    final Time nextUpdate;
    final CRLTag certsTag;

    public CRLCertTag(ASN1Integer version, AlgorithmIdentifier signature, X500Name issuer, Time thisUpdate, Time nextUpdate, CRLTag certsTag) {
        this.version = version;
        this.signature = signature;
        this.issuer = issuer;
        this.thisUpdate = thisUpdate;
        this.nextUpdate = nextUpdate;
        this.certsTag = certsTag;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("\n\t\t version=");
        builder.append(this.version);
        builder.append("\n\t\t signature=");
        if (this.signature != null) {
            builder.append("\n\t\t oid=");
            builder.append(this.signature.getAlgorithm());
            builder.append("(");
            builder.append(Mechanism.getSignatureAlgName(this.signature));
            builder.append(")");
        }
        builder.append("\n\t\t issuer=");
        builder.append(this.issuer);
        builder.append("\n\t\t thisUpdate=");
        if (this.thisUpdate != null) {
            builder.append(this.thisUpdate.getTime());
        }
        builder.append("\n\t\t nextUpdate=");
        if (this.nextUpdate != null) {
            builder.append(this.nextUpdate.getTime());
        }
        builder.append("\n\t\t certsTag=");
        if (this.certsTag != null) {
            builder.append(this.certsTag);
        }
        return builder.toString();
    }
}

