/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.notify.mqtt;

import com.alibaba.fastjson.JSON;
import com.huifu.adapay.AdaPay;
import com.huifu.adapay.model.payment.Payment;
import com.huifu.adapay.model.refund.Refund;
import com.huifu.adapay.model.token.Token;
import com.huifu.adapay.notify.INotifyCallback;
import com.huifu.adapay.notify.NotifyTypeEnum;
import com.huifu.adapay.notify.mqtt.ConnectionOptionWrapper;
import com.huifu.adapay.notify.mqtt.MqttCallBackResponse;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttCallbackEvent
implements MqttCallbackExtended {
    private MqttClient mqttClient;
    private INotifyCallback asyCallback;

    public void startNotifyListener() throws Exception {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>(1);
        tokenParams.put("expire_time", 61000);
        String token = Token.apply(tokenParams).getToken();
        HashMap<String, String> tokenData = new HashMap<String, String>(1);
        tokenData.put("R", token);
        ConnectionOptionWrapper connectionOptionWrapper = new ConnectionOptionWrapper(tokenData);
        MemoryPersistence memoryPersistence = new MemoryPersistence();
        this.mqttClient = new MqttClient(AdaPay.getMqttEndPoint(), AdaPay.getMqttClientId(), (MqttClientPersistence)memoryPersistence);
        this.mqttClient.setCallback((MqttCallback)this);
        this.mqttClient.setTimeToWait(5000L);
        this.mqttClient.connect(connectionOptionWrapper.getMqttConnectOptions());
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        if (AdaPay.debug) {
            System.out.println("connect success, reconnect=" + reconnect + ", serverURI=" + serverURI);
        }
        new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new SimpleThreadFactory()).submit(() -> {
            try {
                String[] topicFilter = new String[]{AdaPay.getMqttTopic()};
                int[] qos = new int[]{1};
                this.mqttClient.subscribe(topicFilter, qos);
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        });
    }

    public void connectionLost(Throwable throwable) {
        if (AdaPay.debug) {
            System.out.println("connection lost");
        }
    }

    public void messageArrived(String topicName, MqttMessage messageBody) throws Exception {
        String message = new String(messageBody.getPayload());
        System.out.println("MQTT received message :" + message);
        MqttCallBackResponse response = null;
        try {
            response = (MqttCallBackResponse)JSON.parseObject((String)message, MqttCallBackResponse.class);
        }
        catch (Exception e) {
            System.out.println("unknown msg " + message);
            this.asyCallback.unknownMessageArrived(message);
            return;
        }
        NotifyTypeEnum notifyTypeEnum = NotifyTypeEnum.findByCode(response.getType());
        if (null == notifyTypeEnum) {
            if (AdaPay.debug) {
                System.out.println("undefind type " + response.getType());
            }
            return;
        }
        switch (notifyTypeEnum) {
            case PAYMENT_SUCCEEDED: {
                Payment payment = (Payment)JSON.parseObject((String)response.getData(), Payment.class);
                this.asyCallback.paymentSuccessMessageArrived(payment);
                break;
            }
            case PAYMENT_FAILED: {
                Payment payment = (Payment)JSON.parseObject((String)response.getData(), Payment.class);
                this.asyCallback.paymentFailedMessageArrived(payment);
                break;
            }
            case PAYMENT_CLOSE_SUCCEEDED: {
                Payment payment = (Payment)JSON.parseObject((String)response.getData(), Payment.class);
                this.asyCallback.paymentCloseSuccessMessageArrived(payment);
                break;
            }
            case PAYMENT_CLOSE_FAILED: {
                Payment payment = (Payment)JSON.parseObject((String)response.getData(), Payment.class);
                this.asyCallback.paymentCloseFailedMessageArrived(payment);
                break;
            }
            case REFUND_SUCCEEDED: {
                Refund refund = (Refund)JSON.parseObject((String)response.getData(), Refund.class);
                this.asyCallback.refundSuccessMessageArrived(refund);
                break;
            }
            case REFUND_FAILED: {
                Refund refund = (Refund)JSON.parseObject((String)response.getData(), Refund.class);
                this.asyCallback.refundFailedMessageArrived(refund);
                break;
            }
            default: {
                System.out.println("unknown msg " + message);
                this.asyCallback.unknownMessageArrived(message);
            }
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        if (AdaPay.debug) {
            System.out.println("delivery complete");
        }
    }

    public void setIAsyCallback(INotifyCallback asyCallback) {
        this.asyCallback = asyCallback;
    }

    class SimpleThreadFactory
    implements ThreadFactory {
        SimpleThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "AdaPay-Callback-Listener");
        }
    }
}

