/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.jni;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.BigFileCipherUtil;
import cfca.sadk.algorithm.util.HashEncoderUtil;
import cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import cfca.sadk.algorithm.util.SM2AndItsCloseSymAlgUtil;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNIDigest;
import cfca.sadk.lib.crypto.jni.JNISM2;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sadk.system.CompatibleAlgorithm;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.global.SM2ContextConfig;
import cfca.sadk.util.HashUtil;
import cfca.sadk.util.KeyUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;

public class JNISoftLib
implements Session {
    public KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        try {
            if (Mechanisms.isSM2Type(mechanism)) {
                byte[] dBytes = new byte[32];
                byte[] xBytes = new byte[32];
                byte[] yBytes = new byte[32];
                try {
                    JNISM2.generateKeypair(dBytes, xBytes, yBytes);
                }
                catch (PKIException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PKIException("Generate KeyPair failure", e);
                }
                ECDomainParameters spec = SM2Params.sm2DomainParameters;
                ECPoint pubPoint = spec.getCurve().createPoint(new BigInteger(1, xBytes), new BigInteger(1, yBytes));
                ECPublicKeyParameters pubParams = new ECPublicKeyParameters(pubPoint, spec);
                SM2PublicKey pubKey = new SM2PublicKey(pubParams);
                SM2PrivateKey priKey = new SM2PrivateKey(new ECPrivateKeyParameters(new BigInteger(1, dBytes), spec), pubParams);
                return new KeyPair(pubKey, priKey);
            }
            if (Mechanisms.isRSAType(mechanism)) {
                KeyPairGenerator keyPairGen = null;
                try {
                    keyPairGen = KeyPairGenerator.getInstance("RSA");
                }
                catch (Exception e) {
                    return null;
                }
                if (keyLength != 1024 && keyLength != 2048 && keyLength != 4096) {
                    keyLength = 1024;
                }
                keyPairGen.initialize(keyLength);
                KeyPair keyPair = keyPairGen.generateKeyPair();
                return keyPair;
            }
            throw new PKIException(PKIException.JNI_KEY_PAIR, PKIException.JNI_KEY_PAIR_DES + " " + PKIException.NOT_SUP_DES + mechanism.getMechanismType());
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Generate KeyPair failure", e);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        if (sourceData == null) {
            throw new PKIException("the source data is null!");
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = this.SM2PrivateKeyFrom(priKey);
                byte[] hash = new byte[32];
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    this.SM2HashMessage(sm2PubKey, true, sourceData, hash);
                } else {
                    this.SM2HashMessage(sm2PubKey, false, sourceData, hash);
                }
                return SM2PackageUtil.encryptByJNI(hash, sm2priKey.dBigInteger());
            }
            byte[] out = HashUtil.RSAHashMessageByJNI(sourceData, mechanism, true);
            return RSAPackageUtil.encryptByJNI(out, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = this.SM2PrivateKeyFrom(priKey);
                byte[] hash = new byte[32];
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    this.SM2HashFile(sm2PubKey, true, sourceStream, hash);
                } else {
                    this.SM2HashFile(sm2PubKey, false, sourceStream, hash);
                }
                return SM2PackageUtil.encryptByJNI(hash, sm2priKey.dBigInteger());
            }
            byte[] digestData = HashUtil.RSAHashFileByJNI(sourceStream, mechanism, true);
            return RSAPackageUtil.encryptByJNI(digestData, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(pubKey);
                byte[] pubX = sm2PubKey.xBytes();
                byte[] pubY = sm2PubKey.yBytes();
                byte[] hash = new byte[32];
                this.SM2HashMessage(sm2PubKey, true, sourceData, hash);
                boolean verifyResult = SM2PackageUtil.verifyByJNI(hash, signData, pubX, pubY);
                boolean supportedWithoutZ = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                if (supportedWithoutZ && !verifyResult) {
                    this.SM2HashMessage(sm2PubKey, false, sourceData, hash);
                    verifyResult = SM2PackageUtil.verifyByJNI(hash, signData, pubX, pubY);
                }
                return verifyResult;
            }
            byte[] hashData = HashUtil.RSAHashMessageByJNI(sourceData, mechanism, true);
            byte[] sig = RSAPackageUtil.decryptByJNI(signData, pubKey);
            return RSAPackageUtil.isRSAHashEqual(sig, hashData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(pubKey);
                byte[] pubX = sm2PubKey.xBytes();
                byte[] pubY = sm2PubKey.yBytes();
                boolean compatible = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                byte[] hashWithZ = new byte[32];
                byte[] hashWithoutZ = new byte[32];
                this.SM2HashFile(sm2PubKey, compatible, sourceStream, hashWithZ, hashWithoutZ);
                boolean verifyResult = SM2PackageUtil.verifyByJNI(hashWithZ, signData, pubX, pubY);
                if (compatible && !verifyResult) {
                    verifyResult = SM2PackageUtil.verifyByJNI(hashWithoutZ, signData, pubX, pubY);
                }
                return verifyResult;
            }
            byte[] hashData = HashUtil.RSAHashFileByJNI(sourceStream, mechanism, true);
            byte[] sig = RSAPackageUtil.decryptByJNI(signData, pubKey);
            return RSAPackageUtil.isRSAHashEqual(sig, hashData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(key);
                return SM2AndItsCloseSymAlgUtil.sm2EncryptByJNI(true, sm2PubKey, sourceData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncryptByJNI(true, key, sourceData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(true, true, key.getEncoded(), sourceData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(true, true, key.getEncoded(), sourceData, mechanism);
            }
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES, e);
        }
    }

    public byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                SM2PrivateKey sm2priKey = this.SM2PrivateKeyFrom(key);
                return SM2AndItsCloseSymAlgUtil.sm2EncryptByJNI(false, sm2priKey, encryptData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncryptByJNI(false, key, encryptData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(true, false, key.getEncoded(), encryptData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(true, false, key.getEncoded(), encryptData, mechanism);
            }
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES, e);
        }
    }

    public byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] digest) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        if (digest == null) {
            throw new PKIException("the hash data is null!");
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PrivateKey sm2priKey = this.SM2PrivateKeyFrom(priKey);
                return SM2PackageUtil.encryptByJNI(digest, sm2priKey.dBigInteger());
            }
            byte[] derDigest = HashEncoderUtil.derEncoder(mechanism, digest);
            return RSAPackageUtil.encryptByJNI(derDigest, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] hash, byte[] signData) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(pubKey);
                return SM2PackageUtil.verifyByJNI(hash, signData, sm2PubKey.xBytes(), sm2PubKey.yBytes());
            }
            byte[] sig = RSAPackageUtil.decryptByJNI(signData, pubKey);
            byte[] derDigest = HashEncoderUtil.derEncoder(mechanism, hash);
            return RSAPackageUtil.isRSAHashEqual(sig, derDigest);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public void encrypt(Mechanism encryptAlg, Key key, InputStream sourceStream, OutputStream encryptStream) throws PKIException {
        try {
            BigFileCipherUtil.bigFileBlockCipher(true, encryptAlg, key.getEncoded(), sourceStream, encryptStream);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt failure", e);
        }
    }

    public void decrypt(Mechanism encryptAlg, Key key, InputStream encryptStream, OutputStream plainTextStream) throws PKIException {
        try {
            BigFileCipherUtil.bigFileBlockCipher(false, encryptAlg, key.getEncoded(), encryptStream, plainTextStream);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Decrypt failure", e);
        }
    }

    public Key generateKey(Mechanism keyType) throws PKIException {
        String type = keyType.getMechanismType();
        SecureRandom random = new SecureRandom();
        if (type.equals("DESede")) {
            byte[] keyData = new byte[24];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("SM4")) {
            byte[] keyData = new byte[16];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("RC4")) {
            byte[] keyData = new byte[16];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        throw new PKIException("do not support this key type:" + type);
    }

    private final void SM2HashFile(SM2PublicKey sm2PubKey, boolean supportedWithoutZ, InputStream stream, byte[] hashWithZ, byte[] hashWithoutZ) throws Exception {
        byte[] buffer = new byte[65536];
        JNIDigest engineWithZ = new JNIDigest();
        engineWithZ.init(922);
        engineWithZ.update(sm2PubKey.getDefaultZ());
        JNIDigest engineWithoutZ = null;
        if (supportedWithoutZ) {
            engineWithoutZ = new JNIDigest();
            engineWithoutZ.init(922);
        }
        int rLength = 0;
        byte[] data = null;
        while ((rLength = stream.read(buffer, 0, buffer.length)) != -1) {
            if (rLength < buffer.length) {
                data = new byte[rLength];
                System.arraycopy(buffer, 0, data, 0, data.length);
            } else {
                data = buffer;
            }
            engineWithZ.update(data);
            if (!supportedWithoutZ) continue;
            engineWithoutZ.update(data);
        }
        engineWithZ.doFinal(hashWithZ);
        if (supportedWithoutZ) {
            engineWithoutZ.doFinal(hashWithoutZ);
        }
    }

    private final void SM2HashFile(SM2PublicKey sm2PubKey, boolean withZ, InputStream stream, byte[] hash) throws Exception {
        byte[] buffer = new byte[65536];
        JNIDigest engine = new JNIDigest();
        engine.init(922);
        if (withZ) {
            engine.update(sm2PubKey.getDefaultZ());
        }
        int rLength = 0;
        byte[] data = null;
        while ((rLength = stream.read(buffer, 0, buffer.length)) != -1) {
            if (rLength < buffer.length) {
                data = new byte[rLength];
                System.arraycopy(buffer, 0, data, 0, data.length);
            } else {
                data = buffer;
            }
            engine.update(data);
        }
        engine.doFinal(hash);
    }

    private final void SM2HashMessage(SM2PublicKey sm2PubKey, boolean withZ, byte[] message, byte[] hash) throws Exception {
        JNIDigest engine = new JNIDigest();
        engine.init(922);
        if (withZ) {
            engine.update(sm2PubKey.getDefaultZ());
        }
        engine.update(message);
        engine.doFinal(hash);
    }

    private final SM2PublicKey SM2PublicKeyFrom(Key key) {
        SM2PublicKey sm2PubKey = null;
        sm2PubKey = key instanceof SM2PublicKey ? (SM2PublicKey)key : new SM2PublicKey(key.getEncoded());
        return sm2PubKey;
    }

    private final SM2PrivateKey SM2PrivateKeyFrom(Key key) {
        SM2PrivateKey sm2Key = null;
        sm2Key = key instanceof SM2PrivateKey ? (SM2PrivateKey)key : new SM2PrivateKey(key.getEncoded());
        return sm2Key;
    }

    public Key generateKey(Mechanism keyType, byte[] keyData) throws PKIException {
        return KeyUtil.generateKey(keyType, keyData);
    }

    public Provider getProvider() {
        return null;
    }

    public String getProviderName() {
        return null;
    }
}

