/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.parsers;

import com.timevale.tgtext.bouncycastle.crypto.KeyParser;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.DHParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class DHIESPublicKeyParser
implements KeyParser {
    private DHParameters dhParams;

    public DHIESPublicKeyParser(DHParameters dhParams) {
        this.dhParams = dhParams;
    }

    @Override
    public AsymmetricKeyParameter readKey(InputStream stream) throws IOException {
        byte[] V = new byte[(this.dhParams.getP().bitLength() + 7) / 8];
        stream.read(V, 0, V.length);
        return new DHPublicKeyParameters(new BigInteger(1, V), this.dhParams);
    }
}

