/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.KeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.DenseTernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Polynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.ProductFormPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.util.Util;

public class NTRUEncryptionKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUEncryptionKeyGenerationParameters params;

    @Override
    public void init(KeyGenerationParameters param) {
        this.params = (NTRUEncryptionKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DenseTernaryPolynomial g2;
        IntegerPolynomial fq2;
        Polynomial t2;
        int N = this.params.N;
        int q2 = this.params.q;
        int df2 = this.params.df;
        int df1 = this.params.df1;
        int df22 = this.params.df2;
        int df3 = this.params.df3;
        int dg2 = this.params.dg;
        boolean fastFp = this.params.fastFp;
        boolean sparse = this.params.sparse;
        IntegerPolynomial fp2 = null;
        while (true) {
            IntegerPolynomial f2;
            if (fastFp) {
                t2 = this.params.polyType == 0 ? Util.generateRandomTernary(N, df2, df2, sparse, this.params.getRandom()) : ProductFormPolynomial.generateRandom(N, df1, df22, df3, df3, this.params.getRandom());
                f2 = t2.toIntegerPolynomial();
                f2.mult(3);
                f2.coeffs[0] = f2.coeffs[0] + 1;
            } else {
                t2 = this.params.polyType == 0 ? Util.generateRandomTernary(N, df2, df2 - 1, sparse, this.params.getRandom()) : ProductFormPolynomial.generateRandom(N, df1, df22, df3, df3 - 1, this.params.getRandom());
                f2 = t2.toIntegerPolynomial();
                fp2 = f2.invertF3();
                if (fp2 == null) continue;
            }
            if ((fq2 = f2.invertFq(q2)) != null) break;
        }
        if (fastFp) {
            fp2 = new IntegerPolynomial(N);
            fp2.coeffs[0] = 1;
        }
        while ((g2 = DenseTernaryPolynomial.generateRandom(N, dg2, dg2 - 1, this.params.getRandom())).invertFq(q2) == null) {
        }
        IntegerPolynomial h2 = g2.mult(fq2, q2);
        h2.mult3(q2);
        h2.ensurePositive(q2);
        g2.clear();
        fq2.clear();
        NTRUEncryptionPrivateKeyParameters priv = new NTRUEncryptionPrivateKeyParameters(h2, t2, fp2, this.params.getEncryptionParameters());
        NTRUEncryptionPublicKeyParameters pub = new NTRUEncryptionPublicKeyParameters(h2, this.params.getEncryptionParameters());
        return new AsymmetricCipherKeyPair(pub, priv);
    }
}

