/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public final class CompatibleConfig {
    public static final int SM2OutputFormatEncryptedBytes;
    public static final int SM2OutputFormatSignedBytes;
    public static final int SM2DecryptedFormatEncryptedBytes;
    public static final int SM2VerifiedFormatSignedBytes;
    public static final boolean SM2VerifiedWithoutZCompatible;
    public static final int P10RequestFormatSignedBytes;
    public static final boolean P10RequestVerifiedSignedFlag;
    public static final int FILEANDBUFFER_BIG_FILE_BUFFER;
    public static final int FILEANDBUFFER_SOURCE_FILE_MAXSIZE;
    public static final int FILEANDBUFFER_SIGNED_FILE_MAXSIZE;
    public static final int FILEANDBUFFER_ENVELOPE_FILE_MAXSIZE;
    public static final int FILEANDBUFFER_BIGGEST_FILE_MAXSIZE;

    public static void main(String[] args) {
        System.err.println(SM2OutputFormatEncryptedBytes);
        System.err.println(SM2OutputFormatSignedBytes);
        System.err.println(SM2DecryptedFormatEncryptedBytes);
        System.err.println(SM2VerifiedFormatSignedBytes);
        System.err.println(P10RequestVerifiedSignedFlag);
        System.err.println(FILEANDBUFFER_BIG_FILE_BUFFER);
        System.err.println(FILEANDBUFFER_SOURCE_FILE_MAXSIZE);
        System.err.println(FILEANDBUFFER_SIGNED_FILE_MAXSIZE);
        System.err.println(FILEANDBUFFER_ENVELOPE_FILE_MAXSIZE);
        System.err.println(FILEANDBUFFER_BIGGEST_FILE_MAXSIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadFromFile() {
        File file = new File("config/compatible.cfg");
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = file.isFile() && file.exists() ? new FileInputStream(file) : CompatibleConfig.class.getResourceAsStream("compatible.cfg");
        }
        catch (Exception e) {
            e.printStackTrace();
            in = null;
        }
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return properties;
    }

    private static final int integerFrom(Properties properties, String key, int defValue) {
        int value = defValue;
        try {
            value = Integer.decode(properties.getProperty(key, Integer.toString(defValue)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    private static final boolean booleanFrom(Properties properties, String key, String defValue) {
        return "true".equalsIgnoreCase(properties.getProperty(key, defValue));
    }

    static {
        Properties properties = CompatibleConfig.loadFromFile();
        System.out.println(properties);
        SM2OutputFormatEncryptedBytes = CompatibleConfig.integerFrom(properties, "SM2OutputFormatEncryptedBytes", 1);
        SM2OutputFormatSignedBytes = CompatibleConfig.integerFrom(properties, "SM2OutputFormatSignedBytes", 1);
        SM2DecryptedFormatEncryptedBytes = CompatibleConfig.integerFrom(properties, "SM2DecryptedFormatEncryptedBytes", 21);
        SM2VerifiedWithoutZCompatible = CompatibleConfig.booleanFrom(properties, "SM2VerifiedWithoutZCompatible", "false");
        SM2VerifiedFormatSignedBytes = CompatibleConfig.integerFrom(properties, "SM2VerifiedFormatSignedBytes", 17);
        P10RequestFormatSignedBytes = CompatibleConfig.integerFrom(properties, "P10RequestFormatSignedBytes", 1);
        P10RequestVerifiedSignedFlag = CompatibleConfig.booleanFrom(properties, "P10RequestVerifiedSignedFlag", "true");
        FILEANDBUFFER_BIG_FILE_BUFFER = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.BIG_FILE_BUFFER", 5);
        FILEANDBUFFER_SOURCE_FILE_MAXSIZE = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.SOURCE_FILE_MAXSIZE", 50);
        FILEANDBUFFER_SIGNED_FILE_MAXSIZE = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.SIGNED_FILE_MAXSIZE", 51);
        FILEANDBUFFER_ENVELOPE_FILE_MAXSIZE = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.ENVELOPE_FILE_MAXSIZE", 51);
        FILEANDBUFFER_BIGGEST_FILE_MAXSIZE = 0x100000 * CompatibleConfig.integerFrom(properties, "FILEANDBUFFER.BIGGEST_FILE_MAXSIZE", 55);
    }
}

