/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.pkcs;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPrivateKeyStructure
extends ASN1Object {
    private int version;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger prime1;
    private BigInteger prime2;
    private BigInteger exponent1;
    private BigInteger exponent2;
    private BigInteger coefficient;
    private ASN1Sequence otherPrimeInfos = null;

    public static RSAPrivateKeyStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return RSAPrivateKeyStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static RSAPrivateKeyStructure getInstance(Object obj) {
        if (obj instanceof RSAPrivateKeyStructure) {
            return (RSAPrivateKeyStructure)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new RSAPrivateKeyStructure((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public RSAPrivateKeyStructure(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger prime1, BigInteger prime2, BigInteger exponent1, BigInteger exponent2, BigInteger coefficient) {
        this.version = 0;
        this.modulus = modulus;
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
        this.prime1 = prime1;
        this.prime2 = prime2;
        this.exponent1 = exponent1;
        this.exponent2 = exponent2;
        this.coefficient = coefficient;
    }

    public RSAPrivateKeyStructure(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        BigInteger v2 = ((ASN1Integer)e2.nextElement()).getValue();
        if (v2.intValue() != 0 && v2.intValue() != 1) {
            throw new IllegalArgumentException("wrong version for RSA private key");
        }
        this.version = v2.intValue();
        this.modulus = ((ASN1Integer)e2.nextElement()).getValue();
        this.publicExponent = ((ASN1Integer)e2.nextElement()).getValue();
        this.privateExponent = ((ASN1Integer)e2.nextElement()).getValue();
        this.prime1 = ((ASN1Integer)e2.nextElement()).getValue();
        this.prime2 = ((ASN1Integer)e2.nextElement()).getValue();
        this.exponent1 = ((ASN1Integer)e2.nextElement()).getValue();
        this.exponent2 = ((ASN1Integer)e2.nextElement()).getValue();
        this.coefficient = ((ASN1Integer)e2.nextElement()).getValue();
        if (e2.hasMoreElements()) {
            this.otherPrimeInfos = (ASN1Sequence)e2.nextElement();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPrime1() {
        return this.prime1;
    }

    public BigInteger getPrime2() {
        return this.prime2;
    }

    public BigInteger getExponent1() {
        return this.exponent1;
    }

    public BigInteger getExponent2() {
        return this.exponent2;
    }

    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(new ASN1Integer(this.version));
        v2.add(new ASN1Integer(this.getModulus()));
        v2.add(new ASN1Integer(this.getPublicExponent()));
        v2.add(new ASN1Integer(this.getPrivateExponent()));
        v2.add(new ASN1Integer(this.getPrime1()));
        v2.add(new ASN1Integer(this.getPrime2()));
        v2.add(new ASN1Integer(this.getExponent1()));
        v2.add(new ASN1Integer(this.getExponent2()));
        v2.add(new ASN1Integer(this.getCoefficient()));
        if (this.otherPrimeInfos != null) {
            v2.add(this.otherPrimeInfos);
        }
        return new DERSequence(v2);
    }
}

