/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.ResponderID;
import com.timevale.tgtext.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import java.io.OutputStream;

public class RespID {
    public static final AlgorithmIdentifier HASH_SHA1 = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE);
    ResponderID id;

    public RespID(ResponderID id) {
        this.id = id;
    }

    public RespID(X500Name name) {
        this.id = new ResponderID(name);
    }

    public RespID(SubjectPublicKeyInfo subjectPublicKeyInfo, DigestCalculator digCalc) throws OCSPException {
        try {
            if (!digCalc.getAlgorithmIdentifier().equals(HASH_SHA1)) {
                throw new IllegalArgumentException("only SHA-1 can be used with RespID");
            }
            OutputStream digOut = digCalc.getOutputStream();
            digOut.write(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            digOut.close();
            this.id = new ResponderID(new DEROctetString(digCalc.getDigest()));
            return;
        }
        catch (Exception e2) {
            throw new OCSPException("problem creating ID: " + e2, e2);
        }
    }

    public ResponderID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof RespID)) {
            return false;
        }
        RespID obj = (RespID)o2;
        return this.id.equals(obj.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

