/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.BEROctetStringGenerator;
import com.timevale.tgtext.bouncycastle.asn1.BERSet;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.CertificateList;
import com.timevale.tgtext.bouncycastle.asn1.x509.TBSCertificate;
import com.timevale.tgtext.bouncycastle.cert.X509AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CRLHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.SignerInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.j;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.util.Store;
import com.timevale.tgtext.bouncycastle.util.io.Streams;
import com.timevale.tgtext.bouncycastle.util.io.TeeInputStream;
import com.timevale.tgtext.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class i {
    i() {
    }

    static ContentInfo a(byte[] input) throws CMSException {
        return i.a(new ASN1InputStream(input));
    }

    static ContentInfo a(InputStream input) throws CMSException {
        return i.a(new ASN1InputStream(input));
    }

    static List a(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        try {
            for (X509Certificate x509Certificate : certStore.getCertificates(null)) {
                certs.add(Certificate.getInstance(ASN1Primitive.fromByteArray(x509Certificate.getEncoded())));
            }
            return certs;
        }
        catch (IllegalArgumentException e2) {
            throw new CMSException("error processing certs", e2);
        }
        catch (IOException e3) {
            throw new CMSException("error processing certs", e3);
        }
        catch (CertificateEncodingException e4) {
            throw new CMSException("error encoding certs", e4);
        }
    }

    static List a(Store certStore) throws CMSException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        try {
            for (X509CertificateHolder c2 : certStore.getMatches(null)) {
                certs.add(c2.toASN1Structure());
            }
            return certs;
        }
        catch (ClassCastException e2) {
            throw new CMSException("error processing certs", e2);
        }
    }

    static List b(Store attrStore) throws CMSException {
        ArrayList<DERTaggedObject> certs = new ArrayList<DERTaggedObject>();
        try {
            for (X509AttributeCertificateHolder attrCert : attrStore.getMatches(null)) {
                certs.add(new DERTaggedObject(false, 2, attrCert.toASN1Structure()));
            }
            return certs;
        }
        catch (ClassCastException e2) {
            throw new CMSException("error processing certs", e2);
        }
    }

    static List b(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<CertificateList> crls = new ArrayList<CertificateList>();
        try {
            for (X509CRL x509CRL : certStore.getCRLs(null)) {
                crls.add(CertificateList.getInstance(ASN1Primitive.fromByteArray(x509CRL.getEncoded())));
            }
            return crls;
        }
        catch (IllegalArgumentException e2) {
            throw new CMSException("error processing crls", e2);
        }
        catch (IOException e3) {
            throw new CMSException("error processing crls", e3);
        }
        catch (CRLException e4) {
            throw new CMSException("error encoding crls", e4);
        }
    }

    static List c(Store crlStore) throws CMSException {
        ArrayList<CertificateList> certs = new ArrayList<CertificateList>();
        try {
            for (X509CRLHolder c2 : crlStore.getMatches(null)) {
                certs.add(c2.toASN1Structure());
            }
            return certs;
        }
        catch (ClassCastException e2) {
            throw new CMSException("error processing certs", e2);
        }
    }

    static ASN1Set a(List derObjects) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v2.add((ASN1Encodable)it.next());
        }
        return new BERSet(v2);
    }

    static ASN1Set b(List derObjects) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v2.add((ASN1Encodable)it.next());
        }
        return new DERSet(v2);
    }

    static OutputStream a(OutputStream s2, int tagNo, boolean isExplicit, int bufferSize) throws IOException {
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(s2, tagNo, isExplicit);
        if (bufferSize != 0) {
            return octGen.getOctetOutputStream(new byte[bufferSize]);
        }
        return octGen.getOctetOutputStream();
    }

    static TBSCertificate a(X509Certificate cert) {
        try {
            return TBSCertificate.getInstance(ASN1Primitive.fromByteArray(cert.getTBSCertificate()));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't extract TBS structure from this cert");
        }
    }

    static IssuerAndSerialNumber b(X509Certificate cert) {
        TBSCertificate tbsCert = i.a(cert);
        return new IssuerAndSerialNumber(tbsCert.getIssuer(), tbsCert.getSerialNumber().getValue());
    }

    private static ContentInfo a(ASN1InputStream in) throws CMSException {
        try {
            return ContentInfo.getInstance(in.readObject());
        }
        catch (IOException e2) {
            throw new CMSException("IOException reading content.", e2);
        }
        catch (ClassCastException e3) {
            throw new CMSException("Malformed content.", e3);
        }
        catch (IllegalArgumentException e4) {
            throw new CMSException("Malformed content.", e4);
        }
    }

    public static byte[] b(InputStream in) throws IOException {
        return Streams.readAll(in);
    }

    public static byte[] a(InputStream in, int limit) throws IOException {
        return Streams.readAllLimited(in, limit);
    }

    public static Provider a(String providerName) throws NoSuchProviderException {
        if (providerName != null) {
            Provider prov = Security.getProvider(providerName);
            if (prov != null) {
                return prov;
            }
            throw new NoSuchProviderException("provider " + providerName + " not found.");
        }
        return null;
    }

    static InputStream a(Collection digests, InputStream s2) {
        InputStream result = s2;
        for (DigestCalculator digest : digests) {
            result = new TeeInputStream(result, digest.getOutputStream());
        }
        return result;
    }

    static OutputStream a(Collection signers, OutputStream s2) {
        OutputStream result = s2;
        for (SignerInfoGenerator signerGen : signers) {
            result = i.a(result, signerGen.getCalculatingOutputStream());
        }
        return result;
    }

    static OutputStream a(OutputStream s2) {
        if (s2 == null) {
            return new j();
        }
        return s2;
    }

    static OutputStream a(OutputStream s1, OutputStream s2) {
        if (s1 == null) {
            return i.a(s2);
        }
        if (s2 == null) {
            return i.a(s1);
        }
        return new TeeOutputStream(s1, s2);
    }
}

