/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.jcajce.signature;

import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.sm2.SM2HashZValue;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM2Result;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.lib.crypto.bcsoft.BCSoftSM2;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class SM2SignatureImpl
extends SignatureSpi {
    protected ASN1ObjectIdentifier OID;
    protected MessageDigest md;
    protected boolean mdReset;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected byte[] digestData;

    public SM2SignatureImpl(String digestAlgorithm, ASN1ObjectIdentifier OID) {
        this.OID = OID;
        try {
            this.md = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException localNoSuchAlgorithmException) {
            throw new ProviderException(localNoSuchAlgorithmException.getMessage());
        }
        this.mdReset = true;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = privateKey;
    }

    protected void engineUpdate(byte b) throws SignatureException {
    }

    protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] sign = new byte[64];
        if (this.digestData == null || this.digestData.length != 32) {
            throw new InvalidParameterException("the digest data is null or not 32 bytes!");
        }
        SM2PrivateKey key = null;
        if (!(this.privateKey instanceof SM2PrivateKey)) {
            throw new InvalidParameterException("The private key type is not sm2 type!");
        }
        key = (SM2PrivateKey)this.privateKey;
        BCSoftSM2 bcSoftSM2 = new BCSoftSM2();
        SM2Result sm2Ret = new SM2Result();
        bcSoftSM2.sign(this.digestData, key.getDByInt(), sm2Ret);
        System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(sm2Ret.r), 0, sign, 0, 32);
        System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(sm2Ret.s), 0, sign, 32, 32);
        return sign;
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        SM2PublicKey key = null;
        if (!(this.publicKey instanceof SM2PublicKey)) {
            throw new InvalidParameterException("the key type is not SM2 public key");
        }
        key = (SM2PublicKey)this.publicKey;
        if (this.digestData == null || this.digestData.length != 32) {
            throw new InvalidParameterException("the digest data is null or not 32 bytes!");
        }
        if (sigBytes == null || sigBytes.length != 64) {
            throw new InvalidParameterException("the signature data is null or not 64 bytes!");
        }
        System.arraycopy(sigBytes, 0, r, 0, 32);
        System.arraycopy(sigBytes, 32, s, 0, 32);
        BCSoftSM2 sm2 = new BCSoftSM2();
        SM2Result sm2Ret = new SM2Result();
        sm2Ret.r = new BigInteger(1, r);
        sm2Ret.s = new BigInteger(1, s);
        return sm2.verify(this.digestData, key.getQ(), sm2Ret);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super.engineSetParameter(params);
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    public static class SM3withOCTET_SM2
    extends SM3withRAW_SM2 {
    }

    public static class SM3withRAW_SM2
    extends SM2SignatureImpl {
        public SM3withRAW_SM2() {
            super("SM3", PKCSObjectIdentifiers.sm3);
        }

        protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
            this.md.update(input, off, len);
            this.digestData = this.md.digest();
        }
    }

    public static class SM3withOCTET_Z_SM2
    extends SM3withRAW_Z_SM2 {
        protected byte[] engineSign() throws SignatureException {
            byte[] resultSigBytes = null;
            try {
                byte[] rawSignedBytes = super.engineSign();
                byte[] br = new byte[32];
                byte[] bs = new byte[32];
                System.arraycopy(rawSignedBytes, 0, br, 0, 32);
                System.arraycopy(rawSignedBytes, 32, bs, 0, 32);
                BigInteger ir = new BigInteger(1, br);
                BigInteger is = new BigInteger(1, bs);
                ASN1EncodableVector rsV = new ASN1EncodableVector();
                ASN1Integer asn1R = new ASN1Integer(ir);
                ASN1Integer asn1S = new ASN1Integer(is);
                rsV.add(asn1R);
                rsV.add(asn1S);
                DERSequence rsSequence = new DERSequence(rsV);
                DEROctetString rsStr = new DEROctetString(rsSequence);
                resultSigBytes = rsStr.getOctets();
            }
            catch (IOException e) {
                throw new SignatureException("SM2 Signed Failure" + e.getMessage());
            }
            return resultSigBytes;
        }

        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            DEROctetString rsStr = new DEROctetString(sigBytes);
            DERSequence seq = (DERSequence)DERSequence.getInstance(rsStr.getOctets());
            ASN1Integer R = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer S = (ASN1Integer)seq.getObjectAt(1);
            byte[] r = R.getPositiveValue().toByteArray();
            byte[] s = S.getPositiveValue().toByteArray();
            byte[] signedData = new byte[64];
            System.arraycopy(r, 0, signedData, 0, 32);
            System.arraycopy(s, 0, signedData, 32, 32);
            return super.engineVerify(signedData);
        }
    }

    public static class SM3withRAW_Z_SM2
    extends SM2SignatureImpl {
        public SM3withRAW_Z_SM2() {
            super("SM3", PKCSObjectIdentifiers.sm3);
        }

        protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
            SM2PrivateKey sm2PrivateKey = null;
            if (!(this.privateKey instanceof SM2PrivateKey)) {
                throw new SignatureException("private key must be SM2PrivateKey!");
            }
            sm2PrivateKey = (SM2PrivateKey)this.privateKey;
            SM2PublicKey sm2PublicKey = sm2PrivateKey.getSM2PublicKey();
            BigInteger pubX = sm2PublicKey.getPubXByInt();
            BigInteger pubY = sm2PublicKey.getPubYByInt();
            byte[] z = SM2HashZValue.getZa(pubX, pubY, null);
            this.md.update(z, 0, z.length);
            this.md.update(input, off, len);
            this.digestData = this.md.digest();
        }
    }
}

