/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.g3.sdk.yop.client.AbortMultipartUploadRequest;
import com.yeepay.g3.sdk.yop.client.AbstractClient;
import com.yeepay.g3.sdk.yop.client.CompleteMultipartUploadRequest;
import com.yeepay.g3.sdk.yop.client.InitiateMultipartUploadRequest;
import com.yeepay.g3.sdk.yop.client.ResponseConfig;
import com.yeepay.g3.sdk.yop.client.UploadFileRequest;
import com.yeepay.g3.sdk.yop.client.UploadPartRequest;
import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.YopResponse;
import com.yeepay.g3.sdk.yop.encrypt.AESEncrypter;
import com.yeepay.g3.sdk.yop.encrypt.Base64;
import com.yeepay.g3.sdk.yop.encrypt.CertTypeEnum;
import com.yeepay.g3.sdk.yop.encrypt.DigestAlgEnum;
import com.yeepay.g3.sdk.yop.encrypt.DigitalSignatureDTO;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.http.HttpMethodName;
import com.yeepay.g3.sdk.yop.http.HttpUtils;
import com.yeepay.g3.sdk.yop.model.PartETag;
import com.yeepay.g3.sdk.yop.unmarshaller.JacksonJsonMarshaller;
import com.yeepay.g3.sdk.yop.utils.CheckUtils;
import com.yeepay.g3.sdk.yop.utils.DateUtils;
import com.yeepay.g3.sdk.yop.utils.DigitalEnvelopeUtils;
import com.yeepay.g3.sdk.yop.utils.Exceptions;
import com.yeepay.g3.sdk.yop.utils.FileUtils;
import com.yeepay.g3.sdk.yop.utils.InternalConfig;
import com.yeepay.g3.sdk.yop.utils.JsonUtils;
import com.yeepay.g3.sdk.yop.utils.RSAKeyUtils;
import com.yeepay.g3.sdk.yop.utils.checksum.CRC64Utils;
import com.yeepay.g3.sdk.yop.utils.io.IOUtil;
import com.yeepay.g3.sdk.yop.utils.io.MarkableFileInputStream;
import com.yeepay.shade.com.google.common.base.Joiner;
import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.com.google.common.collect.Multimap;
import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.org.apache.commons.lang3.BooleanUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.shade.org.apache.commons.lang3.tuple.ImmutablePair;
import com.yeepay.shade.org.apache.commons.lang3.tuple.Pair;
import com.yeepay.shade.org.apache.http.client.methods.HttpUriRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.CheckedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopRsaClient
extends AbstractClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger(YopRsaClient.class);
    private static final Set<String> defaultHeadersToSign = Sets.newHashSet();
    private static final Joiner headerJoiner = Joiner.on('\n');
    private static final Joiner signedHeaderStringJoiner = Joiner.on(';');
    private static final String EXPIRED_SECONDS = "1800";

    public static YopResponse get(String apiUri, YopRequest request) throws IOException {
        return YopRsaClient.handleNormalRequest(apiUri, request, HttpMethodName.GET);
    }

    public static YopResponse post(String apiUri, YopRequest request) throws IOException {
        return YopRsaClient.handleNormalRequest(apiUri, request, HttpMethodName.POST);
    }

    private static YopResponse handleNormalRequest(String apiUri, YopRequest request, HttpMethodName method) throws IOException {
        HttpUriRequest httpPost;
        CheckUtils.checkApiUri(apiUri);
        if (BooleanUtils.isTrue(request.isNeedEncrypt())) {
            YopRsaClient.encryptRequest(request);
        }
        YopRsaClient.sign(apiUri, request, method);
        String contentUrl = YopRsaClient.richRequest(apiUri, request);
        if (request.getJsonParam() != null) {
            String jsonString = request.getJsonParam() instanceof String ? (String)request.getJsonParam() : JsonUtils.toJsonString(request.getJsonParam());
            httpPost = YopRsaClient.buildJsonHttpRequest(request, contentUrl, method, jsonString);
        } else {
            httpPost = YopRsaClient.buildFormHttpRequest(request, contentUrl, method);
        }
        YopResponse response = YopRsaClient.fetchContentByApacheHttpClient(httpPost, new ResponseConfig().withNeedEncrypt(request.isNeedEncrypt()).withEncryptKey(request.getEncryptKey()).withYopPublicKey(InternalConfig.getYopPublicKey(CertTypeEnum.RSA2048)));
        YopRsaClient.handleRsaResult(response);
        return response;
    }

    private static void encryptRequest(YopRequest request) {
        String encryptKey = StringUtils.defaultIfBlank(request.getEncryptKey(), request.getAppSdkConfig().getEncryptKey());
        if (StringUtils.isBlank(encryptKey)) {
            throw new YopClientException("no encryptKey configured");
        }
        request.addHeader("x-yop-encrypt-type", YopRsaClient.getEncryptType(encryptKey));
        request.setEncryptKey(encryptKey);
        if (request.getParams() != null) {
            Multimap<String, String> paramMultiMap = request.getParams();
            for (String key : paramMultiMap.keySet()) {
                Collection<String> values = paramMultiMap.get(key);
                ArrayList<String> encryptedValues = new ArrayList<String>(values.size());
                for (String value : values) {
                    encryptedValues.add(AESEncrypter.encrypt(value, encryptKey));
                }
                paramMultiMap.replaceValues(key, encryptedValues);
            }
        }
    }

    private static String getEncryptType(String encryptKey) {
        byte[] decoded = Base64.decode(encryptKey.getBytes());
        if (decoded.length == 16 || decoded.length == 32) {
            return "aes" + decoded.length * 8;
        }
        throw new YopClientException("unsupported encryptKey length");
    }

    public static YopResponse upload(String apiUri, YopRequest request) throws IOException {
        CheckUtils.checkApiUri(apiUri);
        if (BooleanUtils.isTrue(request.isNeedEncrypt())) {
            YopRsaClient.encryptRequest(request);
        }
        YopRsaClient.sign(apiUri, request, HttpMethodName.POST);
        String contentUrl = YopRsaClient.richRequest(apiUri, request);
        Pair<HttpUriRequest, List<CheckedInputStream>> pair = YopRsaClient.buildMultiFormRequest(request, contentUrl);
        YopResponse response = YopRsaClient.fetchContentByApacheHttpClient(pair.getLeft(), new ResponseConfig().withNeedEncrypt(request.isNeedEncrypt()).withEncryptKey(request.getEncryptKey()).withYopPublicKey(InternalConfig.getYopPublicKey(CertTypeEnum.RSA2048)));
        YopRsaClient.handleRsaResult(response);
        if (pair.getRight() != null) {
            YopRsaClient.checkFileIntegrity(response, CRC64Utils.getCRC64(pair.getRight()));
        }
        return response;
    }

    private static void sign(String apiUri, YopRequest request, HttpMethodName httpMethod) {
        PrivateKey isvPrivateKey;
        String appKey = request.getAppSdkConfig().getAppKey();
        String timestamp = DateUtils.formatAlternateIso8601Date(new Date());
        Map<String, String> headers = request.getHeaders();
        headers.put("x-yop-session-id", SESSION_ID);
        headers.put("x-yop-request-id", YopRsaClient.getUUID());
        HashSet<String> headersToSignSet = new HashSet<String>();
        headersToSignSet.add("x-yop-request-id");
        String authString = "yop-auth-v2/" + appKey + "/" + timestamp + "/" + EXPIRED_SECONDS;
        String canonicalURI = HttpUtils.getCanonicalURIPath(apiUri);
        String canonicalQueryString = HttpUtils.getCanonicalQueryString(request.getParams(), true);
        SortedMap<String, String> headersToSign = YopRsaClient.getHeadersToSign(headers, headersToSignSet);
        String canonicalHeader = YopRsaClient.getCanonicalHeaders(headersToSign);
        String signedHeaders = signedHeaderStringJoiner.join(headersToSign.keySet());
        signedHeaders = signedHeaders.trim().toLowerCase();
        String canonicalRequest = String.valueOf(authString) + "\n" + (Object)((Object)httpMethod) + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalHeader;
        if (StringUtils.length(request.getSecretKey()) > 128) {
            try {
                isvPrivateKey = RSAKeyUtils.string2PrivateKey(request.getSecretKey());
            }
            catch (NoSuchAlgorithmException e) {
                throw Exceptions.unchecked(e);
            }
            catch (InvalidKeySpecException e) {
                throw Exceptions.unchecked(e);
            }
        } else {
            isvPrivateKey = request.getAppSdkConfig().getDefaultIsvPrivateKey();
        }
        if (isvPrivateKey == null) {
            throw new YopClientException("Can't init ISV private key!");
        }
        DigitalSignatureDTO digitalSignatureDTO = new DigitalSignatureDTO();
        digitalSignatureDTO.setPlainText(canonicalRequest);
        digitalSignatureDTO.setCertType(CertTypeEnum.RSA2048);
        digitalSignatureDTO.setDigestAlg(DigestAlgEnum.SHA256);
        digitalSignatureDTO = DigitalEnvelopeUtils.sign(digitalSignatureDTO, isvPrivateKey);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("canonicalRequest:" + canonicalRequest);
            LOGGER.debug("signature:" + digitalSignatureDTO.getSignature());
        }
        headers.put("Authorization", "YOP-RSA2048-SHA256 yop-auth-v2/" + appKey + "/" + timestamp + "/" + EXPIRED_SECONDS + "/" + signedHeaders + "/" + digitalSignatureDTO.getSignature());
    }

    private static void handleRsaResult(YopResponse response) {
        String stringResult = response.getStringResult();
        if (StringUtils.isNotBlank(stringResult)) {
            response.setResult(JacksonJsonMarshaller.unmarshal(stringResult, Object.class));
        }
    }

    private static String getCanonicalHeaders(SortedMap<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        ArrayList<String> headerStrings = Lists.newArrayList();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            headerStrings.add(String.valueOf(HttpUtils.normalize(key.trim().toLowerCase())) + ':' + HttpUtils.normalize(value.trim()));
        }
        Collections.sort(headerStrings);
        return headerJoiner.join(headerStrings);
    }

    private static SortedMap<String, String> getHeadersToSign(Map<String, String> headers, Set<String> headersToSign) {
        TreeMap<String, String> ret = Maps.newTreeMap();
        if (headersToSign != null) {
            HashSet<String> tempSet = Sets.newHashSet();
            for (String string : headersToSign) {
                tempSet.add(string.trim().toLowerCase());
            }
            headersToSign = tempSet;
        }
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            if (entry.getValue() == null || ((String)entry.getValue()).isEmpty() || (headersToSign == null || !headersToSign.contains(key.toLowerCase()) || "Authorization".equalsIgnoreCase(key)) && (headersToSign != null || !YopRsaClient.isDefaultHeaderToSign(key))) continue;
            ret.put(key, (String)entry.getValue());
        }
        return ret;
    }

    private static boolean isDefaultHeaderToSign(String header) {
        return (header = header.trim().toLowerCase()).startsWith("x-yop-") || defaultHeadersToSign.contains(header);
    }

    public static YopResponse initMultipartUpload(InitiateMultipartUploadRequest req) throws IOException {
        CheckUtils.notNull(req, "req");
        CheckUtils.notEmpty(req.getApiUri(), "req.apiUri");
        CheckUtils.notEmpty(req.getBizCode(), "req.bizCode");
        YopRequest request = YopRsaClient.getYopRequest(req.getAppKey(), req.getSecretKey(), req.getNeedEncrypt(), req.getEncryptKey());
        if (StringUtils.isNotEmpty(req.getFileName())) {
            request.addParam("fileName", req.getFileName());
        } else {
            request.addNullParam("fileName");
        }
        request.addNullParam("uploads");
        request.addParam("bizCode", req.getBizCode());
        return YopRsaClient.internalInitMultipartUpload(req.getApiUri(), request);
    }

    private static YopResponse internalInitMultipartUpload(String apiUri, YopRequest request) throws IOException {
        HttpMethodName method = HttpMethodName.POST;
        CheckUtils.checkApiUri(apiUri);
        if (BooleanUtils.isTrue(request.isNeedEncrypt())) {
            YopRsaClient.encryptRequest(request);
        }
        YopRsaClient.sign(apiUri, request, method);
        String contentUrl = YopRsaClient.richRequest(apiUri, request);
        StringBuilder sb = new StringBuilder();
        sb.append(contentUrl).append("?uploads=").append("&bizCode=").append(request.getParamValue("bizCode")).append("&fileName=").append(request.getParamValue("fileName"));
        request.getParams().clear();
        HttpUriRequest httpPost = YopRsaClient.buildFormHttpRequest(request, sb.toString(), method);
        YopResponse response = YopRsaClient.fetchContentByApacheHttpClient(httpPost, new ResponseConfig().withNeedEncrypt(request.isNeedEncrypt()).withEncryptKey(request.getEncryptKey()).withYopPublicKey(InternalConfig.getYopPublicKey(CertTypeEnum.RSA2048)));
        YopRsaClient.handleRsaResult(response);
        return response;
    }

    public static YopResponse uploadPart(UploadPartRequest req) throws IOException {
        CheckUtils.notNull(req, "req");
        CheckUtils.notEmpty(req.getApiUri(), "req.apiUri");
        CheckUtils.notNull(req.getFile(), "req.file");
        CheckUtils.notEmpty(req.getUploadId(), "req.uploadId");
        CheckUtils.notEmpty(req.getBucket(), "req.bucket");
        CheckUtils.notEmpty(req.getKey(), "req.key");
        if ((long)req.getPartSize() > 0x500000L) {
            throw new YopClientException("PartNumber " + req.getPartNumber() + " : Part Size should not be more than 5M.");
        }
        YopRequest request = YopRsaClient.getYopRequest(req.getAppKey(), req.getSecretKey(), req.getNeedEncrypt(), req.getEncryptKey());
        request.addParam("partNumber", req.getPartNumber());
        request.addParam("uploadId", req.getUploadId());
        request.addParam("bucket", req.getBucket());
        request.addParam("key", req.getKey());
        return YopRsaClient.internalUploadPart(req.getApiUri(), request, req.getFile(), req.getPartSize());
    }

    private static YopResponse internalUploadPart(String apiUri, YopRequest request, Object file, int partSize) throws IOException {
        HttpMethodName method = HttpMethodName.PUT;
        CheckUtils.checkApiUri(apiUri);
        if (BooleanUtils.isTrue(request.isNeedEncrypt())) {
            YopRsaClient.encryptRequest(request);
        }
        YopRsaClient.sign(apiUri, request, method);
        String contentUrl = YopRsaClient.richRequest(apiUri, request);
        StringBuilder sb = new StringBuilder();
        sb.append(contentUrl).append("?partNumber=").append(request.getParamValue("partNumber")).append("&uploadId=").append(request.getParamValue("uploadId")).append("&bucket=").append(request.getParamValue("bucket")).append("&key=").append(request.getParamValue("key"));
        request.getParams().clear();
        Pair<HttpUriRequest, CheckedInputStream> pair = YopRsaClient.buildMultiPartUploadRequest(request, sb.toString(), file, partSize);
        YopResponse response = YopRsaClient.fetchContentByApacheHttpClient(pair.getLeft(), new ResponseConfig().withNeedEncrypt(request.isNeedEncrypt()).withEncryptKey(request.getEncryptKey()).withYopPublicKey(InternalConfig.getYopPublicKey(CertTypeEnum.RSA2048)));
        YopRsaClient.handleRsaResult(response);
        if (pair.getRight() != null) {
            YopRsaClient.checkFileIntegrity(response, CRC64Utils.getCRC64(pair.getRight()));
        }
        return response;
    }

    public static YopResponse completeMultipartUpload(CompleteMultipartUploadRequest req) throws IOException {
        CheckUtils.notNull(req, "req");
        CheckUtils.notEmpty(req.getApiUri(), "req.apiUri");
        CheckUtils.notEmpty(req.getUploadId(), "req.uploadId");
        CheckUtils.notEmpty(req.getBucket(), "req.bucket");
        CheckUtils.notEmpty(req.getKey(), "req.key");
        YopRequest request = YopRsaClient.getYopRequest(req.getAppKey(), req.getSecretKey(), req.getNeedEncrypt(), req.getEncryptKey());
        String reqBody = JsonUtils.toJsonString(req);
        return YopRsaClient.internalCompleteMultipartUpload(req.getApiUri(), request, reqBody);
    }

    private static YopResponse internalCompleteMultipartUpload(String apiUri, YopRequest request, String jsonString) throws IOException {
        HttpMethodName method = HttpMethodName.POST;
        CheckUtils.checkApiUri(apiUri);
        if (BooleanUtils.isTrue(request.isNeedEncrypt())) {
            YopRsaClient.encryptRequest(request);
        }
        YopRsaClient.sign(apiUri, request, method);
        String contentUrl = YopRsaClient.richRequest(apiUri, request);
        HttpUriRequest httpPost = YopRsaClient.buildJsonHttpRequest(request, contentUrl, method, jsonString);
        YopResponse response = YopRsaClient.fetchContentByApacheHttpClient(httpPost, new ResponseConfig().withNeedEncrypt(request.isNeedEncrypt()).withEncryptKey(request.getEncryptKey()).withYopPublicKey(InternalConfig.getYopPublicKey(CertTypeEnum.RSA2048)));
        YopRsaClient.handleRsaResult(response);
        return response;
    }

    public static YopResponse abortMultipartUpload(AbortMultipartUploadRequest req) throws IOException {
        CheckUtils.notNull(req, "req");
        CheckUtils.notEmpty(req.getApiUri(), "req.apiUri");
        CheckUtils.notEmpty(req.getUploadId(), "req.uploadId");
        CheckUtils.notEmpty(req.getBucket(), "req.bucket");
        CheckUtils.notEmpty(req.getKey(), "req.key");
        YopRequest request = YopRsaClient.getYopRequest(req.getAppKey(), req.getSecretKey(), req.getNeedEncrypt(), req.getEncryptKey());
        request.addParam("uploadId", req.getUploadId());
        request.addParam("bucket", req.getBucket());
        request.addParam("key", req.getKey());
        return YopRsaClient.internalAbortMultipartUpload(req.getApiUri(), request);
    }

    private static YopRequest getYopRequest(String appKey, String secretKey, Boolean needEncrypt, String encryptKey) {
        YopRequest request = null;
        request = StringUtils.isEmpty(appKey) && StringUtils.isEmpty(secretKey) ? new YopRequest() : (!StringUtils.isEmpty(appKey) && !StringUtils.isEmpty(secretKey) ? new YopRequest(appKey, secretKey) : new YopRequest(appKey));
        request.setNeedEncrypt(needEncrypt);
        request.setEncryptKey(encryptKey);
        return request;
    }

    private static YopResponse internalAbortMultipartUpload(String apiUri, YopRequest request) throws IOException {
        HttpMethodName method = HttpMethodName.DELETE;
        CheckUtils.checkApiUri(apiUri);
        if (BooleanUtils.isTrue(request.isNeedEncrypt())) {
            YopRsaClient.encryptRequest(request);
        }
        YopRsaClient.sign(apiUri, request, method);
        String contentUrl = YopRsaClient.richRequest(apiUri, request);
        StringBuilder sb = new StringBuilder();
        sb.append(contentUrl).append("?uploadId=").append(request.getParamValue("uploadId")).append("&bucket=").append(request.getParamValue("bucket")).append("&key=").append(request.getParamValue("key"));
        request.getParams().clear();
        HttpUriRequest httpPost = YopRsaClient.buildFormHttpRequest(request, sb.toString(), method);
        YopResponse response = YopRsaClient.fetchContentByApacheHttpClient(httpPost, new ResponseConfig().withNeedEncrypt(request.isNeedEncrypt()).withEncryptKey(request.getEncryptKey()).withYopPublicKey(InternalConfig.getYopPublicKey(CertTypeEnum.RSA2048)));
        YopRsaClient.handleRsaResult(response);
        return response;
    }

    public static YopResponse multipartUpload(UploadFileRequest req) throws IOException {
        CheckUtils.notNull(req, "req");
        CheckUtils.notEmpty(req.getApiUri(), "req.apiUri");
        CheckUtils.notEmpty(req.getBizCode(), "req.bizCode");
        CheckUtils.notEmpty(req.getUploadFlag(), "req.uploadFlag");
        CheckUtils.notEmpty(req.getFile(), "req.file");
        YopRequest request = YopRsaClient.getYopRequest(req.getAppKey(), req.getSecretKey(), req.getNeedEncrypt(), req.getEncryptKey());
        request.addParam("bizCode", req.getBizCode());
        if (StringUtils.equals("1", req.getUploadFlag())) {
            return YopRsaClient.callSmallFileUpload(request, req);
        }
        Pair<Boolean, Long> filePropertiesPair = YopRsaClient.getFilePropertiesPair(req.getFile());
        if (filePropertiesPair.getLeft().booleanValue()) {
            return YopRsaClient.uploadFileByFileSize(request, req, filePropertiesPair.getRight());
        }
        request.addNullParam("uploads");
        return YopRsaClient.uploadPartFile(req.getApiUri(), request, req);
    }

    private static YopResponse internalUploadSmallFile(String apiUri, YopRequest request, Object file, int partSize) throws IOException {
        HttpMethodName method = HttpMethodName.PUT;
        CheckUtils.checkApiUri(apiUri);
        if (BooleanUtils.isTrue(request.isNeedEncrypt())) {
            YopRsaClient.encryptRequest(request);
        }
        YopRsaClient.sign(apiUri, request, method);
        String contentUrl = YopRsaClient.richRequest(apiUri, request);
        StringBuilder sb = new StringBuilder();
        sb.append(contentUrl).append("?bizCode=").append(request.getParamValue("bizCode")).append("&fileName=").append(request.getParamValue("fileName"));
        Pair<HttpUriRequest, CheckedInputStream> pair = YopRsaClient.buildMultiPartUploadRequest(request, sb.toString(), file, partSize);
        YopResponse response = YopRsaClient.fetchContentByApacheHttpClient(pair.getLeft(), new ResponseConfig().withNeedEncrypt(request.isNeedEncrypt()).withEncryptKey(request.getEncryptKey()).withYopPublicKey(InternalConfig.getYopPublicKey(CertTypeEnum.RSA2048)));
        YopRsaClient.handleRsaResult(response);
        if (pair.getRight() != null) {
            YopRsaClient.checkFileIntegrity(response, CRC64Utils.getCRC64(pair.getRight()));
        }
        return response;
    }

    private static YopResponse uploadFileByFileSize(YopRequest request, UploadFileRequest req, long fileLength) throws IOException {
        if (fileLength <= 0x500000L) {
            YopRsaClient.setFileName(request, req.getFileName(), req.getFile());
            return YopRsaClient.internalUploadSmallFile(req.getApiUri(), request, req.getFile(), (int)fileLength);
        }
        if (fileLength > 0x1900000L) {
            throw new YopClientException(" one file should not be more than 25M.");
        }
        request.addNullParam("uploads");
        return YopRsaClient.uploadPartFile(req.getApiUri(), request, req);
    }

    private static YopResponse callSmallFileUpload(YopRequest request, UploadFileRequest req) throws IOException {
        YopResponse yopResponse;
        InputStream is = null;
        ByteArrayInputStream bais = null;
        try {
            YopRsaClient.setFileName(request, req.getFileName(), req.getFile());
            Pair<Boolean, InputStream> pair = YopRsaClient.getInputStreamPair(req.getFile());
            is = pair.getRight();
            bais = new ByteArrayInputStream(IOUtil.toByteArray(is, 0x500000L));
            if (is.read() != -1) {
                throw new YopClientException(" one file should not be more than 5M.");
            }
            yopResponse = YopRsaClient.internalUploadSmallFile(req.getApiUri(), request, bais, bais.available());
        }
        catch (Throwable throwable) {
            YopRsaClient.closeStream(is, bais);
            throw throwable;
        }
        YopRsaClient.closeStream(is, bais);
        return yopResponse;
    }

    private static void setFileName(YopRequest request, String fileName, Object file) throws IOException {
        if (StringUtils.isNotEmpty(fileName)) {
            request.addParam("fileName", fileName);
        } else {
            String fileNm = YopRsaClient.getFileName(file);
            if (StringUtils.isNotEmpty(fileNm)) {
                request.addParam("fileName", fileNm);
            } else {
                request.addNullParam("fileName");
            }
        }
    }

    private static void closeStream(InputStream is, ByteArrayInputStream bais) {
        try {
            if (is != null) {
                is.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
        catch (IOException ioEx) {
            LOGGER.error("upload file exception occurred when close stream", ioEx);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static YopResponse uploadPartFile(String apiUri, YopRequest request, UploadFileRequest req) throws IOException {
        block12: {
            is = null;
            bais = null;
            partETags = new ArrayList<PartETag>();
            YopRsaClient.setFileName(request, req.getFileName(), req.getFile());
            YopRsaClient.LOGGER.debug("multipart upload init,req : " + req.toString());
            response = YopRsaClient.internalInitMultipartUpload(apiUri, request);
            YopRsaClient.LOGGER.debug("multipart upload init,res : " + response.toString());
            if (!response.isSuccess()) {
                return response;
            }
            resultMap = (Map)response.getResult();
            uploadId = String.valueOf(resultMap.get("uploadId"));
            bucket = String.valueOf(resultMap.get("bucket"));
            key = String.valueOf(resultMap.get("key"));
            try {
                totalRead = 0L;
                i = 0;
lbl17:
                // 2 sources

                while (true) {
                    uploadYopRequest = YopRsaClient.getYopRequest(req.getAppKey(), req.getSecretKey(), req.getNeedEncrypt(), req.getEncryptKey());
                    startPos = (long)i * 0x500000L;
                    pair = YopRsaClient.getInputStreamPair(req.getFile());
                    skipFlag = pair.getLeft();
                    is = pair.getRight();
                    if (skipFlag.booleanValue()) {
                        is.skip(startPos);
                    }
                    partSize = 0x500000;
                    bytes = new byte[partSize];
                    readed = 0;
                    offset = 0;
                    while (true) {
                        if (offset >= partSize || (readed = is.read(bytes, offset, partSize - offset)) == -1) {
                            if (offset > 0 || readed != -1) break;
                            break block12;
                        }
                        offset += readed;
                    }
                    if ((totalRead += (long)offset) > 0x1900000L) {
                        throw new YopClientException("one file should not be more than 25M.");
                    }
                    bais = new ByteArrayInputStream(bytes, 0, offset);
                    uploadYopRequest.addParam("partNumber", i + 1);
                    uploadYopRequest.addParam("uploadId", uploadId);
                    uploadYopRequest.addParam("bucket", bucket);
                    uploadYopRequest.addParam("key", key);
                    YopRsaClient.LOGGER.debug("multipart upload part,partNumber : " + (i + 1) + " partSize : " + offset);
                    uploadYopResponse = YopRsaClient.internalUploadPart(apiUri, uploadYopRequest, bais, offset);
                    YopRsaClient.LOGGER.debug("multipart upload part,res : " + uploadYopResponse.toString());
                    if (!uploadYopResponse.isSuccess()) {
                        var25_25 = YopRsaClient.callAbortMultipartUpload(request, req, uploadId, bucket, key);
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (Throwable ex) {
                YopRsaClient.LOGGER.error("multipart upload file error ", ex);
                var25_26 = YopRsaClient.callAbortMultipartUpload(request, req, uploadId, bucket, key);
                YopRsaClient.closeStream(is, bais);
                return var25_26;
            }
            catch (Throwable var24_27) {
                YopRsaClient.closeStream(is, bais);
                throw var24_27;
            }
            YopRsaClient.closeStream(is, bais);
            return var25_25;
lbl-1000:
            // 1 sources

            {
                partETags.add(new PartETag(i + 1, uploadYopResponse.getHeaders().get("ETag")));
                ++i;
                ** continue;
            }
        }
        YopRsaClient.closeStream(is, bais);
        completeYopRequest = YopRsaClient.getYopRequest(req.getAppKey(), req.getSecretKey(), req.getNeedEncrypt(), req.getEncryptKey());
        completeMultipartUploadRequest = new CompleteMultipartUploadRequest();
        completeMultipartUploadRequest.setUploadId(uploadId);
        completeMultipartUploadRequest.setBucket(bucket);
        completeMultipartUploadRequest.setKey(key);
        completeMultipartUploadRequest.setParts(partETags);
        reqBody = JsonUtils.toJsonString(completeMultipartUploadRequest);
        YopRsaClient.LOGGER.debug("multipart upload complete,req : " + reqBody);
        completeYopResponse = YopRsaClient.internalCompleteMultipartUpload(apiUri, completeYopRequest, reqBody);
        YopRsaClient.LOGGER.debug("multipart upload complete,res : " + completeYopResponse.toString());
        return completeYopResponse;
    }

    private static YopResponse callAbortMultipartUpload(YopRequest request, UploadFileRequest req, String uploadId, String bucket, String key) throws IOException {
        YopRequest abortYopRequest = YopRsaClient.getYopRequest(req.getAppKey(), req.getSecretKey(), req.getNeedEncrypt(), req.getEncryptKey());
        abortYopRequest.addParam("uploadId", uploadId);
        abortYopRequest.addParam("bucket", bucket);
        abortYopRequest.addParam("key", key);
        YopResponse abortYopResponse = YopRsaClient.internalAbortMultipartUpload(req.getApiUri(), abortYopRequest);
        if (abortYopResponse.isSuccess()) {
            abortYopResponse.setState("FAILURE");
            abortYopResponse.setError(YopRsaClient.getFileUploadError());
            return abortYopResponse;
        }
        return abortYopResponse;
    }

    private static Pair<Boolean, Long> getFilePropertiesPair(Object file) throws IOException {
        long fileLength = 0L;
        if (file instanceof String) {
            fileLength = new FileInputStream(new File((String)file)).available();
            return new ImmutablePair<Boolean, Long>(true, fileLength);
        }
        if (file instanceof File) {
            fileLength = new FileInputStream((File)file).available();
            return new ImmutablePair<Boolean, Long>(true, fileLength);
        }
        if (file instanceof FileInputStream) {
            fileLength = ((FileInputStream)file).available();
            return new ImmutablePair<Boolean, Long>(true, fileLength);
        }
        if (file instanceof InputStream) {
            return new ImmutablePair<Boolean, Long>(false, fileLength);
        }
        throw new YopClientException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b");
    }

    public static Pair<Boolean, InputStream> getInputStreamPair(Object file) throws FileNotFoundException {
        if (file instanceof String) {
            return new ImmutablePair<Boolean, InputStream>(true, new FileInputStream(new File((String)file)));
        }
        if (file instanceof File) {
            return new ImmutablePair<Boolean, InputStream>(true, new FileInputStream((File)file));
        }
        if (file instanceof FileInputStream) {
            return new ImmutablePair<Boolean, InputStream>(false, (FileInputStream)file);
        }
        if (file instanceof InputStream) {
            return new ImmutablePair<Boolean, InputStream>(false, (InputStream)file);
        }
        throw new YopClientException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b");
    }

    public static String getFileName(Object file) throws FileNotFoundException, IOException {
        if (file instanceof String) {
            return new File((String)file).getName();
        }
        if (file instanceof File) {
            return ((File)file).getName();
        }
        if (file instanceof FileInputStream) {
            MarkableFileInputStream in = new MarkableFileInputStream((FileInputStream)file);
            in.mark(0);
            String fileName = FileUtils.getFileName(in);
            in.reset();
            return fileName;
        }
        if (file instanceof InputStream) {
            return "";
        }
        throw new YopClientException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b");
    }
}

