/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nPolynomial;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import java.util.Random;
import java.util.Vector;

public class GF2nPolynomialField
extends GF2nField {
    GF2Polynomial[] squaringMatrix;
    private boolean isTrinomial = false;
    private boolean isPentanomial = false;
    private int tc;
    private int[] pc = new int[3];

    public GF2nPolynomialField(int deg) {
        if (deg < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = deg;
        this.computeFieldPolynomial();
        this.computeSquaringMatrix();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public GF2nPolynomialField(int deg, boolean file) {
        if (deg < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = deg;
        if (file) {
            this.computeFieldPolynomial();
        } else {
            this.computeFieldPolynomial2();
        }
        this.computeSquaringMatrix();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public GF2nPolynomialField(int deg, GF2Polynomial polynomial) throws RuntimeException {
        if (deg < 3) {
            throw new IllegalArgumentException("degree must be at least 3");
        }
        if (polynomial.getLength() != deg + 1) {
            throw new RuntimeException();
        }
        if (!polynomial.isIrreducible()) {
            throw new RuntimeException();
        }
        this.mDegree = deg;
        this.fieldPolynomial = polynomial;
        this.computeSquaringMatrix();
        int k2 = 2;
        for (int j2 = 1; j2 < this.fieldPolynomial.getLength() - 1; ++j2) {
            if (!this.fieldPolynomial.testBit(j2)) continue;
            if (++k2 == 3) {
                this.tc = j2;
            }
            if (k2 > 5) continue;
            this.pc[k2 - 3] = j2;
        }
        if (k2 == 3) {
            this.isTrinomial = true;
        }
        if (k2 == 5) {
            this.isPentanomial = true;
        }
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public boolean isTrinomial() {
        return this.isTrinomial;
    }

    public boolean isPentanomial() {
        return this.isPentanomial;
    }

    public int getTc() throws RuntimeException {
        if (!this.isTrinomial) {
            throw new RuntimeException();
        }
        return this.tc;
    }

    public int[] getPc() throws RuntimeException {
        if (!this.isPentanomial) {
            throw new RuntimeException();
        }
        int[] result = new int[3];
        System.arraycopy(this.pc, 0, result, 0, 3);
        return result;
    }

    public GF2Polynomial getSquaringVector(int i2) {
        return new GF2Polynomial(this.squaringMatrix[i2]);
    }

    @Override
    protected GF2nElement getRandomRoot(GF2Polynomial polynomial) {
        GF2nPolynomial g2 = new GF2nPolynomial(polynomial, this);
        int gDegree = g2.getDegree();
        while (gDegree > 1) {
            GF2nPolynomial h2;
            int hDegree;
            do {
                GF2nPolynomialElement u2 = new GF2nPolynomialElement(this, new Random());
                GF2nPolynomial ut = new GF2nPolynomial(2, GF2nPolynomialElement.ZERO(this));
                ut.set(1, u2);
                GF2nPolynomial c2 = new GF2nPolynomial(ut);
                for (int i2 = 1; i2 <= this.mDegree - 1; ++i2) {
                    c2 = c2.multiplyAndReduce(c2, g2);
                    c2 = c2.add(ut);
                }
                h2 = c2.gcd(g2);
                hDegree = h2.getDegree();
                gDegree = g2.getDegree();
            } while (hDegree == 0 || hDegree == gDegree);
            g2 = hDegree << 1 > gDegree ? g2.quotient(h2) : new GF2nPolynomial(h2);
            gDegree = g2.getDegree();
        }
        return g2.at(0);
    }

    @Override
    protected void computeCOBMatrix(GF2nField B1) {
        GF2nElement[] gamma;
        GF2nElement u2;
        int i2;
        if (this.mDegree != B1.mDegree) {
            throw new IllegalArgumentException("GF2nPolynomialField.computeCOBMatrix: B1 has a different degree and thus cannot be coverted to!");
        }
        if (B1 instanceof GF2nONBField) {
            B1.computeCOBMatrix(this);
            return;
        }
        GF2Polynomial[] COBMatrix = new GF2Polynomial[this.mDegree];
        for (i2 = 0; i2 < this.mDegree; ++i2) {
            COBMatrix[i2] = new GF2Polynomial(this.mDegree);
        }
        while ((u2 = B1.getRandomRoot(this.fieldPolynomial)).isZero()) {
        }
        if (u2 instanceof GF2nONBElement) {
            GF2nONBElement[] gF2nONBElementArray = new GF2nONBElement[this.mDegree];
            gamma = gF2nONBElementArray;
            gF2nONBElementArray[this.mDegree - 1] = GF2nONBElement.ONE((GF2nONBField)B1);
        } else {
            GF2nPolynomialElement[] gF2nPolynomialElementArray = new GF2nPolynomialElement[this.mDegree];
            gamma = gF2nPolynomialElementArray;
            gF2nPolynomialElementArray[this.mDegree - 1] = GF2nPolynomialElement.ONE((GF2nPolynomialField)B1);
        }
        gamma[this.mDegree - 2] = u2;
        for (i2 = this.mDegree - 3; i2 >= 0; --i2) {
            gamma[i2] = (GF2nElement)gamma[i2 + 1].multiply(u2);
        }
        if (B1 instanceof GF2nONBField) {
            for (i2 = 0; i2 < this.mDegree; ++i2) {
                for (int j2 = 0; j2 < this.mDegree; ++j2) {
                    if (!gamma[i2].testBit(this.mDegree - j2 - 1)) continue;
                    COBMatrix[this.mDegree - j2 - 1].setBit(this.mDegree - i2 - 1);
                }
            }
        } else {
            for (i2 = 0; i2 < this.mDegree; ++i2) {
                for (int j3 = 0; j3 < this.mDegree; ++j3) {
                    if (!gamma[i2].testBit(j3)) continue;
                    COBMatrix[this.mDegree - j3 - 1].setBit(this.mDegree - i2 - 1);
                }
            }
        }
        this.fields.addElement(B1);
        this.matrices.addElement(COBMatrix);
        B1.fields.addElement(this);
        B1.matrices.addElement(this.invertMatrix(COBMatrix));
    }

    private void computeSquaringMatrix() {
        int i2;
        GF2Polynomial[] d2 = new GF2Polynomial[this.mDegree - 1];
        this.squaringMatrix = new GF2Polynomial[this.mDegree];
        for (i2 = 0; i2 < this.squaringMatrix.length; ++i2) {
            this.squaringMatrix[i2] = new GF2Polynomial(this.mDegree, "ZERO");
        }
        for (i2 = 0; i2 < this.mDegree - 1; ++i2) {
            d2[i2] = new GF2Polynomial(1, "ONE").shiftLeft(this.mDegree + i2).remainder(this.fieldPolynomial);
        }
        for (i2 = 1; i2 <= Math.abs(this.mDegree >> 1); ++i2) {
            for (int j2 = 1; j2 <= this.mDegree; ++j2) {
                if (!d2[this.mDegree - (i2 << 1)].testBit(this.mDegree - j2)) continue;
                this.squaringMatrix[j2 - 1].setBit(this.mDegree - i2);
            }
        }
        for (i2 = Math.abs(this.mDegree >> 1) + 1; i2 <= this.mDegree; ++i2) {
            this.squaringMatrix[(i2 << 1) - this.mDegree - 1].setBit(this.mDegree - i2);
        }
    }

    @Override
    protected void computeFieldPolynomial() {
        if (this.testTrinomials()) {
            return;
        }
        if (this.testPentanomials()) {
            return;
        }
        this.testRandom();
    }

    protected void computeFieldPolynomial2() {
        if (this.testTrinomials()) {
            return;
        }
        if (this.testPentanomials()) {
            return;
        }
        this.testRandom();
    }

    private boolean testTrinomials() {
        boolean done = false;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        for (int i2 = 1; i2 < this.mDegree && !done; ++i2) {
            this.fieldPolynomial.setBit(i2);
            done = this.fieldPolynomial.isIrreducible();
            if (done) {
                this.isTrinomial = true;
                this.tc = i2;
                return done;
            }
            this.fieldPolynomial.resetBit(i2);
            done = this.fieldPolynomial.isIrreducible();
        }
        return done;
    }

    private boolean testPentanomials() {
        boolean done = false;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        for (int i2 = 1; i2 <= this.mDegree - 3 && !done; ++i2) {
            this.fieldPolynomial.setBit(i2);
            for (int j2 = i2 + 1; j2 <= this.mDegree - 2 && !done; ++j2) {
                this.fieldPolynomial.setBit(j2);
                for (int k2 = j2 + 1; k2 <= this.mDegree - 1 && !done; ++k2) {
                    this.fieldPolynomial.setBit(k2);
                    if ((this.mDegree & 1) != 0 | (i2 & 1) != 0 | (j2 & 1) != 0 | (k2 & 1) != 0 && (done = this.fieldPolynomial.isIrreducible())) {
                        this.isPentanomial = true;
                        this.pc[0] = i2;
                        this.pc[1] = j2;
                        this.pc[2] = k2;
                        return done;
                    }
                    this.fieldPolynomial.resetBit(k2);
                }
                this.fieldPolynomial.resetBit(j2);
            }
            this.fieldPolynomial.resetBit(i2);
        }
        return done;
    }

    private boolean testRandom() {
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        do {
            this.fieldPolynomial.randomize();
            this.fieldPolynomial.setBit(this.mDegree);
            this.fieldPolynomial.setBit(0);
        } while (!this.fieldPolynomial.isIrreducible());
        return true;
    }
}

