/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.cms.CMSAlgorithm;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedDataStreamGenerator;
import com.timevale.tgtext.bouncycastle.cms.SignerInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEException;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEGenerator;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEUtil;
import com.timevale.tgtext.bouncycastle.mail.smime.util.CRLFOutputStream;
import com.timevale.tgtext.bouncycastle.util.Store;
import com.timevale.tgtext.bouncycastle.x509.X509Store;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.activation.c;
import javax.activation.n;
import javax.mail.d;
import javax.mail.internet.j;
import javax.mail.internet.k;
import javax.mail.internet.l;
import javax.mail.q;
import javax.mail.s;

public class SMIMESignedGenerator
extends SMIMEGenerator {
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String DIGEST_RIPEMD128 = TeleTrusTObjectIdentifiers.ripemd128.getId();
    public static final String DIGEST_RIPEMD160 = TeleTrusTObjectIdentifiers.ripemd160.getId();
    public static final String DIGEST_RIPEMD256 = TeleTrusTObjectIdentifiers.ripemd256.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1.getId();
    public static final String ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    public static final String ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS.getId();
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();
    private static final String CERTIFICATE_MANAGEMENT_CONTENT = "application/pkcs7-mime; name=smime.p7c; smime-type=certs-only";
    private static final String DETACHED_SIGNATURE_TYPE = "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data";
    private static final String ENCAPSULATED_SIGNED_CONTENT_TYPE = "application/pkcs7-mime; name=smime.p7m; smime-type=signed-data";
    public static final Map RFC3851_MICALGS;
    public static final Map RFC5751_MICALGS;
    public static final Map STANDARD_MICALGS;
    private final String defaultContentTransferEncoding;
    private final Map micAlgs;
    private List _certStores = new ArrayList();
    private List certStores = new ArrayList();
    private List crlStores = new ArrayList();
    private List attrCertStores = new ArrayList();
    private List signerInfoGens = new ArrayList();
    private List _signers = new ArrayList();
    private List _oldSigners = new ArrayList();
    private List _attributeCerts = new ArrayList();
    private Map _digests = new HashMap();

    private static n addCommands(c c2) {
        n n2 = (n)c2;
        n2.d("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        n2.d("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        n2.d("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        n2.d("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        n2.d("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        return n2;
    }

    public SMIMESignedGenerator() {
        this("7bit", STANDARD_MICALGS);
    }

    public SMIMESignedGenerator(String string) {
        this(string, STANDARD_MICALGS);
    }

    public SMIMESignedGenerator(Map map) {
        this("7bit", map);
    }

    public SMIMESignedGenerator(String string, Map map) {
        this.defaultContentTransferEncoding = string;
        this.micAlgs = map;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws IllegalArgumentException {
        this._signers.add(new b(privateKey, x509Certificate, new ASN1ObjectIdentifier(string), null, null));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws IllegalArgumentException {
        this._signers.add(new b(privateKey, x509Certificate, new ASN1ObjectIdentifier(string), new ASN1ObjectIdentifier(string2), null, null));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this._signers.add(new b(privateKey, x509Certificate, new ASN1ObjectIdentifier(string), attributeTable, attributeTable2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this._signers.add(new b(privateKey, x509Certificate, new ASN1ObjectIdentifier(string), new ASN1ObjectIdentifier(string2), attributeTable, attributeTable2));
    }

    public void addSigners(SignerInformationStore signerInformationStore) {
        Iterator iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            this._oldSigners.add(iterator.next());
        }
    }

    public void addSignerInfoGenerator(SignerInfoGenerator signerInfoGenerator) {
        this.signerInfoGens.add(signerInfoGenerator);
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, SMIMEException {
        this._certStores.add(certStore);
    }

    public void addCertificates(Store store) {
        this.certStores.add(store);
    }

    public void addCRLs(Store store) {
        this.crlStores.add(store);
    }

    public void addAttributeCertificates(Store store) {
        this.attrCertStores.add(store);
    }

    public void addAttributeCertificates(X509Store x509Store) throws CMSException {
        this._attributeCerts.add(x509Store);
    }

    private void addHashHeader(StringBuffer stringBuffer, List list) {
        int n2 = 0;
        Iterator iterator = list.iterator();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = object instanceof b ? ((b)object).c() : (object instanceof SignerInformation ? ((SignerInformation)object).getDigestAlgorithmID().getAlgorithm() : ((SignerInfoGenerator)object).getDigestAlgorithm().getAlgorithm());
            String string = (String)this.micAlgs.get(aSN1ObjectIdentifier);
            if (string == null) {
                treeSet.add("unknown");
                continue;
            }
            treeSet.add(string);
        }
        for (String string : treeSet) {
            if (n2 == 0) {
                if (treeSet.size() != 1) {
                    stringBuffer.append("; micalg=\"");
                } else {
                    stringBuffer.append("; micalg=");
                }
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            ++n2;
        }
        if (n2 != 0 && treeSet.size() != 1) {
            stringBuffer.append('\"');
        }
    }

    private l make(j j2, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            j j3 = new j();
            j3.setContent((Object)new a(j2, false, provider), DETACHED_SIGNATURE_TYPE);
            j3.addHeader("Content-Type", DETACHED_SIGNATURE_TYPE);
            j3.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            j3.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            j3.addHeader("Content-Transfer-Encoding", this.encoding);
            StringBuffer stringBuffer = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"");
            ArrayList arrayList = new ArrayList(this._signers);
            arrayList.addAll(this._oldSigners);
            arrayList.addAll(this.signerInfoGens);
            this.addHashHeader(stringBuffer, arrayList);
            l l2 = new l(stringBuffer.toString());
            l2.b((d)j2);
            l2.b((d)j3);
            return l2;
        }
        catch (q q2) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)q2));
        }
    }

    private l make(j j2) throws SMIMEException {
        try {
            j j3 = new j();
            j3.setContent((Object)new a(j2, false), DETACHED_SIGNATURE_TYPE);
            j3.addHeader("Content-Type", DETACHED_SIGNATURE_TYPE);
            j3.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            j3.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            j3.addHeader("Content-Transfer-Encoding", this.encoding);
            StringBuffer stringBuffer = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"");
            ArrayList arrayList = new ArrayList(this._signers);
            arrayList.addAll(this._oldSigners);
            arrayList.addAll(this.signerInfoGens);
            this.addHashHeader(stringBuffer, arrayList);
            l l2 = new l(stringBuffer.toString());
            l2.b((d)j2);
            l2.b((d)j3);
            return l2;
        }
        catch (q q2) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)q2));
        }
    }

    private j makeEncapsulated(j j2, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            j j3 = new j();
            j3.setContent((Object)new a(j2, true, provider), ENCAPSULATED_SIGNED_CONTENT_TYPE);
            j3.addHeader("Content-Type", ENCAPSULATED_SIGNED_CONTENT_TYPE);
            j3.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            j3.addHeader("Content-Description", "S/MIME Cryptographic Signed Data");
            j3.addHeader("Content-Transfer-Encoding", this.encoding);
            return j3;
        }
        catch (q q2) {
            throw new SMIMEException("exception putting body part together.", (Exception)((Object)q2));
        }
    }

    private j makeEncapsulated(j j2) throws SMIMEException {
        try {
            j j3 = new j();
            j3.setContent((Object)new a(j2, true), ENCAPSULATED_SIGNED_CONTENT_TYPE);
            j3.addHeader("Content-Type", ENCAPSULATED_SIGNED_CONTENT_TYPE);
            j3.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            j3.addHeader("Content-Description", "S/MIME Cryptographic Signed Data");
            j3.addHeader("Content-Transfer-Encoding", this.encoding);
            return j3;
        }
        catch (q q2) {
            throw new SMIMEException("exception putting body part together.", (Exception)((Object)q2));
        }
    }

    public Map getGeneratedDigests() {
        return new HashMap(this._digests);
    }

    public l generate(j j2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(j2), SMIMEUtil.getProvider(string));
    }

    public l generate(j j2, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        return this.make(this.makeContentBodyPart(j2), provider);
    }

    public l generate(k k2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generate(k2, SMIMEUtil.getProvider(string));
    }

    public l generate(k k2, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            k2.b_();
        }
        catch (q q2) {
            throw new SMIMEException("unable to save message", (Exception)((Object)q2));
        }
        return this.make(this.makeContentBodyPart(k2), provider);
    }

    public l generate(j j2) throws SMIMEException {
        return this.make(this.makeContentBodyPart(j2));
    }

    public j generateEncapsulated(j j2) throws SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(j2));
    }

    public j generateEncapsulated(j j2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(j2), SMIMEUtil.getProvider(string));
    }

    public j generateEncapsulated(j j2, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(j2), provider);
    }

    public j generateEncapsulated(k k2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generateEncapsulated(k2, SMIMEUtil.getProvider(string));
    }

    public j generateEncapsulated(k k2, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            k2.b_();
        }
        catch (q q2) {
            throw new SMIMEException("unable to save message", (Exception)((Object)q2));
        }
        return this.makeEncapsulated(this.makeContentBodyPart(k2), provider);
    }

    public j generateCertificateManagement(String string) throws SMIMEException, NoSuchProviderException {
        return this.generateCertificateManagement(SMIMEUtil.getProvider(string));
    }

    public j generateCertificateManagement(Provider provider) throws SMIMEException {
        try {
            j j2 = new j();
            j2.setContent((Object)new a(null, true, provider), CERTIFICATE_MANAGEMENT_CONTENT);
            j2.addHeader("Content-Type", CERTIFICATE_MANAGEMENT_CONTENT);
            j2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7c\"");
            j2.addHeader("Content-Description", "S/MIME Certificate Management Message");
            j2.addHeader("Content-Transfer-Encoding", this.encoding);
            return j2;
        }
        catch (q q2) {
            throw new SMIMEException("exception putting body part together.", (Exception)((Object)q2));
        }
    }

    public j generateCertificateManagement() throws SMIMEException {
        try {
            j j2 = new j();
            j2.setContent((Object)new a(null, true), CERTIFICATE_MANAGEMENT_CONTENT);
            j2.addHeader("Content-Type", CERTIFICATE_MANAGEMENT_CONTENT);
            j2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7c\"");
            j2.addHeader("Content-Description", "S/MIME Certificate Management Message");
            j2.addHeader("Content-Transfer-Encoding", this.encoding);
            return j2;
        }
        catch (q q2) {
            throw new SMIMEException("exception putting body part together.", (Exception)((Object)q2));
        }
    }

    static {
        c.a((c)SMIMESignedGenerator.addCommands(c.a()));
        HashMap<ASN1ObjectIdentifier, String> hashMap = new HashMap<ASN1ObjectIdentifier, String>();
        hashMap.put(CMSAlgorithm.MD5, "md5");
        hashMap.put(CMSAlgorithm.SHA1, "sha-1");
        hashMap.put(CMSAlgorithm.SHA224, "sha-224");
        hashMap.put(CMSAlgorithm.SHA256, "sha-256");
        hashMap.put(CMSAlgorithm.SHA384, "sha-384");
        hashMap.put(CMSAlgorithm.SHA512, "sha-512");
        hashMap.put(CMSAlgorithm.GOST3411, "gostr3411-94");
        RFC5751_MICALGS = Collections.unmodifiableMap(hashMap);
        HashMap<ASN1ObjectIdentifier, String> hashMap2 = new HashMap<ASN1ObjectIdentifier, String>();
        hashMap2.put(CMSAlgorithm.MD5, "md5");
        hashMap2.put(CMSAlgorithm.SHA1, "sha1");
        hashMap2.put(CMSAlgorithm.SHA224, "sha224");
        hashMap2.put(CMSAlgorithm.SHA256, "sha256");
        hashMap2.put(CMSAlgorithm.SHA384, "sha384");
        hashMap2.put(CMSAlgorithm.SHA512, "sha512");
        hashMap2.put(CMSAlgorithm.GOST3411, "gostr3411-94");
        RFC3851_MICALGS = Collections.unmodifiableMap(hashMap2);
        STANDARD_MICALGS = RFC5751_MICALGS;
    }

    private class a
    implements SMIMEStreamingProcessor {
        private final j b;
        private final boolean c;
        private final Provider d;
        private final boolean e;

        a(j j2, boolean bl2, Provider provider) {
            this.b = j2;
            this.c = bl2;
            this.d = provider;
            this.e = false;
        }

        a(j j2, boolean bl2) {
            this.b = j2;
            this.c = bl2;
            this.d = null;
            this.e = true;
        }

        protected CMSSignedDataStreamGenerator a() throws CMSException, CertStoreException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            Iterator iterator = SMIMESignedGenerator.this._certStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addCertificatesAndCRLs((CertStore)iterator.next());
            }
            iterator = SMIMESignedGenerator.this.certStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addCertificates((Store)iterator.next());
            }
            iterator = SMIMESignedGenerator.this.crlStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addCRLs((Store)iterator.next());
            }
            iterator = SMIMESignedGenerator.this.attrCertStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addAttributeCertificates((Store)iterator.next());
            }
            iterator = SMIMESignedGenerator.this._attributeCerts.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addAttributeCertificates((X509Store)iterator.next());
            }
            for (b b2 : SMIMESignedGenerator.this._signers) {
                if (b2.b() != null) {
                    cMSSignedDataStreamGenerator.addSigner(b2.d(), b2.a(), b2.b().getId(), b2.c().getId(), b2.e(), b2.f(), this.d);
                    continue;
                }
                cMSSignedDataStreamGenerator.addSigner(b2.d(), b2.a(), b2.c().getId(), b2.e(), b2.f(), this.d);
            }
            iterator = SMIMESignedGenerator.this.signerInfoGens.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addSignerInfoGenerator((SignerInfoGenerator)iterator.next());
            }
            cMSSignedDataStreamGenerator.addSigners(new SignerInformationStore(SMIMESignedGenerator.this._oldSigners));
            return cMSSignedDataStreamGenerator;
        }

        private void a(OutputStream outputStream, j j2) throws IOException, q {
            if (j2.getContent() instanceof s) {
                s s2 = (s)j2.getContent();
                javax.mail.internet.d d2 = new javax.mail.internet.d(s2.c());
                String string = "--" + d2.a("boundary");
                SMIMEUtil.b b2 = new SMIMEUtil.b(outputStream);
                Enumeration enumeration = j2.getAllHeaderLines();
                while (enumeration.hasMoreElements()) {
                    b2.a((String)enumeration.nextElement());
                }
                b2.a();
                SMIMEUtil.outputPreamble(b2, j2, string);
                for (int i2 = 0; i2 < s2.d(); ++i2) {
                    b2.a(string);
                    this.a(outputStream, (j)s2.a(i2));
                    b2.a();
                }
                b2.a(string + "--");
                return;
            }
            if (SMIMEUtil.isCanonicalisationRequired(j2, SMIMESignedGenerator.this.defaultContentTransferEncoding)) {
                outputStream = new CRLFOutputStream(outputStream);
            }
            j2.writeTo(outputStream);
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            try {
                CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = this.a();
                OutputStream outputStream2 = cMSSignedDataStreamGenerator.open(outputStream, this.c);
                if (this.b != null) {
                    if (!this.c) {
                        this.a(outputStream2, this.b);
                    } else {
                        this.b.getDataHandler().a((c)SMIMESignedGenerator.addCommands(javax.activation.c.a()));
                        this.b.writeTo(outputStream2);
                    }
                }
                outputStream2.close();
                SMIMESignedGenerator.this._digests = cMSSignedDataStreamGenerator.getGeneratedDigests();
                return;
            }
            catch (q q2) {
                throw new IOException(q2.toString());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException(noSuchAlgorithmException.toString());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new IOException(noSuchProviderException.toString());
            }
            catch (CMSException cMSException) {
                throw new IOException(cMSException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IOException(invalidKeyException.toString());
            }
            catch (CertStoreException certStoreException) {
                throw new IOException(certStoreException.toString());
            }
        }
    }

    private class b {
        final PrivateKey a;
        final X509Certificate b;
        final ASN1ObjectIdentifier c;
        final ASN1ObjectIdentifier d;
        final AttributeTable e;
        final AttributeTable f;

        b(PrivateKey privateKey, X509Certificate x509Certificate, ASN1ObjectIdentifier aSN1ObjectIdentifier, AttributeTable attributeTable, AttributeTable attributeTable2) {
            this(privateKey, x509Certificate, null, aSN1ObjectIdentifier, attributeTable, attributeTable2);
        }

        b(PrivateKey privateKey, X509Certificate x509Certificate, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2, AttributeTable attributeTable, AttributeTable attributeTable2) {
            this.a = privateKey;
            this.b = x509Certificate;
            this.c = aSN1ObjectIdentifier;
            this.d = aSN1ObjectIdentifier2;
            this.e = attributeTable;
            this.f = attributeTable2;
        }

        public X509Certificate a() {
            return this.b;
        }

        public ASN1ObjectIdentifier b() {
            return this.c;
        }

        public ASN1ObjectIdentifier c() {
            return this.d;
        }

        public PrivateKey d() {
            return this.a;
        }

        public AttributeTable e() {
            return this.e;
        }

        public AttributeTable f() {
            return this.f;
        }
    }
}

