/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.utils;

import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.shade.com.fasterxml.jackson.annotation.JsonInclude;
import com.yeepay.shade.com.fasterxml.jackson.core.JsonFactory;
import com.yeepay.shade.com.fasterxml.jackson.core.JsonGenerator;
import com.yeepay.shade.com.fasterxml.jackson.core.JsonParseException;
import com.yeepay.shade.com.fasterxml.jackson.core.JsonParser;
import com.yeepay.shade.com.fasterxml.jackson.core.JsonProcessingException;
import com.yeepay.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import com.yeepay.shade.com.fasterxml.jackson.databind.JsonMappingException;
import com.yeepay.shade.com.fasterxml.jackson.databind.JsonNode;
import com.yeepay.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.yeepay.shade.com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter writer;
    private static final ObjectWriter prettyWriter;

    public static String toJsonPrettyString(Object value) throws JsonProcessingException {
        return prettyWriter.writeValueAsString(value);
    }

    public static String toJsonString(Object value) {
        try {
            return writer.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new YopClientException("Unable to parse Json String.", e);
        }
    }

    public static JsonNode jsonNodeOf(String json) {
        return JsonUtils.fromJsonString(json, JsonNode.class);
    }

    public static JsonGenerator jsonGeneratorOf(Writer writer) throws IOException {
        return new JsonFactory().createGenerator(writer);
    }

    public static <T> T loadFrom(File file, Class<T> clazz) throws IOException {
        try {
            return objectMapper.readValue(file, clazz);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void load(InputStream input, Object obj) throws IOException, JsonProcessingException {
        objectMapper.readerForUpdating(obj).readValue(input);
    }

    public static <T> T loadFrom(InputStream input, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return objectMapper.readValue(input, clazz);
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        writer = objectMapper.writer();
        prettyWriter = objectMapper.writerWithDefaultPrettyPrinter();
    }
}

