/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls;

import cfca.sadk.org.bouncycastle.crypto.params.DHParameters;
import cfca.sadk.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsDHUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ServerDHParams {
    protected DHPublicKeyParameters publicKey;

    public ServerDHParams(DHPublicKeyParameters publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("'publicKey' cannot be null");
        }
        this.publicKey = publicKey;
    }

    public DHPublicKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public void encode(OutputStream output) throws IOException {
        DHParameters dhParameters = this.publicKey.getParameters();
        BigInteger Ys = this.publicKey.getY();
        TlsDHUtils.writeDHParameter(dhParameters.getP(), output);
        TlsDHUtils.writeDHParameter(dhParameters.getG(), output);
        TlsDHUtils.writeDHParameter(Ys, output);
    }

    public static ServerDHParams parse(InputStream input) throws IOException {
        BigInteger p = TlsDHUtils.readDHParameter(input);
        BigInteger g = TlsDHUtils.readDHParameter(input);
        BigInteger Ys = TlsDHUtils.readDHParameter(input);
        return new ServerDHParams(new DHPublicKeyParameters(Ys, new DHParameters(p, g)));
    }
}

