/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.provider;

import com.timevale.tgtext.bouncycastle.jce.exception.ExtCertPathBuilderException;
import com.timevale.tgtext.bouncycastle.jce.provider.AnnotatedException;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.jce.provider.CertPathValidatorUtilities;
import com.timevale.tgtext.bouncycastle.util.Selector;
import com.timevale.tgtext.bouncycastle.x509.ExtendedPKIXBuilderParameters;
import com.timevale.tgtext.bouncycastle.x509.X509CertStoreSelector;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    private Exception certPathException;

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection targets;
        if (!(params instanceof PKIXBuilderParameters) && !(params instanceof ExtendedPKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + ExtendedPKIXBuilderParameters.class.getName() + ".");
        }
        ExtendedPKIXBuilderParameters pkixParams = params instanceof ExtendedPKIXBuilderParameters ? (ExtendedPKIXBuilderParameters)params : (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance((PKIXBuilderParameters)params);
        ArrayList certPathList = new ArrayList();
        Selector certSelect = pkixParams.getTargetConstraints();
        if (!(certSelect instanceof X509CertStoreSelector)) {
            throw new CertPathBuilderException("TargetConstraints must be an instance of " + X509CertStoreSelector.class.getName() + " for " + this.getClass().getName() + " class.");
        }
        try {
            targets = CertPathValidatorUtilities.findCertificates((X509CertStoreSelector)certSelect, pkixParams.getStores());
            targets.addAll(CertPathValidatorUtilities.findCertificates((X509CertStoreSelector)certSelect, pkixParams.getCertStores()));
        }
        catch (AnnotatedException e2) {
            throw new ExtCertPathBuilderException("Error finding target certificate.", e2);
        }
        if (targets.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult result = null;
        Iterator targetIter = targets.iterator();
        while (targetIter.hasNext() && result == null) {
            X509Certificate cert = (X509Certificate)targetIter.next();
            result = this.build(cert, pkixParams, certPathList);
        }
        if (result == null && this.certPathException != null) {
            if (this.certPathException instanceof AnnotatedException) {
                throw new CertPathBuilderException(this.certPathException.getMessage(), this.certPathException.getCause());
            }
            throw new CertPathBuilderException("Possible certificate chain could not be validated.", this.certPathException);
        }
        if (result == null && this.certPathException == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return result;
    }

    protected CertPathBuilderResult build(X509Certificate tbvCert, ExtendedPKIXBuilderParameters pkixParams, List tbvPath) {
        CertPathValidator validator;
        CertificateFactory cFact;
        if (tbvPath.contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getExcludedCerts().contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getMaxPathLength() != -1 && tbvPath.size() - 1 > pkixParams.getMaxPathLength()) {
            return null;
        }
        tbvPath.add(tbvCert);
        CertPathBuilderResult builderResult = null;
        try {
            cFact = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME);
            validator = CertPathValidator.getInstance("PKIX", BouncyCastleProvider.PROVIDER_NAME);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception creating support classes.");
        }
        try {
            if (CertPathValidatorUtilities.findTrustAnchor(tbvCert, pkixParams.getTrustAnchors(), pkixParams.getSigProvider()) != null) {
                PKIXCertPathValidatorResult result;
                CertPath certPath;
                try {
                    certPath = cFact.generateCertPath(tbvPath);
                }
                catch (Exception e2) {
                    throw new AnnotatedException("Certification path could not be constructed from certificate list.", e2);
                }
                try {
                    result = (PKIXCertPathValidatorResult)validator.validate(certPath, pkixParams);
                }
                catch (Exception e3) {
                    throw new AnnotatedException("Certification path could not be validated.", e3);
                }
                return new PKIXCertPathBuilderResult(certPath, result.getTrustAnchor(), result.getPolicyTree(), result.getPublicKey());
            }
            try {
                CertPathValidatorUtilities.addAdditionalStoresFromAltNames(tbvCert, pkixParams);
            }
            catch (CertificateParsingException e4) {
                throw new AnnotatedException("No additiontal X.509 stores can be added from certificate locations.", e4);
            }
            HashSet issuers = new HashSet();
            try {
                issuers.addAll(CertPathValidatorUtilities.findIssuerCerts(tbvCert, pkixParams));
            }
            catch (AnnotatedException e5) {
                throw new AnnotatedException("Cannot find issuer certificate for certificate in certification path.", e5);
            }
            if (issuers.isEmpty()) {
                throw new AnnotatedException("No issuer certificate for certificate in certification path found.");
            }
            Iterator it = issuers.iterator();
            while (it.hasNext() && builderResult == null) {
                X509Certificate issuer = (X509Certificate)it.next();
                builderResult = this.build(issuer, pkixParams, tbvPath);
            }
        }
        catch (AnnotatedException e6) {
            this.certPathException = e6;
        }
        if (builderResult == null) {
            tbvPath.remove(tbvCert);
        }
        return builderResult;
    }
}

