/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.util.Base64;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.CFCAStyle;
import cfca.sadk.x509.certificate.CRLStructure;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Date;

abstract class X509CRLBase {
    CRLStructure crlStructure;
    byte[] hashValue;

    X509CRLBase() {
    }

    public final String getIssuer() {
        return this.crlStructure.getIssuer(CFCAStyle.INSTANCE);
    }

    public final String getIssuer(X500NameStyle style) {
        return this.crlStructure.getIssuer(style);
    }

    public final Date getThisUpdate() {
        return this.crlStructure.getThisUpdate();
    }

    public final Date getNextUpdate() {
        return this.crlStructure.getNextUpdate();
    }

    public final byte[] getSignature() {
        return this.crlStructure.getSignature();
    }

    public final String getSignatureAlgName() {
        return this.crlStructure.getSignatureAlgName();
    }

    public final String getSignatureAlgOID() {
        return this.crlStructure.getSignatureAlgOID();
    }

    public final boolean isRevoke(String serialNumber) {
        boolean value = false;
        if (serialNumber != null) {
            try {
                value = this.isRevoke(new BigInteger(serialNumber, 16));
            }
            catch (PKIException e) {
                throw new SecurityException(e.getMessage());
            }
        }
        return value;
    }

    public abstract boolean isRevoke(BigInteger var1) throws PKIException;

    public final boolean verify(PublicKey publicKey) throws PKIException {
        Digest hashEngine;
        String signAlg;
        String oid;
        try {
            oid = this.crlStructure.signatureAlgorithm.getAlgorithm().getId();
            signAlg = this.crlStructure.crlSignType.getSignType(oid);
            hashEngine = this.crlStructure.crlSignType.getDigestEngine(oid);
        }
        catch (Exception e) {
            throw new PKIException("CrlFile verify failure with invalid signatureAlgorithm-->" + this.crlStructure.signatureAlgorithm.getAlgorithm(), e);
        }
        if (signAlg.toUpperCase().indexOf(publicKey.getAlgorithm().toUpperCase()) < 0) {
            return false;
        }
        boolean smFlag = false;
        if (hashEngine instanceof SM3Digest) {
            SM2PublicKey sm2PublicKey;
            if (!"SM2".equalsIgnoreCase(publicKey.getAlgorithm())) {
                throw new PKIException("CrlFile verify failure with cert not match  signatureAlgorithm --> " + oid);
            }
            try {
                sm2PublicKey = new SM2PublicKey(publicKey.getEncoded());
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure with invalid encoding of SM2PublicKey", e);
            }
            try {
                byte[] zvalue = sm2PublicKey.getDefaultZ();
                hashEngine.update(zvalue, 0, zvalue.length);
                smFlag = true;
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure with invalid ZValue", e);
            }
        }
        if (this.hashValue == null || smFlag) {
            this.hashValue = this.hash(hashEngine);
        }
        byte[] signature = null;
        if (smFlag && this.crlStructure.signatureValue.length != 64) {
            try {
                signature = new ASN1SM2Signature(this.crlStructure.signatureValue).getRS();
            }
            catch (Exception e) {
                throw new PKIException("CrlFile verify failure when find invalid SM2Signature encoding", e);
            }
        } else {
            signature = this.crlStructure.signatureValue;
        }
        boolean passed = false;
        try {
            byte[] base64P1SignedData = Base64.encode(signature);
            String deviceName = "JSOFT_LIB";
            JCrypto.getInstance().initialize("JSOFT_LIB", null);
            Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
            passed = new Signature().p1VerifyByHash(signAlg, this.hashValue, base64P1SignedData, publicKey, session);
        }
        catch (Exception e) {
            throw new PKIException("CrlFile verify failure when doing verify", e);
        }
        return passed;
    }

    public abstract byte[] hash(Digest var1) throws PKIException;
}

