/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.ocsp;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPResponse;
import cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import cfca.sadk.org.bouncycastle.asn1.ocsp.ResponseBytes;
import cfca.sadk.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import cfca.sadk.org.bouncycastle.cert.ocsp.OCSPResp;
import java.io.IOException;

public class OCSPRespGenerator {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;

    public OCSPResp generate(int status, Object response) throws PKIException, IOException {
        if (response == null) {
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), null));
        }
        BasicOCSPResp r = (BasicOCSPResp)response;
        DEROctetString octs = new DEROctetString(r.getEncoded());
        ResponseBytes rb = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, octs);
        return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), rb));
    }
}

