/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.agreement.kdf;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.DerivationFunction;
import com.timevale.tgtext.bouncycastle.crypto.DerivationParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import com.timevale.tgtext.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.KDFParameters;
import java.io.IOException;

public class ECDHKEKGenerator
implements DerivationFunction {
    private DerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    @Override
    public void init(DerivationParameters param) {
        DHKDFParameters params = (DHKDFParameters)param;
        this.algorithm = params.getAlgorithm();
        this.keySize = params.getKeySize();
        this.z = params.getZ();
    }

    @Override
    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(new AlgorithmIdentifier(this.algorithm, (ASN1Encodable)DERNull.INSTANCE));
        v2.add(new DERTaggedObject(true, 2, new DEROctetString(this.integerToBytes(this.keySize))));
        try {
            this.kdf.init(new KDFParameters(this.z, new DERSequence(v2).getEncoded("DER")));
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("unable to initialise kdf: " + e2.getMessage());
        }
        return this.kdf.generateBytes(out, outOff, len);
    }

    private byte[] integerToBytes(int keySize) {
        byte[] byArray = new byte[4];
        byte[] val = byArray;
        byArray[0] = keySize >> 24;
        val[1] = (byte)(keySize >> 16);
        val[2] = (byte)(keySize >> 8);
        val[3] = (byte)keySize;
        return val;
    }
}

